/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.biz.balance.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.DataType;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.biz.balance.model.BalTbUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DataSetDataType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.balance.BizDataType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.balance.BalanceEntity;
import kd.bos.metadata.balance.BalanceRuleCacheUtils;
import kd.bos.metadata.balance.RuntimeBalanceInfoMeta;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.StringUtils;

@SdkPublic
public class BalanceTB
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, BalanceTB> CACHE_TB = new ConcurrentHashMap<String, BalanceTB>();
    private static final Map<String, Long> CAHCE_TB_VERSION = new ConcurrentHashMap<String, Long>();
    private Long version = -1L;
    private String name;
    private DBRoute dbRoute;
    private String tb;
    private String snapshotTb;
    private List<String> keyCols;
    private Map<String, String> colFieldMap;
    private String mainOccCol;
    private String type;
    private String periodCol;
    private String endPeriodCol;
    private String modifyTimeCol;
    private Map<BizDataType, Set<String>> colType;
    private boolean isPerBal;
    private Map<String, String> colTbMap;
    private boolean enable;
    private String snapshotPolicy;
    private List<String> plugins;
    private Map<String, DataType> keyColType;
    private Map<String, DataType> coverColType;
    private boolean onlyMainTb;
    private String updateType = "A";
    private final TBChecker txTbChecker = new TBChecker();
    private final TBChecker asyncInfoTbChecker = new TBChecker();
    private final TBChecker tempAsyncInfoTbChecker = new TBChecker();
    private String updateLockTb;
    private String colBackTb;
    private Map<String, List<String>> updateSql;
    private Map<String, List<String>> updateSql4Rollback;
    private Map<String, List<String>> updateQtySql;
    private Map<String, List<String>> updateCoverSql;
    private Map<String, List<String>> updateModifyTimeSql;
    private final Map<String, String> oldColCache = new ConcurrentHashMap<String, String>(32);
    private List<String> insertCols;
    private List<String> insertFields;
    private final ConcurrentHashMap<String, String> occAppCache = new ConcurrentHashMap(4);
    private List<String> colList4RecordSplit;

    public String getUpdateType() {
        return this.updateType;
    }

    public boolean isAsyncUpdate() {
        return "C".equals(this.updateType);
    }

    public boolean isPartAsyncUpdate() {
        return "B".equals(this.updateType);
    }

    public boolean isSyncUpdate() {
        return "A".equals(this.updateType);
    }

    public Set<String> getColsByDataType(BizDataType ... types) {
        HashSet<String> cols = new HashSet<String>(8);
        if (types != null) {
            for (BizDataType type : types) {
                Set<String> tempCols = this.colType.get(type);
                if (tempCols == null || tempCols.isEmpty()) continue;
                cols.addAll(tempCols);
            }
        }
        return cols;
    }

    public Set<String> getAllTypeCols() {
        HashSet<String> cols = new HashSet<String>(8);
        for (Set<String> value : this.colType.values()) {
            cols.addAll(value);
        }
        return cols;
    }

    public String getPeriodCol() {
        return this.periodCol;
    }

    public String getEndPeriodCol() {
        return this.endPeriodCol;
    }

    public Map<String, DataType> getKeyColType() {
        return this.keyColType;
    }

    public Map<String, DataType> getCoverColType() {
        return this.coverColType;
    }

    public Long getVersion() {
        return this.version;
    }

    public static Long getLocalVersion(String balanceTb) {
        String cacheKey = CacheKeyUtil.getAcctId() + balanceTb;
        return CAHCE_TB_VERSION.get(cacheKey);
    }

    public static BalanceTB getBalanceTB(String balanceTb) {
        String cacheKey = CacheKeyUtil.getAcctId() + balanceTb;
        Long localVersion = BalanceTB.getLocalVersion(balanceTb);
        Long cacheVersion = BalanceRuleCacheUtils.getBalTBVersion((String)balanceTb);
        if (cacheVersion == null) {
            CACHE_TB.remove(cacheKey);
            localVersion = BalanceRuleCacheUtils.updateBalVersion((String)balanceTb);
            CAHCE_TB_VERSION.put(cacheKey, localVersion);
        } else if (!cacheVersion.equals(localVersion)) {
            CACHE_TB.remove(cacheKey);
            localVersion = cacheVersion;
            CAHCE_TB_VERSION.put(cacheKey, localVersion);
        }
        BalanceTB tb = CACHE_TB.get(cacheKey);
        if (tb == null) {
            tb = new BalanceTB();
            tb.version = localVersion;
            tb.init(balanceTb);
            CACHE_TB.put(cacheKey, tb);
        }
        return tb;
    }

    private BalanceTB() {
    }

    private RuntimeBalanceInfoMeta getBalanceInfo(String balanceTb) {
        String id = new MetadataReader().loadIdByNumber(balanceTb, MetaCategory.Entity);
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        EntityMetadata meta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Entity);
        BalanceEntity entity = (BalanceEntity)meta.getRootEntity();
        RuntimeBalanceInfoMeta balMeta = entity.buildBalanceInfoMeta(meta);
        this.type = balMeta.getBalanceType();
        if (!"period".equals(this.type) && !"realtime".equals(this.type)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u4f59\u989d\u7c7b\u578btype={0}\u3002", (String)"BalanceTB_0", (String)"bos-biz-balance", (Object[])new Object[]{this.type}));
        }
        this.isPerBal = "period".equals(this.type);
        this.updateType = balMeta.getUpdatePolicy();
        if (!("A".equals(this.updateType) || "B".equals(this.updateType) || "C".equals(this.updateType))) {
            this.updateType = "A";
        }
        return balMeta;
    }

    public String getType() {
        return this.type;
    }

    private void init(String balanceTb) {
        BalLogUtil.info("BalanceTB init start:" + balanceTb, new Object[0]);
        RuntimeBalanceInfoMeta info = this.getBalanceInfo(balanceTb);
        if (info == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f59\u989d\u8868{0}\u4e0d\u5b58\u5728\u3002", (String)"BalanceTB_1", (String)"bos-biz-balance", (Object[])new Object[]{balanceTb}));
        }
        this.name = balanceTb;
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)this.name);
        this.dbRoute = DBRoute.of((String)entityType.getDBRouteKey());
        this.tb = info.getTableName();
        this.snapshotTb = info.getSnapshotTable();
        this.snapshotPolicy = info.getSnapshotPolicy();
        this.enable = "0".equals(info.getSysStatus()) && "0".equals(info.getCustStatus());
        this.colType = this.loadBizData(info.getFieldsXML());
        ArrayList<String> localDimCols = new ArrayList<String>(16);
        localDimCols.addAll(this.getColsByDataType(BizDataType.DIM, BizDataType.MAIN));
        Collections.sort(localDimCols);
        this.keyCols = Collections.unmodifiableList(localDimCols);
        Map cols = entityType.getAllFields();
        HashMap<String, String> colMap = new HashMap<String, String>(cols.size());
        HashMap<String, String> colTbMap = new HashMap<String, String>(cols.size());
        for (IDataEntityProperty col : cols.values()) {
            colMap.put(col.getName(), col.getAlias());
            String group = col.getTableGroup();
            colTbMap.put(col.getName(), group == null ? "" : "_" + group);
        }
        this.colFieldMap = Collections.unmodifiableMap(colMap);
        this.colTbMap = Collections.unmodifiableMap(colTbMap);
        this.parsePlugins(info.getPluginClass());
        this.mainOccCol = info.getMainOccCol();
        if (this.isPerBal) {
            Set<String> col = this.getColsByDataType(BizDataType.PER);
            if (col.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f59\u989d\u8868{0}\u4e0d\u5b58\u5728\u671f\u95f4\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u5143\u6570\u636e\u3002", (String)"BalanceTB_2", (String)"bos-biz-balance", (Object[])new Object[]{balanceTb}));
            }
            this.periodCol = (String)col.toArray()[0];
            col = this.getColsByDataType(BizDataType.ENDPER);
            if (col.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f59\u989d\u8868{0}\u4e0d\u5b58\u5728\u7ed3\u675f\u671f\u95f4\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u5143\u6570\u636e\u3002", (String)"BalanceTB_3", (String)"bos-biz-balance", (Object[])new Object[]{balanceTb}));
            }
            this.endPeriodCol = (String)col.toArray()[0];
        } else {
            this.keyColType = Collections.unmodifiableMap(this.buildColDataType(cols, this.keyCols));
        }
        this.coverColType = Collections.unmodifiableMap(this.buildColDataType(cols, this.getCoverCols()));
        Set<String> mtCols = this.getColsByDataType(BizDataType.MT);
        if (!mtCols.isEmpty()) {
            this.modifyTimeCol = mtCols.toArray(new String[0])[0];
        }
        this.setInsertCols();
        this.onlyMainTb = this.isOnlyMainTb();
        this.initOccTb();
        BalLogUtil.info("BalanceTB init end", new Object[0]);
    }

    private boolean isOnlyMainTb() {
        Set<String> cols = this.getColsByDataType(BizDataType.OCC, BizDataType.COVER);
        if (this.modifyTimeCol != null) {
            cols.add(this.modifyTimeCol);
        }
        for (String col : cols) {
            if ("".equals(this.colTbMap.get(col))) continue;
            return false;
        }
        return true;
    }

    public String getModifyTimeCol() {
        return this.modifyTimeCol;
    }

    private void checkAndCreateUpdateLockTb(String updateLockTb) {
        if (!DB.exitsTable((DBRoute)this.dbRoute, (String)updateLockTb)) {
            String[] sqls = BalTbUtil.getCreateUpdateLockTbSQL(updateLockTb);
            BalTbUtil.executeDDL(this.dbRoute, sqls);
        }
    }

    private Map<String, DataType> buildColDataType(Map<String, IDataEntityProperty> colPros, Collection<String> cols) {
        HashMap<String, DataType> colDataTypes = new HashMap<String, DataType>(32);
        for (String col : cols) {
            IDataEntityProperty pro = colPros.get(col);
            if (pro == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f59\u989d\u8868{0}\u4e0d\u5b58\u5728\u5b57\u6bb5{1}\uff0c\u8bf7\u68c0\u67e5\u5143\u6570\u636e\u3002", (String)"BalanceTB_4", (String)"bos-biz-balance", (Object[])new Object[]{this.name, col}));
            }
            if (pro instanceof IComplexProperty) {
                pro = ((IComplexProperty)pro).getComplexType().getPrimaryKey();
            }
            colDataTypes.put(col, DataSetDataType.getDataType((Class)pro.getPropertyType()));
        }
        return colDataTypes;
    }

    public String getUpdateLockTb() {
        if (this.updateLockTb == null) {
            String tb = this.getTb() + "_kl";
            tb = tb.toUpperCase(Locale.ENGLISH);
            this.checkAndCreateUpdateLockTb(tb);
            this.updateLockTb = tb;
        }
        return this.updateLockTb;
    }

    public String getColBackTb() {
        if (this.colBackTb == null && this.isRealBal()) {
            String tb = this.getTb() + "_kb";
            tb = tb.toUpperCase(Locale.ENGLISH);
            this.checkAndCreateColBackTb(tb);
            this.colBackTb = tb;
        }
        return this.colBackTb;
    }

    private void checkAndCreateColBackTb(String tb) {
        if (!DB.exitsTable((DBRoute)this.dbRoute, (String)tb)) {
            String[] sqls = BalTbUtil.getCreateColBackSQL(tb);
            BalTbUtil.executeDDL(this.dbRoute, sqls);
        }
    }

    private void initOccTb() {
        QFilter fs = new QFilter("bal", "=", (Object)this.name);
        DynamicObjectCollection occInfos = QueryServiceHelper.query((String)"bal_occurred_dbs", (String)"app,type", (QFilter[])fs.toArray());
        for (DynamicObject occInfo : occInfos) {
            String cacheKey = occInfo.getString("app") + occInfo.getString("type");
            if (cacheKey.isEmpty()) continue;
            this.occAppCache.put(cacheKey, cacheKey);
        }
    }

    public String getOrCreateTxTb(DBRoute occDb) {
        String tb = this.getTb() + "_tx";
        this.txTbChecker.checkOrCreateTB(occDb, tb, BalTbUtil::getCreateTxTbSQL);
        return tb;
    }

    public String getOrCreateAsyncInfoTb(DBRoute occDb) {
        String tb = this.getTb() + "_as";
        this.asyncInfoTbChecker.checkOrCreateTB(occDb, tb, BalTbUtil::getCreateAsyncInfoTbSQL);
        return tb;
    }

    public String getOrCreateTempAsyncInfoTb(DBRoute occDb) {
        String tb = this.getTb() + "_aq";
        this.tempAsyncInfoTbChecker.checkOrCreateTB(occDb, tb, BalTbUtil::getCreateTempAsyncInfoTbSQL);
        return tb;
    }

    public String getSnapshotPolicy() {
        return this.snapshotPolicy;
    }

    public String getMainOccCol() {
        return this.mainOccCol;
    }

    private Map<BizDataType, Set<String>> loadBizData(String fieldsXML) {
        Map dataMap = (Map)SerializationUtils.fromJsonString((String)fieldsXML, Map.class);
        HashMap<BizDataType, Set<String>> result = new HashMap<BizDataType, Set<String>>(8);
        for (Map.Entry data : dataMap.entrySet()) {
            BizDataType bizType = BizDataType.getType((String)((String)data.getValue()));
            Set cols = result.computeIfAbsent(bizType, k -> new HashSet());
            cols.add(data.getKey());
        }
        return result;
    }

    private void parsePlugins(String plugins) {
        if (!StringUtils.isBlank((CharSequence)plugins)) {
            List tempPlugins = SerializationUtils.fromJsonStringToList((String)plugins, String.class);
            this.plugins = Collections.unmodifiableList(tempPlugins);
        } else {
            this.plugins = Collections.EMPTY_LIST;
        }
    }

    public List<String> getPlugins() {
        return this.plugins;
    }

    public Map<String, String> getColFieldMap() {
        return this.colFieldMap;
    }

    public String getName() {
        return this.name;
    }

    public String getTb() {
        return this.tb;
    }

    public String getSnapshotTb() {
        return this.snapshotTb;
    }

    public String getTmpSnapshotTb() {
        return this.tb + "_tp";
    }

    public DBRoute getDbRoute() {
        return this.dbRoute;
    }

    public List<String> getKeyCols() {
        return this.keyCols;
    }

    public Set<String> getOccCols() {
        return this.getColsByDataType(BizDataType.OCC);
    }

    public Set<String> getCoverCols() {
        return this.getColsByDataType(BizDataType.COVER);
    }

    public static String parse2SnapName(String flag) {
        return flag + "_sp";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceTB balanceTB = (BalanceTB)o;
        return Objects.equals(this.version, balanceTB.version) && Objects.equals(this.name, balanceTB.name);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public Map<String, String> getColTbMap() {
        return this.colTbMap;
    }

    public Map<String, List<String>> getUpdateQtySql() {
        if (this.updateQtySql == null) {
            Set<String> qtyCols = this.isPerBal ? this.getColsByDataType(BizDataType.INIT) : this.getColsByDataType(BizDataType.OCC);
            this.updateQtySql = this.parseUpdateSql(qtyCols, Collections.emptySet(), false);
        }
        return this.updateQtySql;
    }

    public Map<String, List<String>> getUpdateModifyTimeSql() {
        if (this.updateModifyTimeSql == null) {
            Map tempSqls;
            if (this.modifyTimeCol == null) {
                tempSqls = Collections.emptyMap();
            } else {
                tempSqls = new HashMap(1);
                ArrayList<String> cols = new ArrayList<String>(3);
                StringBuilder sql = new StringBuilder(" UPDATE ");
                sql.append(this.getTb()).append(" SET ").append(this.colFieldMap.get(this.modifyTimeCol));
                sql.append("= ? ").append(" WHERE ").append("fkeycol").append("=? ");
                cols.add(this.modifyTimeCol);
                cols.add("keycol");
                if (this.isPerBal) {
                    sql.append(" AND ").append(this.colFieldMap.get(this.periodCol)).append(">=? ");
                    cols.add(this.periodCol);
                }
                tempSqls.put(sql.toString(), Collections.unmodifiableList(cols));
            }
            this.updateModifyTimeSql = Collections.unmodifiableMap(tempSqls);
        }
        return this.updateModifyTimeSql;
    }

    public Map<String, List<String>> getUpdateSql(boolean isRollback) {
        Map<String, List<String>> tempSql;
        if (!this.onlyMainTb) {
            return null;
        }
        Map<String, List<String>> map = tempSql = isRollback ? this.updateSql4Rollback : this.updateSql;
        if (tempSql == null) {
            Set<String> qtyCols = this.isPerBal ? this.getColsByDataType(BizDataType.INIT) : this.getColsByDataType(BizDataType.OCC);
            tempSql = this.parseUpdateSql(qtyCols, isRollback ? Collections.emptySet() : this.getCoverCols(), true);
            if (isRollback) {
                this.updateSql4Rollback = tempSql;
            } else {
                this.updateSql = tempSql;
            }
        }
        return tempSql;
    }

    private Map<String, List<String>> parseUpdateSql(Set<String> qtyCols, Set<String> coverCols, boolean addModifyTimeCol) {
        HashMap<String, List<String>> colGroup = new HashMap<String, List<String>>(4);
        this.groupCols(colGroup, qtyCols);
        this.groupCols(colGroup, coverCols);
        HashMap<String, List<String>> sqls = new HashMap<String, List<String>>(4);
        for (Map.Entry entry : colGroup.entrySet()) {
            String tb = (String)entry.getKey();
            List tbCols = (List)entry.getValue();
            if (this.isPerBal) {
                if (StringUtils.isBlank((CharSequence)tb)) {
                    this.addPeriodMainTbSql(sqls, tbCols, qtyCols, addModifyTimeCol);
                } else {
                    this.addPeriodExtTbSql(sqls, tb, tbCols, qtyCols);
                }
                if (qtyCols.isEmpty()) continue;
                this.addYearPeriodSql(sqls, tb, (List)colGroup.get(tb), qtyCols);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)tb)) {
                this.addRealMainTbSql(sqls, tbCols, qtyCols, addModifyTimeCol);
                continue;
            }
            this.addRealExtTbSql(sqls, tb, tbCols, qtyCols);
        }
        return Collections.unmodifiableMap(sqls);
    }

    public Map<String, List<String>> getUpdateCoverSqls(Set<String> coverCols) {
        if (coverCols.isEmpty()) {
            return Collections.emptyMap();
        }
        Set<String> qtyCols = Collections.emptySet();
        return this.parseUpdateSql(qtyCols, coverCols, false);
    }

    public Map<String, List<String>> getUpdateCoverSqls() {
        return this.updateCoverSql == null ? (this.updateCoverSql = this.getUpdateCoverSqls(this.getCoverCols())) : this.updateCoverSql;
    }

    private void addRealExtTbSql(Map<String, List<String>> sqls, String tbExt, List<String> allCols, Set<String> occCols) {
        StringBuilder sql = new StringBuilder(" UPDATE ");
        sql.append(this.tb).append(tbExt).append(" SET ");
        this.concatSet(allCols, occCols, sql);
        sql.append(" WHERE ").append("fid").append("= (SELECT ");
        sql.append("fid").append(" FROM ").append(this.tb);
        sql.append(" WHERE ").append("fkeycol").append("=?)");
        List<String> cols = new ArrayList<String>(allCols.size());
        for (String allCol : allCols) {
            if (!occCols.contains(allCol)) {
                cols.add(BalanceTB.parseCoverFlag(allCol));
            }
            cols.add(allCol);
        }
        cols.add("keycol");
        cols = Collections.unmodifiableList(cols);
        sqls.put(sql.toString(), cols);
    }

    private void addRealMainTbSql(Map<String, List<String>> sqls, List<String> allCols, Set<String> occCols, boolean addModifyTimeCol) {
        StringBuilder sql = new StringBuilder(" UPDATE ");
        sql.append(this.tb).append(" SET ");
        this.concatSet(allCols, occCols, sql);
        List<String> cols = new ArrayList<String>(allCols.size());
        for (String allCol : allCols) {
            if (!occCols.contains(allCol)) {
                cols.add(BalanceTB.parseCoverFlag(allCol));
            }
            cols.add(allCol);
        }
        if (addModifyTimeCol && this.modifyTimeCol != null) {
            sql.append(',').append(this.colFieldMap.get(this.modifyTimeCol)).append(" = ? ");
            cols.add(this.modifyTimeCol);
        }
        sql.append(" WHERE ").append("fkeycol").append("=?");
        cols.add("keycol");
        cols = Collections.unmodifiableList(cols);
        sqls.put(sql.toString(), cols);
    }

    private void concatSet(List<String> allCols, Set<String> occCols, StringBuilder sql) {
        int i = 0;
        for (String col : allCols) {
            String fcol = this.colFieldMap.get(col);
            if (i > 0) {
                sql.append(',');
            }
            if (occCols.contains(col)) {
                sql.append(fcol).append('=').append(fcol).append("+?");
            } else {
                this.appendSetCoverCol(sql, fcol);
            }
            ++i;
        }
    }

    private void groupCols(Map<String, List<String>> colsGroup, Collection<String> cols) {
        Map<String, String> colTbMap = this.getColTbMap();
        for (String qtyCol : cols) {
            String tempTb = colTbMap.get(qtyCol);
            List tempCols = colsGroup.computeIfAbsent(tempTb, k -> new ArrayList(16));
            tempCols.add(qtyCol);
        }
    }

    private void addYearPeriodSql(Map<String, List<String>> sqls, String tbExt, List<String> allCols, Set<String> qtyCols) {
        int size = allCols.size() * 2;
        ArrayList<String> setParts = new ArrayList<String>(size);
        ArrayList<String> params = new ArrayList<String>(size + 3);
        this.parseSetPartAndParams(allCols, setParts, params, qtyCols);
        if (!params.isEmpty()) {
            String fperiodCol = this.colFieldMap.get(this.periodCol);
            String fendPeriodCol = this.colFieldMap.get(this.endPeriodCol);
            StringBuilder sql = new StringBuilder(" UPDATE ");
            sql.append(this.tb).append(tbExt).append(" SET ");
            sql.append(String.join((CharSequence)",", setParts));
            if (StringUtils.isBlank((CharSequence)tbExt)) {
                sql.append(" WHERE ").append("fkeycol").append("=? AND ");
                sql.append(fperiodCol).append(">=? AND ").append(fperiodCol).append("<? AND ").append(fendPeriodCol).append(">? ");
            } else {
                sql.append(" WHERE ").append("fid");
                sql.append(" IN (SELECT ").append("fid").append(" FROM ").append(this.tb);
                sql.append(" WHERE ").append("fkeycol").append(" = ? AND ");
                sql.append(fperiodCol).append(">=? AND ").append(fperiodCol).append("<? AND ").append(fendPeriodCol).append(">? ) ");
            }
            params.add("keycol");
            params.add("per_year_start");
            params.add("per_year_end");
            params.add("per_year_start");
            sqls.put(sql.toString(), params);
        }
    }

    private void parseSetPartAndParams(List<String> allCols, List<String> setParts, List<String> params, Set<String> qtyCols) {
        Set<String> tbYearQtyCols = this.getColsByDataType(BizDataType.YEAR_IN, BizDataType.YEAR_OUT);
        for (String col : allCols) {
            String fyearCol;
            if (!qtyCols.contains(col)) continue;
            String yearCol = col + "_yearin";
            if (tbYearQtyCols.contains(yearCol)) {
                fyearCol = this.colFieldMap.get(yearCol);
                setParts.add(fyearCol + "=" + fyearCol + " + ? ");
                params.add(col + "_in");
            }
            if (!tbYearQtyCols.contains(yearCol = col + "_yearout")) continue;
            fyearCol = this.colFieldMap.get(yearCol);
            setParts.add(fyearCol + "=" + fyearCol + " + ? ");
            params.add(col + "_out");
        }
    }

    private void addPeriodExtTbSql(Map<String, List<String>> sqls, String tbExt, List<String> allCols, Set<String> qtyCols) {
        StringBuilder sql1 = new StringBuilder(" UPDATE ");
        sql1.append(this.tb).append(tbExt).append(" SET ");
        StringBuilder sql2 = new StringBuilder(" UPDATE ");
        sql2.append(this.tb).append(tbExt).append(" SET ");
        List<String> paramCols1 = new ArrayList<String>(allCols.size() * 4);
        List<String> paramCols2 = new ArrayList<String>(allCols.size() * 2);
        Map<String, String> colFieldMap = this.getColFieldMap();
        String fperiodCol = colFieldMap.get(this.periodCol);
        String fendPeriodCol = colFieldMap.get(this.endPeriodCol);
        int i = 0;
        boolean hasQtyCols = false;
        for (String setCol : allCols) {
            if (i++ > 0) {
                sql1.append(',');
                sql2.append(',');
            }
            if (qtyCols.contains(setCol)) {
                hasQtyCols = true;
                String inQtyCol = setCol + "_in";
                String outQtyCol = setCol + "_out";
                String balQtyCol = setCol + "_bal";
                String fqtyCol = colFieldMap.get(setCol);
                String finQtyCol = colFieldMap.get(inQtyCol);
                String foutQtyCol = colFieldMap.get(outQtyCol);
                String fbalQtyCol = colFieldMap.get(balQtyCol);
                sql1.append(fqtyCol).append(" = ").append(fqtyCol).append(" + ?,");
                sql1.append(finQtyCol).append(" = ").append(finQtyCol).append(" + ?,");
                sql1.append(foutQtyCol).append(" = ").append(foutQtyCol).append(" + ?,");
                sql1.append(fbalQtyCol).append(" = ").append(fbalQtyCol).append(" + ? ");
                paramCols1.add(setCol);
                paramCols1.add(inQtyCol);
                paramCols1.add(outQtyCol);
                paramCols1.add(balQtyCol);
                sql2.append(fqtyCol).append(" = ").append(fqtyCol).append(" + ?,");
                sql2.append(fbalQtyCol).append(" = ").append(fbalQtyCol).append(" + ? ");
                paramCols2.add(balQtyCol);
                paramCols2.add(balQtyCol);
                continue;
            }
            this.appendSetCoverCol(sql1, colFieldMap.get(setCol));
            this.appendSetCoverCol(sql2, colFieldMap.get(setCol));
            paramCols1.add(BalanceTB.parseCoverFlag(setCol));
            paramCols1.add(setCol);
            paramCols2.add(BalanceTB.parseCoverFlag(setCol));
            paramCols2.add(setCol);
        }
        sql1.append(" WHERE ").append("fid");
        sql1.append(" IN (SELECT ").append("fid").append(" FROM ").append(this.tb);
        sql1.append(" WHERE ").append("fkeycol").append(" = ? AND ").append(fperiodCol);
        sql1.append(hasQtyCols ? " > ? AND " : " >= ? AND ");
        sql1.append(fendPeriodCol).append(">? ) ");
        paramCols1.add("keycol");
        paramCols1.add(this.periodCol);
        paramCols1.add(this.periodCol);
        sql2.append(" WHERE ").append("fid");
        sql2.append(" IN (SELECT ").append("fid").append(" FROM ").append(this.tb);
        sql2.append(" WHERE ").append("fkeycol").append(" = ? AND ").append(fperiodCol);
        sql2.append(hasQtyCols ? " = ? AND " : " >= ? AND ");
        sql2.append(fendPeriodCol).append(">? ) ");
        paramCols2.add("keycol");
        paramCols2.add(this.periodCol);
        paramCols2.add(this.periodCol);
        paramCols1 = Collections.unmodifiableList(paramCols1);
        paramCols2 = Collections.unmodifiableList(paramCols2);
        sqls.put(sql1.toString(), paramCols1);
        if (hasQtyCols) {
            sqls.put(sql2.toString(), paramCols2);
        }
    }

    private void addPeriodMainTbSql(Map<String, List<String>> sqls, List<String> allCols, Set<String> qtyCols, boolean addModifyTimeCol) {
        StringBuilder sql = new StringBuilder(" UPDATE ");
        List<String> cols = new ArrayList<String>(allCols.size() * 9 + 2);
        sql.append(this.tb).append(" SET ");
        Map<String, String> colFieldMap = this.getColFieldMap();
        String fperiodCol = colFieldMap.get(this.periodCol);
        String fendPeriodCol = colFieldMap.get(this.endPeriodCol);
        int i = 0;
        for (String setCol : allCols) {
            if (i++ > 0) {
                sql.append(",");
            }
            if (qtyCols.contains(setCol)) {
                String inQtyCol = setCol + "_in";
                String outQtyCol = setCol + "_out";
                String balQtyCol = setCol + "_bal";
                String fqtyCol = colFieldMap.get(setCol);
                String finQtyCol = colFieldMap.get(inQtyCol);
                String foutQtyCol = colFieldMap.get(outQtyCol);
                String fbalQtyCol = colFieldMap.get(balQtyCol);
                sql.append(fqtyCol).append(" = ").append(fqtyCol).append(" + ? + ").append("(? - ?) * CASE WHEN ").append(fperiodCol).append("= ? THEN 0 ELSE 1 END,");
                sql.append(finQtyCol).append(" = ").append(finQtyCol).append(" + ? * CASE WHEN ").append(fperiodCol).append("= ? THEN 1 ELSE 0 END,");
                sql.append(foutQtyCol).append(" = ").append(foutQtyCol).append(" + ? * CASE WHEN ").append(fperiodCol).append("= ? THEN 1 ELSE 0 END,");
                sql.append(fbalQtyCol).append(" = ").append(fbalQtyCol).append(" + ? ");
                cols.add(setCol);
                cols.add(inQtyCol);
                cols.add(outQtyCol);
                cols.add(this.periodCol);
                cols.add(inQtyCol);
                cols.add(this.periodCol);
                cols.add(outQtyCol);
                cols.add(this.periodCol);
                cols.add(balQtyCol);
                continue;
            }
            this.appendSetCoverCol(sql, colFieldMap.get(setCol));
            cols.add(BalanceTB.parseCoverFlag(setCol));
            cols.add(setCol);
        }
        if (addModifyTimeCol && this.modifyTimeCol != null) {
            sql.append(',').append(colFieldMap.get(this.modifyTimeCol)).append(" = ? ");
            cols.add(this.modifyTimeCol);
        }
        sql.append(" WHERE ").append("fkeycol").append("=? AND ").append(fperiodCol).append(">=? AND ").append(fendPeriodCol).append("> ? ");
        cols.add("keycol");
        cols.add(this.periodCol);
        cols.add(this.periodCol);
        cols = Collections.unmodifiableList(cols);
        sqls.put(sql.toString(), cols);
    }

    private void appendSetCoverCol(StringBuilder sql, String col) {
        sql.append(col).append(" = CASE ? WHEN '1' THEN ? ELSE ").append(col).append(" END ");
    }

    public Map<BizDataType, Set<String>> getColType() {
        return this.colType;
    }

    public static String parseCoverFlag(String col) {
        return col + "_flag";
    }

    public String toOldSpCol(String col) {
        return this.oldColCache.computeIfAbsent(col, c -> "old_" + c);
    }

    public boolean isPerBal() {
        return this.isPerBal;
    }

    public boolean isRealBal() {
        return !this.isPerBal;
    }

    public String getInsertSql() {
        List<String> insertFields = this.getInsertFields();
        StringBuilder sql = new StringBuilder(" INSERT INTO ");
        sql.append(this.getTmpSnapshotTb());
        sql.append(" (").append(StringUtils.join(insertFields, (char)',')).append(',').append("fcreatetime").append(") VALUES (");
        for (int i = 0; i < insertFields.size(); ++i) {
            if (i != 0) {
                sql.append(',');
            }
            sql.append('?');
        }
        sql.append(",NOW())");
        return sql.toString();
    }

    public List<String> getInsertFields() {
        return this.insertFields;
    }

    public List<String> getInsertCols() {
        return this.insertCols;
    }

    private void setInsertCols() {
        ArrayList<String> cols = new ArrayList<String>(40);
        cols.add("id");
        cols.add("billno");
        cols.add("entryseq");
        cols.add("keycol");
        cols.add("billname");
        cols.add("updatetime");
        cols.add("updatetype");
        cols.add("updaterule");
        cols.add("status");
        cols.add("billid");
        cols.add("entryid");
        cols.add("isnew");
        cols.add("readtype");
        cols.add("movetype");
        cols.add("coverflag");
        cols.add("sync");
        ArrayList<String> Fields = new ArrayList<String>(40);
        Fields.add("fid");
        Fields.add("fbillno");
        Fields.add("fentryseq");
        Fields.add("fkeycol");
        Fields.add("fbillname");
        Fields.add("fupdatetime");
        Fields.add("fupdatetype");
        Fields.add("fupdateruleid");
        Fields.add("fstatus");
        Fields.add("fbillid");
        Fields.add("fentryid");
        Fields.add("fisnew");
        Fields.add("freadtype");
        Fields.add("fmovetype");
        Fields.add("fcoverflag");
        Fields.add("fsync");
        Map<String, String> colFieldMap = this.getColFieldMap();
        Set<String> qtyCols = this.getColsByDataType(BizDataType.OCC, BizDataType.IN, BizDataType.INIT, BizDataType.OUT);
        for (String qtyCol : qtyCols) {
            cols.add(qtyCol);
            Fields.add(BalanceTB.parse2SnapName(colFieldMap.get(qtyCol)));
        }
        for (String cover : this.getCoverCols()) {
            cols.add(cover);
            Fields.add(colFieldMap.get(cover));
        }
        if (this.isPerBal) {
            cols.add(this.periodCol);
            Fields.add(colFieldMap.get(this.periodCol));
        }
        this.insertCols = Collections.unmodifiableList(cols);
        this.insertFields = Collections.unmodifiableList(Fields);
    }

    public ConcurrentHashMap<String, String> getOccAppCache() {
        return this.occAppCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getColList4RecordSplit() {
        if (this.colList4RecordSplit != null || !this.isRealBal()) {
            return this.colList4RecordSplit;
        }
        BalanceTB balanceTB = this;
        synchronized (balanceTB) {
            Set<String> selectCols = this.getColsByDataType(BizDataType.MAIN, BizDataType.DIM, BizDataType.COVER, BizDataType.RDD, BizDataType.AUX);
            selectCols.remove("keycol");
            ArrayList<String> sortCols = new ArrayList<String>(selectCols);
            Collections.sort(sortCols);
            this.colList4RecordSplit = Collections.unmodifiableList(sortCols);
        }
        return this.colList4RecordSplit;
    }

    private static class TBChecker {
        final Set<String> cache = new HashSet<String>(2);
        final Object lock = new Object();

        private TBChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkOrCreateTB(DBRoute occDb, String tb, CreateTBFunc func) {
            String dbKey = occDb.getRouteKey();
            if (this.cache.contains(dbKey)) {
                return;
            }
            BalLogUtil.info("checkOrCreateTB start : dbKey = " + occDb + ", tb = " + tb, new Object[0]);
            tb = tb.toUpperCase(Locale.ENGLISH);
            Object object = this.lock;
            synchronized (object) {
                if (!this.cache.contains(dbKey)) {
                    if (DB.exitsTable((DBRoute)occDb, (String)tb)) {
                        BalLogUtil.info("checkOrCreateTB already exist : dbKey = " + occDb + ", tb = " + tb, new Object[0]);
                    } else {
                        BalTbUtil.executeDDL(occDb, func.getSql(tb));
                        BalLogUtil.info("checkOrCreateTB success : dbKey = " + occDb + ", tb = " + tb, new Object[0]);
                    }
                    this.cache.add(dbKey);
                }
            }
        }
    }

    @FunctionalInterface
    private static interface CreateTBFunc {
        public String[] getSql(String var1);
    }
}

