/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.biz.balance.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bal.business.core.BalInnerUtil;
import kd.bos.bal.common.QFUtil;
import kd.bos.bal.common.TxInfo;
import kd.bos.bal.util.BalQuery;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.UpdateCtx;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.StringUtils;

@SdkPublic
public class BalanceUpdateArgs {
    private UpdateRule rule;
    private UpdateCtx ctx;
    private boolean generatedSpData = true;
    private boolean generatedDecreaseQty = true;
    private long updateTime;

    public boolean isGeneratedDecreaseQty() {
        return this.generatedDecreaseQty;
    }

    public void setGeneratedDecreaseQty(boolean generatedDecreaseQty) {
        this.generatedDecreaseQty = generatedDecreaseQty;
    }

    public boolean isGeneratedSpData() {
        return this.generatedSpData;
    }

    public void setGeneratedSpData(boolean generatedSpData) {
        this.generatedSpData = generatedSpData;
    }

    public UpdateRule getRule() {
        return this.rule;
    }

    public void setRule(UpdateRule rule) {
        this.rule = rule;
    }

    public UpdateCtx getCtx() {
        return this.ctx;
    }

    public void setCtx(UpdateCtx ctx) {
        this.ctx = ctx;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    @Deprecated
    public DataSet getUpdatedBalData(String balTbCols) {
        return this.getUpdatedBalData(balTbCols, null, null);
    }

    public DataSet queryUpdatedBal(String balTbCols, String balTbQF, String balSpQf) {
        BalanceTB balanceTB = this.rule.getBalanceTB();
        SqlBuilder sql = new SqlBuilder();
        sql.append(" SELECT ", new Object[0]).append(balTbCols, new Object[0]).append(" FROM ", new Object[0]);
        sql.append(balanceTB.getTb(), new Object[0]).append(" WHERE ", new Object[0]);
        Object[] keys = this.getKeys(balanceTB, balSpQf);
        if (keys.length == 0) {
            sql.append(" 1!=1 ", new Object[0]);
        } else {
            sql.appendIn("fkeycol", keys);
        }
        if (StringUtils.isNotBlank((CharSequence)balTbQF)) {
            sql.append(" AND (", new Object[0]).append(balTbQF, new Object[0]).append(") ", new Object[0]);
        }
        DataSet data = DB.queryDataSet((String)BalanceUpdateArgs.class.getName(), (DBRoute)balanceTB.getDbRoute(), (SqlBuilder)sql);
        return data;
    }

    private Set<Object> getKeycolInFs(BalanceTB balanceTB, String balSpQf) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ").append("fkeycol");
        sql.append(" FROM ").append(balanceTB.getTmpSnapshotTb());
        sql.append(" WHERE ").append("fupdatetime").append(" = ").append(this.getUpdateTime());
        if (StringUtils.isNotBlank((CharSequence)balSpQf)) {
            sql.append(" AND (").append(balSpQf).append(") ");
        }
        try (DataSet datas = DB.queryDataSet((String)"getKeycolIn", (DBRoute)balanceTB.getDbRoute(), (String)sql.toString());){
            HashSet<String> keys = new HashSet<String>(256);
            for (Row row : datas) {
                keys.add(row.getString("fkeycol"));
            }
            HashSet<String> hashSet = keys;
            return hashSet;
        }
    }

    private DataSet unionSpData(BalanceTB balanceTB, Object[] keycolInFs, List<String> qtyCols, DataSet balData, Set<Long> shardTxs) {
        HashMap<String, String> spCols = new HashMap<String, String>(8);
        spCols.put("keycol", "fkeycol");
        SqlBuilder sql = new SqlBuilder();
        sql.append(" SELECT ", new Object[0]).append("fkeycol", new Object[0]);
        Map<String, String> colFieldMap = balanceTB.getColFieldMap();
        ArrayList<String> balQtyCols = new ArrayList<String>(qtyCols.size());
        for (String qtyCol : qtyCols) {
            String spQtyCol = BalanceTB.parse2SnapName(colFieldMap.get(qtyCol));
            sql.append(",", new Object[0]).append(spQtyCol, new Object[0]).append(" AS ", new Object[0]).append(qtyCol, new Object[0]);
            spCols.put(qtyCol, spQtyCol);
            balQtyCols.add(colFieldMap.get(qtyCol));
        }
        sql.append(" FROM ", new Object[0]).append(balanceTB.getTmpSnapshotTb(), new Object[0]).append(" WHERE ", new Object[0]);
        if (keycolInFs == null || keycolInFs.length == 0) {
            sql.append(" 1!=1 ", new Object[0]);
        } else {
            sql.appendIn("fkeycol", keycolInFs);
        }
        if (shardTxs == null || shardTxs.isEmpty()) {
            sql.append(" AND ", new Object[0]).append("freadtype", new Object[0]).append("='1' ", new Object[0]);
        } else {
            sql.append(" AND (", new Object[0]).append("freadtype", new Object[0]).append("='1' OR ", new Object[0]);
            sql.append("fupdatetime", new Object[0]).append(QFUtil.getIdsFilter(shardTxs), new Object[0]).append(") ", new Object[0]);
        }
        DataSet spData = DB.queryDataSet((String)"unionSpData", (DBRoute)balanceTB.getDbRoute(), (SqlBuilder)sql);
        balData = this.mergeSpQtys(balData, spData, spCols, balQtyCols);
        return balData;
    }

    private DataSet mergeSpQtys(DataSet balData, DataSet spData, Map<String, String> spCols, List<String> balQtyCols) {
        RowMeta rowMeta = balData.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        String[] spDataCols = new String[fieldNames.length];
        String spCol = null;
        for (int i = 0; i < spDataCols.length; ++i) {
            spCol = spCols.get(fieldNames[i]);
            spDataCols[i] = (spCol == null ? "null" : spCol) + " " + fieldNames[i];
        }
        spData = spData.select(spDataCols);
        balData = BalQuery.mergeSpQtys(balData, spData, "fkeycol", balQtyCols);
        return balData;
    }

    private Map<String, String> parseCols(BalanceTB balanceTB, String balTbCols) {
        Map<String, String> colFieldMap = balanceTB.getColFieldMap();
        HashMap<String, String> colMap = new HashMap<String, String>(colFieldMap.size());
        for (Map.Entry<String, String> entry : colFieldMap.entrySet()) {
            colMap.put(entry.getValue(), entry.getKey());
        }
        return colMap;
    }

    private List<String> parseQtyCol(BalanceTB balanceTB, String balTbCols) {
        String[] cols;
        Map<String, String> parseCols = this.parseCols(balanceTB, balTbCols);
        ArrayList<String> qtyCols = new ArrayList<String>(5);
        Set<String> occCols = balanceTB.getOccCols();
        for (String col : cols = balTbCols.split(",")) {
            if (!occCols.contains(parseCols.get(col = col.trim().toLowerCase(Locale.ENGLISH)))) continue;
            qtyCols.add(parseCols.get(col));
        }
        return qtyCols;
    }

    @Deprecated
    public DataSet getUpdatedBalData(String balTbCols, String balTbQF, String balSpQf) {
        BalanceTB balanceTB = this.rule.getBalanceTB();
        Object[] keyColFs = this.getKeycolInFs(balanceTB, balSpQf).toArray();
        SqlBuilder sql = new SqlBuilder();
        sql.append(" SELECT ", new Object[0]).append(balTbCols, new Object[0]).append(" FROM ", new Object[0]);
        sql.append(balanceTB.getTb(), new Object[0]).append(" WHERE ", new Object[0]);
        if (keyColFs.length == 0) {
            sql.append(" 1!=1 ", new Object[0]);
        } else {
            sql.appendIn("fkeycol", keyColFs);
        }
        if (StringUtils.isNotBlank((CharSequence)balTbQF)) {
            sql.append(" AND (", new Object[0]).append(balTbQF, new Object[0]).append(") ", new Object[0]);
        }
        DataSet balData = DB.queryDataSet((String)BalanceUpdateArgs.class.getName(), (DBRoute)balanceTB.getDbRoute(), (SqlBuilder)sql);
        if (balanceTB.isPerBal()) {
            return balData;
        }
        List<String> qtyCols = this.parseQtyCol(balanceTB, balTbCols);
        if (qtyCols.isEmpty()) {
            return balData;
        }
        return this.unionSpData(balanceTB, keyColFs, qtyCols, balData, this.getShardTxs());
    }

    private Object[] getKeys(BalanceTB balanceTB, String balSpQf) {
        SqlBuilder sql = new SqlBuilder();
        sql.append(" SELECT ", new Object[0]).append("fkeycol", new Object[0]).append(" FROM ", new Object[0]).append(balanceTB.getSnapshotTb(), new Object[0]);
        sql.append(this.createSnapQf(balSpQf), new Object[0]);
        HashSet<Object> keys = new HashSet<Object>(256);
        try (DataSet data = DB.queryDataSet((String)"BalanceUpdateArgs.getKeys", (DBRoute)balanceTB.getDbRoute(), (SqlBuilder)sql);){
            for (Row row : data) {
                keys.add(row.get("fkeycol"));
            }
        }
        return keys.toArray();
    }

    private String createSnapQf(String balSpQf) {
        StringBuilder where = new StringBuilder();
        where.append(" WHERE ").append("fupdatetime").append(" = ").append(this.getUpdateTime());
        if (StringUtils.isNotBlank((CharSequence)balSpQf)) {
            where.append(" AND (").append(balSpQf).append(") ");
        }
        return where.toString();
    }

    public DataSet getUpdatedSnapData(String snapCols, String balSpQf) {
        BalanceTB tb = this.rule.getBalanceTB();
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ").append(snapCols).append(" FROM ").append(tb.getTmpSnapshotTb());
        sql.append(this.createSnapQf(balSpQf));
        DataSet record = DB.queryDataSet((String)BalanceUpdateArgs.class.getName(), (DBRoute)tb.getDbRoute(), (String)sql.toString());
        return record;
    }

    public DataSet getUpdatedSnapData(String[] snapFixedCols, String[] balQtyCols, String[] keyCols) {
        BalanceTB tb = this.rule.getBalanceTB();
        StringBuilder sql = new StringBuilder();
        Set<String> selectCols = this.buildSelectCols(snapFixedCols, balQtyCols, tb);
        sql.append(" SELECT ").append(StringUtils.join(selectCols, (String)","));
        sql.append(" FROM ").append(tb.getTmpSnapshotTb());
        String keyColFs = "fkeycol IN ('" + StringUtils.join((Object[])keyCols, (String)"','") + "') ";
        sql.append(this.createSnapQf(keyColFs));
        DataSet record = DB.queryDataSet((String)BalanceUpdateArgs.class.getName(), (DBRoute)tb.getDbRoute(), (String)sql.toString());
        return record;
    }

    public DataSet getBalUpdatedDataWithBalCol(List<String> balQtyCols, List<String> extraBalCols) {
        return BalQuery.getBalUpdatedInfo(this.getUpdateTime(), this.rule.getBalanceTB(), balQtyCols, extraBalCols);
    }

    public DataSet getBalUpdatedInfo4ReserveTrans(List<String> extraBalCols) {
        return BalQuery.getBalUpdatedInfo4ReserveTrans(this.getUpdateTime(), this.rule.getBalanceTB(), extraBalCols);
    }

    private Set<String> buildSelectCols(String[] snapFixedCols, String[] balQtyCols, BalanceTB tb) {
        HashSet<String> cols = new HashSet<String>(32);
        cols.add("fkeycol");
        if (snapFixedCols != null) {
            for (String snapFixedCol : snapFixedCols) {
                cols.add(snapFixedCol);
            }
        }
        if (balQtyCols != null) {
            Map<String, String> colFieldMap = tb.getColFieldMap();
            for (String balQtyCol : balQtyCols) {
                cols.add(BalanceTB.parse2SnapName(colFieldMap.get(balQtyCol)) + " " + balQtyCol);
            }
        }
        return cols;
    }

    public DataSet getBalData4NegativeCheck(String ... selectCols) {
        long txId = this.generatedDecreaseQty ? this.getUpdateTime() : this.getUpdateTime() * -1L;
        return BalQuery.getBalData4NegativeCheck(txId, this.rule.getBalanceTB(), this.getShardTxs(), selectCols);
    }

    private Set<Long> getShardTxs() {
        Map<Long, TxInfo> txInfo = this.ctx.getTxInfo();
        HashSet<Long> txs = new HashSet<Long>(txInfo.size());
        String balName = this.rule.getBalanceNo();
        for (TxInfo info : txInfo.values()) {
            if (info.isSync() || 2 != info.getStatus() || !balName.equals(info.getRule().getBalanceNo())) continue;
            txs.add(info.getTxid());
        }
        BalInnerUtil.collectTxFromThreadLocal(balName, txs);
        return txs;
    }

    public QFilter getUpdatingBalFs() {
        StringBuilder sql = new StringBuilder();
        sql.append(" ( SELECT ").append("fkeycol").append(" FROM ");
        sql.append(this.rule.getBalanceTB().getTmpSnapshotTb()).append(" WHERE ");
        sql.append("fupdatetime").append('=').append(this.getUpdateTime()).append(") ");
        return QFilter.sqlExpress((String)"keycol", (String)"in", (String)sql.toString());
    }
}

