/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.biz.balance.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.BalUtil;
import kd.bos.biz.balance.engine.UpdateCol;
import kd.bos.biz.balance.engine.policy.CalPeriodByDate;
import kd.bos.biz.balance.engine.policy.CalPeriodByPeriod;
import kd.bos.biz.balance.engine.policy.CalPeriodByYearMonth;
import kd.bos.biz.balance.engine.policy.CalPeriodToZero;
import kd.bos.biz.balance.engine.policy.ICalPeriodPolicy;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.balance.BizDataType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.metadata.balance.BalanceUpdateRuleElement;
import kd.bos.metadata.balance.policy.BalanceCondition;
import kd.bos.metadata.balance.policy.BalanceFieldMapItem;
import kd.bos.metadata.balance.policy.BalanceFieldMapPolicy;
import kd.bos.metadata.balance.policy.BalanceFormula;
import kd.bos.metadata.balance.policy.BalanceLogicConf;
import kd.bos.metadata.balance.policy.BalanceSortCol;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.StringUtils;

@SdkPublic
public class UpdateRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String entityNumber;
    private String balanceNo;
    private String ruleNo;
    private BalanceTB balanceTB;
    private String entryName;
    private QFilter filter;
    private Set<String> update;
    private Set<String> rollback;
    private Set<String> occCol4Update;
    private Set<String> coverCol4Update;
    private Set<String> rddCol4Update;
    private Map<String, String> targetSrcColMap;
    @Deprecated
    private Map<String, String> qtyCalConf;
    @Deprecated
    private Set<String> extCols;
    private Map<String, String> srcColFullNameMap;
    private Map<String, Expr> colExpr;
    private List<String> updateKeyCol;
    private int updateType = 0;
    private List<String> defValCOls;
    private Map<String, String> logicColMap;
    private List<String> insertCols;
    private List<String> insertFields;
    private ICalPeriodPolicy perCalPolicy;
    private String periodPolicy;
    private String readableType;
    private Map<String, String> periodColMap;
    private List<BalanceSortCol> sortCols;
    private String srcNumberCol;
    private boolean sysEnable;
    private boolean custEnable;
    private String perQtyType;
    @Deprecated
    private Map<String, List<String>> updateCoverSqls;

    @Deprecated
    public Map<String, String> getQtyCalConf() {
        return this.qtyCalConf;
    }

    public ICalPeriodPolicy getPerCalPolicy() {
        return this.perCalPolicy;
    }

    public String getPeriodPolicy() {
        return this.periodPolicy;
    }

    public String getReadableType() {
        return this.readableType;
    }

    public Map<String, String> getPeriodColMap() {
        return this.periodColMap;
    }

    public Map<String, String> getLogicColMap() {
        return this.logicColMap;
    }

    public List<BalanceSortCol> getSortCols() {
        return this.sortCols;
    }

    public Set<String> getRddCol4Update() {
        return this.rddCol4Update;
    }

    public Set<String> getExtCols() {
        return this.extCols;
    }

    public boolean isEnable() {
        return this.sysEnable && this.custEnable;
    }

    public boolean isSysEnable() {
        return this.sysEnable;
    }

    public boolean isMatchAll() {
        return true;
    }

    public boolean isCustEnable() {
        return this.custEnable;
    }

    private UpdateRule() {
    }

    public String getId() {
        return this.id;
    }

    public static UpdateRule getUpdateRule(BalanceUpdateRuleElement rule) {
        UpdateRule updateRule = new UpdateRule();
        updateRule.initRule(rule);
        return updateRule;
    }

    private void setInsertCols() {
        ArrayList<String> cols = new ArrayList<String>(40);
        cols.add("id");
        cols.add("billno");
        cols.add("entryseq");
        cols.add("keycol");
        cols.add("billname");
        cols.add("updatetime");
        cols.add("updatetype");
        cols.add("updaterule");
        cols.add("status");
        cols.add("billid");
        cols.add("entryid");
        cols.add("isnew");
        ArrayList<String> Fields = new ArrayList<String>(40);
        Fields.add("fid");
        Fields.add("fbillno");
        Fields.add("fentryseq");
        Fields.add("fkeycol");
        Fields.add("fbillname");
        Fields.add("fupdatetime");
        Fields.add("fupdatetype");
        Fields.add("fupdateruleid");
        Fields.add("fstatus");
        Fields.add("fbillid");
        Fields.add("fentryid");
        Fields.add("fisnew");
        Map<String, String> colFieldMap = this.balanceTB.getColFieldMap();
        for (String occ : this.occCol4Update) {
            cols.add(BalanceTB.parse2SnapName(occ));
            Fields.add(BalanceTB.parse2SnapName(colFieldMap.get(occ)));
        }
        for (String cover : this.coverCol4Update) {
            cols.add(cover);
            Fields.add(colFieldMap.get(cover));
        }
        String type = this.balanceTB.getType();
        if ("period".equals(type)) {
            String periodCol = this.balanceTB.getPeriodCol();
            cols.add(periodCol);
            Fields.add(colFieldMap.get(periodCol));
        }
        this.insertCols = Collections.unmodifiableList(cols);
        this.insertFields = Collections.unmodifiableList(Fields);
    }

    public List<String> getInsertCols() {
        return this.insertCols;
    }

    public List<String> getInsertFields() {
        return this.insertFields;
    }

    public Set<String> getOccCol4Update() {
        return this.occCol4Update;
    }

    public Set<String> getRollback() {
        return this.rollback;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public String getEntryPkName() {
        if (this.entryName == null) {
            return "id";
        }
        return this.entryName + ".id";
    }

    public List<String> getUpdateKeyCol() {
        return this.updateKeyCol;
    }

    private void initRule(BalanceUpdateRuleElement ruleElement) {
        BalLogUtil.info("UpdateRule.initRule start ruleNo=" + ruleElement.getNumber(), new Object[0]);
        this.entityNumber = ruleElement.getSourceEntityNumber();
        this.ruleNo = ruleElement.getNumber();
        this.id = ruleElement.getId();
        HashSet<String> ops = new HashSet<String>(4);
        ops.add("#re_cal#");
        String flag = ruleElement.getUpdate();
        if (StringUtils.isNotBlank((CharSequence)flag)) {
            String[] updateKeys = flag.split(",");
            this.addOp(updateKeys, ops);
        }
        this.update = Collections.unmodifiableSet(ops);
        ops = new HashSet(4);
        ops.add("#re_rollback#");
        flag = ruleElement.getRollback();
        if (StringUtils.isNotBlank((CharSequence)flag)) {
            String[] rollbackKeys = flag.split(",");
            this.addOp(rollbackKeys, ops);
        }
        this.rollback = Collections.unmodifiableSet(ops);
        this.sysEnable = "0".equals(ruleElement.getSysStatus());
        this.custEnable = "1".equals(ruleElement.getCustStatus());
        this.updateType = "0".equals(ruleElement.getUpdateType()) ? 1 : -1;
        this.balanceNo = ruleElement.getBalanceTableNumber();
        this.perQtyType = ruleElement.getPeriodQtyType();
        this.readableType = ruleElement.getReadableType();
        this.balanceTB = BalanceTB.getBalanceTB(this.balanceNo);
        this.handleCompatible(ruleElement);
        this.parseFilter(ruleElement);
        this.parseTargetSrcColMap(ruleElement);
        this.parsePeriodCols(ruleElement);
        this.parseLogicCol(ruleElement);
        this.parseSrcColFullNameMap();
        this.parseUpdateCols();
        this.parseUpdateKeyCol();
        this.sortCols = ruleElement.getSortEntryRows();
        this.setInsertCols();
        BalLogUtil.info("UpdateRule.initRule end", new Object[0]);
    }

    private void parseLogicCol(BalanceUpdateRuleElement ruleElement) {
        List logicConfs = ruleElement.getLogicConfs();
        HashMap<String, String> logicConfMap = new HashMap<String, String>(logicConfs.size());
        String logicSrc = null;
        String logicCol = null;
        for (BalanceLogicConf logicConf : logicConfs) {
            logicCol = logicConf.getLogicCol();
            logicSrc = logicConf.getLogicSrc();
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{logicCol, logicSrc})) continue;
            logicConfMap.put(logicCol, logicSrc);
        }
        this.logicColMap = Collections.unmodifiableMap(logicConfMap);
    }

    private void parsePeriodCols(BalanceUpdateRuleElement ruleElement) {
        HashMap<String, String> localPeriodColMap = new HashMap<String, String>(4);
        if ("period".equals(this.balanceTB.getType())) {
            switch (this.periodPolicy = ruleElement.getPeriodFilterType()) {
                case "1": {
                    localPeriodColMap.put("per_date", ruleElement.getBizDateField());
                    this.perCalPolicy = new CalPeriodByDate();
                    break;
                }
                case "2": {
                    localPeriodColMap.put("per_year", ruleElement.getPeriodField() + "." + ruleElement.getYearField());
                    localPeriodColMap.put("per_month", ruleElement.getPeriodField() + "." + ruleElement.getMonthField());
                    this.perCalPolicy = new CalPeriodByPeriod();
                    break;
                }
                case "0": {
                    localPeriodColMap.put("per_year", ruleElement.getYearField());
                    localPeriodColMap.put("per_month", ruleElement.getMonthField());
                    this.perCalPolicy = new CalPeriodByYearMonth();
                    break;
                }
                case "3": {
                    this.perCalPolicy = new CalPeriodToZero();
                    break;
                }
            }
        }
        this.periodColMap = Collections.unmodifiableMap(localPeriodColMap);
    }

    private void parseUpdateKeyCol() {
        List<String> allKeyColsOfbalance = this.balanceTB.getKeyCols();
        ArrayList<String> loaclCols = new ArrayList<String>(allKeyColsOfbalance.size());
        for (String keyColsOfbalance : allKeyColsOfbalance) {
            if (!this.targetSrcColMap.containsKey(keyColsOfbalance) && !this.colExpr.containsKey(keyColsOfbalance)) continue;
            loaclCols.add(keyColsOfbalance);
        }
        this.updateKeyCol = Collections.unmodifiableList(loaclCols);
    }

    private void addOp(String[] keys, Set<String> ops) {
        for (String key : keys) {
            if (!StringUtils.isNotBlank((CharSequence)key)) continue;
            ops.add(key);
        }
    }

    private void parseUpdateCols() {
        Set<String> occCols = this.balanceTB.getColsByDataType(BizDataType.OCC, BizDataType.INIT, BizDataType.IN, BizDataType.OUT);
        Set<String> coverCols = this.balanceTB.getColsByDataType(BizDataType.COVER);
        Set<String> rddCols = this.balanceTB.getColsByDataType(BizDataType.RDD);
        HashSet<String> occCol4UpdateSet = new HashSet<String>(occCols.size());
        HashSet<String> coverCol4UpdateSet = new HashSet<String>(coverCols.size());
        HashSet<String> rddCol4UpdateSet = new HashSet<String>(rddCols.size());
        for (String targetCol : this.targetSrcColMap.keySet()) {
            if (occCols.contains(targetCol)) {
                occCol4UpdateSet.add(targetCol);
                continue;
            }
            if (coverCols.contains(targetCol)) {
                coverCol4UpdateSet.add(targetCol);
                continue;
            }
            if (!rddCols.contains(targetCol)) continue;
            rddCol4UpdateSet.add(targetCol);
        }
        if (occCol4UpdateSet.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f59\u989d\u66f4\u65b0\u89c4\u5219{0}\u81f3\u5c11\u9700\u8981\u914d\u7f6e\u4e00\u4e2a\u53d1\u751f\u6570\u636e\u5b57\u6bb5\u3002", (String)"UpdateRule_0", (String)"bos-biz-balance", (Object[])new Object[]{this.getRuleNo()}));
        }
        this.occCol4Update = Collections.unmodifiableSet(occCol4UpdateSet);
        this.coverCol4Update = Collections.unmodifiableSet(coverCol4UpdateSet);
        this.rddCol4Update = Collections.unmodifiableSet(rddCol4UpdateSet);
    }

    private void parseSrcColFullNameMap() {
        HashMap<String, String> loaclSrcCols = new HashMap<String, String>(36);
        MainEntityType srcEntity = MetadataServiceHelper.getDataEntityType((String)this.entityNumber);
        if (srcEntity instanceof BillEntityType) {
            this.srcNumberCol = ((BillEntityType)srcEntity).getBillNo();
        }
        HashSet<String> allBillCols = new HashSet<String>(64);
        allBillCols.addAll(this.targetSrcColMap.values());
        allBillCols.addAll(this.periodColMap.values());
        allBillCols.addAll(this.logicColMap.values());
        for (String col : allBillCols) {
            loaclSrcCols.put(col, this.getColFullName(srcEntity, col));
        }
        this.srcColFullNameMap = Collections.unmodifiableMap(loaclSrcCols);
    }

    private void handleCompatible(BalanceUpdateRuleElement ruleElement) {
        HashSet<String> occEntyCols = new HashSet<String>(this.balanceTB.getOccCols());
        occEntyCols.addAll(this.balanceTB.getCoverCols());
        BalUtil.handleCompatible(ruleElement, this.balanceTB.getKeyCols(), occEntyCols);
    }

    private void parseTargetSrcColMap(BalanceUpdateRuleElement ruleElement) {
        BalanceFieldMapPolicy colsMap = ruleElement.getFieldMapPolicy();
        List items = colsMap.getBalanceFieldMapItems();
        HashMap<String, String> localColsMap = new HashMap<String, String>(items.size());
        HashMap<String, Expr> localColExpr = new HashMap<String, Expr>(2);
        ArrayList<String> localDefValCols = new ArrayList<String>();
        HashMap localQtyFormula = new HashMap(items.size());
        HashSet loaclExtCols = new HashSet();
        for (BalanceFieldMapItem item : items) {
            String balCol = item.getTargetField();
            String billCol = item.getSourceField();
            String valType = item.getValType();
            if ("0".equals(valType)) {
                localColsMap.put(balCol, billCol);
                continue;
            }
            if ("4".equals(valType)) {
                localDefValCols.add(balCol);
                continue;
            }
            if (!"6".equals(valType)) continue;
            localColExpr.put(balCol, this.parseExpr(item.getExpr()));
        }
        this.targetSrcColMap = Collections.unmodifiableMap(localColsMap);
        this.qtyCalConf = Collections.unmodifiableMap(localQtyFormula);
        this.defValCOls = Collections.unmodifiableList(localDefValCols);
        this.colExpr = Collections.unmodifiableMap(localColExpr);
        for (String balField : localColsMap.keySet()) {
            loaclExtCols.remove(balField);
        }
        this.extCols = Collections.unmodifiableSet(loaclExtCols);
    }

    public Map<String, Expr> getColExpr() {
        return this.colExpr;
    }

    private Expr parseExpr(BalanceFormula expr) {
        try {
            return expr == null ? null : FormulaEngine.parseFormula((String)expr.getExpression());
        }
        catch (Throwable e) {
            BalLogUtil.error("UpdateRule.parseExpr error", e);
            return null;
        }
    }

    public List<String> getDefValCols() {
        return this.defValCOls;
    }

    private void parseFilter(BalanceUpdateRuleElement ruleElement) {
        BalanceCondition condition = ruleElement.getDfPolicy().getBalanceCondition();
        if (condition == null) {
            return;
        }
        FilterCondition fc = condition.getFilterCondition();
        if (fc == null) {
            return;
        }
        FilterBuilder fb = new FilterBuilder(MetadataServiceHelper.getDataEntityType((String)ruleElement.getSourceEntityNumber()), fc);
        fb.buildFilter();
        this.filter = fb.getQFilter();
    }

    public QFilter getFilter() {
        return this.filter == null ? null : this.filter.copy();
    }

    public Map<String, String> getTargetSrcColMap() {
        return this.targetSrcColMap;
    }

    public boolean isForwardOp(String op) {
        return this.update.contains(op);
    }

    public int getUpdateType() {
        return this.updateType;
    }

    public Map<String, String> getSrcColFullNameMap() {
        return this.srcColFullNameMap;
    }

    public String getRuleNo() {
        return this.ruleNo;
    }

    private String getColFullName(MainEntityType srcEntity, String colName) {
        int count;
        String simpleName;
        block4: {
            IDataEntityProperty pro;
            simpleName = colName;
            int index = colName.indexOf(".");
            if (index > 0) {
                simpleName = colName.substring(0, index);
            }
            if ((pro = srcEntity.findProperty(simpleName)) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f59\u989d\u66f4\u65b0\u89c4\u5219{0}\uff0c\u5b57\u6bb5\u6620\u5c04\u89e3\u6790\u5931\u8d25:\u5143\u6570\u636e{1}\u4e0d\u5b58\u5728\u5b57\u6bb5{2}\uff0c\u8bf7\u68c0\u67e5\u5143\u6570\u636e\u6216\u66f4\u65b0\u89c4\u5219\u662f\u5426\u914d\u7f6e\u6b63\u786e\u3002", (String)"UpdateRule_1", (String)"bos-biz-balance", (Object[])new Object[]{this.ruleNo, srcEntity.getName(), colName}));
            }
            IDataEntityType parent = null;
            count = 0;
            do {
                IDataEntityType iDataEntityType = parent = parent == null ? pro.getParent() : parent.getParent();
                if (parent instanceof MainEntityType) break block4;
                colName = parent.getName() + "." + colName;
                simpleName = parent.getName() + "." + simpleName;
            } while (++count <= 4);
            throw new KDBizException(ResManager.loadKDString((String)"\u4f59\u989d\u66f4\u65b0\u89c4\u5219{0}\uff0c\u5143\u6570\u636e{1}\u5faa\u73af\u89e3\u6790\u5b57\u6bb5{2}\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5143\u6570\u636e\u6216\u66f4\u65b0\u89c4\u5219\u662f\u5426\u914d\u7f6e\u6b63\u786e\u3002", (String)"UpdateRule_2", (String)"bos-biz-balance", (Object[])new Object[]{this.ruleNo, srcEntity.getName(), colName}));
        }
        if (count > 0) {
            String currentEntryName = simpleName.substring(0, simpleName.lastIndexOf("."));
            this.checkAndUpdateEntryName(currentEntryName);
        }
        return colName;
    }

    private void checkAndUpdateEntryName(String currentEntryName) {
        if (currentEntryName == null) {
            return;
        }
        if (this.entryName == null) {
            this.entryName = currentEntryName;
            return;
        }
        if (!(this.entryName.equals(currentEntryName) || this.entryName.startsWith(currentEntryName + ".") || currentEntryName.startsWith(this.entryName + "."))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f59\u989d\u66f4\u65b0\u89c4\u5219{0}\uff0c\u5b57\u6bb5\u6620\u5c04\u6765\u6e90\u5355\u636e\u5b57\u6bb5\u4e0d\u80fd\u540c\u65f6\u6765\u81ea\u4e24\u4e2a\u4e0d\u540c\u7684\u5206\u5f55{1}\uff0c{2}\u3002", (String)"UpdateRule_3", (String)"bos-biz-balance", (Object[])new Object[]{this.ruleNo, this.entryName, currentEntryName}));
        }
        this.entryName = this.entryName.length() > currentEntryName.length() ? this.entryName : currentEntryName;
    }

    public BalanceTB getBalanceTB() {
        return this.balanceTB;
    }

    public boolean isMatchUpdate(String op) {
        return this.update.contains(op) || this.rollback.contains(op);
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public Set<String> getUpdate() {
        return this.update;
    }

    public String toString() {
        return "UpdateRule [entityNumber=" + this.entityNumber + ", ruleNo=" + this.ruleNo + "]";
    }

    public String getBalanceNo() {
        return this.balanceNo;
    }

    public String getSrcNumberCol() {
        return this.srcNumberCol;
    }

    @Deprecated
    public Map<String, UpdateCol> getGroupUpdateCols() {
        HashMap<String, UpdateCol> tbCols = new HashMap<String, UpdateCol>(2);
        Set<String> occCols = this.getOccCol4Update();
        Map<String, String> colTbMap = this.balanceTB.getColTbMap();
        String tb = null;
        UpdateCol cols = null;
        for (String occCol : occCols) {
            tb = colTbMap.get(occCol);
            cols = (UpdateCol)tbCols.get(tb);
            if (cols == null) {
                cols = new UpdateCol(tb);
                tbCols.put(tb, cols);
            }
            cols.addOccCol(occCol);
        }
        Set<String> coverCols = this.getCoverCol4Update();
        for (String coverCol : coverCols) {
            tb = colTbMap.get(coverCol);
            cols = (UpdateCol)tbCols.get(tb);
            if (cols == null) {
                cols = new UpdateCol(tb);
                tbCols.put(tb, cols);
            }
            cols.addCoverCol(coverCol);
        }
        return Collections.unmodifiableMap(tbCols);
    }

    public Set<String> getCoverCol4Update() {
        return this.coverCol4Update;
    }

    public String getPerQtyType() {
        return this.perQtyType;
    }

    @Deprecated
    public String getInsertSql() {
        List<String> insertFields = this.getInsertFields();
        StringBuilder sql = new StringBuilder(" INSERT INTO ");
        sql.append(this.balanceTB.getSnapshotTb());
        sql.append(" (").append(StringUtils.join(insertFields, (char)',')).append(") VALUES (");
        for (int i = 0; i < insertFields.size(); ++i) {
            if (i != 0) {
                sql.append(',');
            }
            sql.append('?');
        }
        sql.append(')');
        return sql.toString();
    }

    @Deprecated
    public Map<String, List<String>> getUpdateCoverSqls() {
        if (this.updateCoverSqls == null) {
            this.updateCoverSqls = this.getBalanceTB().getUpdateCoverSqls(this.getCoverCol4Update());
        }
        return this.updateCoverSqls;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateRule other = (UpdateRule)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

