/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.biz.balance.openapi.metal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.biz.balance.openapi.metal.PermUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.balance.BalanceUpdateRuleMetadata;
import kd.bos.metadata.balance.BalanceUpdateRuleReader;
import kd.bos.metadata.balance.BalanceUpdateRuleWriter;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.lang.LangWriter;
import kd.bos.service.metadata.util.GzipUtils;

public class BalMetaLWriterPlugin
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(BalMetaLWriterPlugin.class);
    private MetadataSerializer serializer;
    private List<String> tlangs;
    private String slang = "zh_CN";

    private AbstractMetadata convertTo(AbstractMetadata meta, List<Map<String, Map<String, Object>>> localeItemMap) {
        String modelType = meta.getModelType();
        this.serializer = new MetadataSerializer(modelType);
        this.restoreLang(meta, localeItemMap);
        return meta;
    }

    public ApiResult doCustomService(Map<String, Object> localeDataMap) {
        if (!PermUtil.isSuperOrAdminUser()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u975e\u7ba1\u7406\u5458\uff0c\u6682\u65e0\u6743\u9650\u3002", (String)"BAL-E-0002", (String)"bos-biz-balance", (Object[])new Object[0]), (String)"no permission");
        }
        try {
            String id = String.valueOf(localeDataMap.get("id"));
            this.tlangs = (List)localeDataMap.get("tlangs");
            if (this.tlangs == null || this.tlangs.isEmpty()) {
                this.tlangs = new ArrayList<String>();
                this.tlangs.add("en_US");
            }
            Boolean isEncrypt = Boolean.valueOf(String.valueOf(localeDataMap.get("isEncrypt")));
            Map list = null;
            list = isEncrypt != false ? (Map)SerializationUtils.fromJsonString((String)GzipUtils.uncompress((String)localeDataMap.get("localeData").toString(), (String)"utf-8"), Map.class) : (Map)localeDataMap.get("localeData");
            this.updateLocaleRuleMeta(id, list);
        }
        catch (Throwable e) {
            log.error("\u66f4\u65b0\u591a\u8bed\u8a00\u8bcd\u6761\u5931\u8d25\uff1a" + e.getMessage());
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u66f4\u65b0\u591a\u8bed\u8a00\u8bcd\u6761\u5931\u8d25\uff1a{0}\u3002", (String)"BalMetaLWriterPlugin_0", (String)"bos-biz-balance", (Object[])new Object[]{e.getMessage()}));
        }
        return ApiResult.success((Object)ResManager.loadKDString((String)"\u66f4\u65b0\u591a\u8bed\u8a00\u8bcd\u6761\u6210\u529f\u3002", (String)"BalMetaLWriterPlugin_1", (String)"bos-biz-balance", (Object[])new Object[0]));
    }

    private void restoreLang(AbstractMetadata metadata, List<Map<String, Map<String, Object>>> localeItems) {
        LangWriter writer = new LangWriter(this.serializer.getBinder(), (Object)metadata, localeItems);
        writer.setLoaceValue(this.tlangs);
        for (String tlang : this.tlangs) {
            writer.setNullLoaceValue(tlang, this.slang);
        }
    }

    private void updateLocaleRuleMeta(String id, Map<String, Map<String, Object>> itemdatas) {
        BalanceUpdateRuleReader reader = new BalanceUpdateRuleReader();
        BalanceUpdateRuleMetadata meta = reader.loadMeta(id, false);
        ArrayList<Map<String, Map<String, Object>>> items = new ArrayList<Map<String, Map<String, Object>>>();
        this.buildLocaleItem(itemdatas, items);
        this.convertTo((AbstractMetadata)meta, items);
        BalanceUpdateRuleWriter.save((BalanceUpdateRuleMetadata)meta);
    }

    private void buildLocaleItem(Map<String, Map<String, Object>> itemdatas, List<Map<String, Map<String, Object>>> items) {
        for (Map.Entry<String, Map<String, Object>> item : itemdatas.entrySet()) {
            HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
            map.put(item.getKey(), item.getValue());
            items.add(map);
        }
    }
}

