/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.http;

import com.xwbank.sdk.config.ApplicationConfig;
import com.xwbank.sdk.http.BaseHttp;
import com.xwbank.sdk.utils.JacksonUtil;
import com.xwbank.sdk.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
extends BaseHttp {
    private static final Logger logger = LoggerFactory.getLogger(HttpClient.class);

    public Map<String, Object> sendRequest(String url, Object obj, String channelType, String requestType) {
        return this.sendRequest(url, obj, channelType, requestType, 0);
    }

    public Map<String, Object> sendPost(String url, Object obj, String channelType) {
        return this.sendRequest(url, obj, channelType, "POST", 0);
    }

    public Map<String, Object> sendRequest(String url, Object obj, String channelType, String requestType, int count) {
        Map<String, Object> sendMap = JacksonUtil.toMap(obj);
        String appId = (String)sendMap.remove("appId");
        return this.sendRequest(appId, url, sendMap, channelType, requestType, count);
    }

    public Map<String, Object> sendRequest(String appId, String url, Object obj, String channelType, String requestType, int count) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (!this.isInit(appId)) {
            resultMap.put("returnCode", "100031");
            resultMap.put("returnMsg", "sdk\u672a\u521d\u59cb\u5316\u6216\u8005\u6ca1\u6709\u521d\u59cb\u5316\u6210\u529f");
            return resultMap;
        }
        Map<String, Object> respMap = null;
        if (StringUtils.isEmpty(this.configManager.getConfig(appId).getIdToken())) {
            respMap = this.sendApprovedev(appId);
            if (StringUtils.isEmpty(this.configManager.getConfig(appId).getIdToken())) {
                return respMap;
            }
        }
        if ((respMap = this.send(appId, url, obj, channelType, requestType)) != null && respMap.containsKey("returnCode")) {
            String code = (String)respMap.get("returnCode");
            if (++count <= 3 && ("010004".equals(code) || "010005".equals(code))) {
                this.sendApprovedev(appId);
                return this.sendRequest(appId, url, obj, channelType, requestType, count);
            }
            return respMap;
        }
        resultMap.put("returnCode", "100035");
        resultMap.put("returnMsg", "\u6570\u636e\u5f02\u5e38");
        resultMap.put("data", JacksonUtil.toJSONString(respMap));
        return resultMap;
    }

    public Map<String, Object> sendApprovedev(String appId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("requestRandomNum", StringUtils.getRandomKey());
        ApplicationConfig config = this.configManager.getConfig(appId);
        Map<String, Object> respMap = this.send(appId, "/api/gmApproveDev", params, "standardGMNew", "POST");
        Map<String, Object> dataMap = JacksonUtil.toMap(respMap.get("data"));
        if (dataMap != null && dataMap.containsKey("idToken")) {
            config.setIdToken(dataMap.get("idToken").toString());
            config.setIdTokenExpireTime(dataMap.get("idTokenExpireTime").toString());
            logger.info("\u9a8c\u8bc1\u5f00\u53d1\u8005\u6267\u884c\u6210\u529f\uff0ctoken\u5df2\u6210\u529f\u83b7\u53d6");
        } else {
            logger.warn("\u9a8c\u8bc1\u5f00\u53d1\u8005\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e");
        }
        return respMap;
    }
}

