/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.utils;

import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.system.FileHelper;
import cfca.sadk.tls.kse.KeystoreUtils;
import cfca.sadk.tls.sun.security.ssl.JSSEProvider;
import cfca.sadk.tls.util.Loggings;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.x509.certificate.X509Cert;
import com.xwbank.sdk.base64.BASE64Encoder;
import com.xwbank.sdk.config.ApplicationConfig;
import com.xwbank.sdk.config.HttpClientConfig;
import com.xwbank.sdk.http.entity.ProxyInfo;
import com.xwbank.sdk.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.validation.constraints.NotNull;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    private static final List<PoolingHttpClientConnectionManager> POOLING_MANAGERS = new ArrayList<PoolingHttpClientConnectionManager>();
    private static final String[] supportedCipherSuites = new String[]{"TLS_SM2PKEA_SM2DSA_WITH_SM4_CBC_SM3", "TLS_ECDHE_SM2DSA_WITH_SM4_CBC_SM3"};

    public static List<PoolingHttpClientConnectionManager> getPoolingManagers() {
        return POOLING_MANAGERS;
    }

    public static CloseableHttpClient doHttpClient(HttpClientConfig httpClientConfig, ApplicationConfig applicationConfig) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Security.addProvider(JSSEProvider.INSTANCE);
        if (applicationConfig.getPublicUrl().startsWith("http://") || StringUtils.isNull(applicationConfig.getKeyStorePath()) && applicationConfig.getKeyStoreBaoStream() == null) {
            logger.info("\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a\uff0cHttpClient\u521b\u5efahttp\u6216https\u7ed5\u8fc7\u53cc\u5411\u8ba4\u8bc1\u8bf7\u6c42");
            return HttpClientUtil.createHttpClient(httpClientConfig);
        }
        if (!StringUtils.isNull(applicationConfig.getKeyStorePath())) {
            return HttpClientUtil.createHttpsClient(httpClientConfig, applicationConfig.getTrustFilePath(), applicationConfig.getKeyStorePath(), applicationConfig.getKeyPwd());
        }
        return HttpClientUtil.createHttpsClient(httpClientConfig, applicationConfig.getTrustFileStream(), applicationConfig.getKeyStoreBaoStream(), applicationConfig.getKeyPwd());
    }

    public static PoolingHttpClientConnectionManager createPoolingHttpClientConnectionManager(Registry<ConnectionSocketFactory> socketFactoryRegistry, int maxTotal, int maxPerRoute) {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        manager.setMaxTotal(maxTotal);
        manager.setDefaultMaxPerRoute(maxPerRoute);
        POOLING_MANAGERS.add(manager);
        return manager;
    }

    public static ConnectionKeepAliveStrategy createKeepAliveStrategy(final @NotNull long keepAliveTime) {
        return new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long keepAlive = super.getKeepAliveDuration(response, context);
                if (keepAlive == -1L) {
                    keepAlive = keepAliveTime;
                }
                return keepAlive;
            }
        };
    }

    public static SSLConnectionSocketFactory createConnectionSocketFactory() {
        SSLConnectionSocketFactory sslSocketFactory = null;
        try {
            SSLContext sslContext = HttpClientUtil.createIgnoreVerifySSL();
            sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (Exception e) {
            logger.warn("\u5b9e\u4f8b\u5316\u5355\u5411\u8ba4\u8bc1\u534f\u8bae\u5931\u8d25,\u4f7f\u7528\u9ed8\u8ba4\u8fde\u63a5 ==> ", (Throwable)e);
            sslSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
        }
        return sslSocketFactory;
    }

    public static CloseableHttpClient createHttpClient(HttpClientConfig config) {
        HashMap<String, ConnectionSocketFactory> map = new HashMap<String, ConnectionSocketFactory>(2);
        map.put("http", (ConnectionSocketFactory)PlainConnectionSocketFactory.INSTANCE);
        map.put("https", (ConnectionSocketFactory)HttpClientUtil.createConnectionSocketFactory());
        Registry<ConnectionSocketFactory> socketFactoryRegistry = HttpClientUtil.createConnectionSocketFactory(map);
        PoolingHttpClientConnectionManager manager = HttpClientUtil.createPoolingHttpClientConnectionManager(socketFactoryRegistry, config.getMaxTotal(), config.getMaxPreRoute());
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        ProxyInfo.proxyManage(httpClientBuilder);
        return httpClientBuilder.setConnectionManager((HttpClientConnectionManager)manager).setKeepAliveStrategy(HttpClientUtil.createKeepAliveStrategy(config.getConnectionKeepAlive())).build();
    }

    public static CloseableHttpClient createHttpsClient(@NotNull HttpClientConfig config, @NotNull List<String> trustsFilePaths, @NotNull String keyStorePath, @NotNull String keyStorePassword) throws Exception {
        SSLContext sslContext = HttpClientUtil.buildSSLContext(trustsFilePaths, keyStorePath, keyStorePassword);
        return HttpClientUtil.createHttpsClient(config, sslContext);
    }

    public static CloseableHttpClient createHttpsClient(@NotNull HttpClientConfig config, @NotNull List<InputStream> trustsFileStreams, @NotNull ByteArrayOutputStream keyStoreStream, @NotNull String keyStorePassword) throws Exception {
        SSLContext sslContext = HttpClientUtil.buildSSLContext(trustsFileStreams, keyStoreStream, keyStorePassword);
        return HttpClientUtil.createHttpsClient(config, sslContext);
    }

    public static CloseableHttpClient createHttpsClient(@NotNull HttpClientConfig config, @NotNull SSLContext sslContext) {
        HashMap<String, ConnectionSocketFactory> connectMap = new HashMap<String, ConnectionSocketFactory>(2);
        connectMap.put("http", (ConnectionSocketFactory)PlainConnectionSocketFactory.INSTANCE);
        connectMap.put("https", GMSSLLayeredConnectionSocketFactory.getSocketFactory(sslContext));
        Registry<ConnectionSocketFactory> socketFactoryRegistry = HttpClientUtil.createConnectionSocketFactory(connectMap);
        PoolingHttpClientConnectionManager connectionManager = HttpClientUtil.createPoolingHttpClientConnectionManager(socketFactoryRegistry, config.getMaxTotal(), config.getMaxPreRoute());
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        ProxyInfo.proxyManage(httpClientBuilder);
        return httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager).setKeepAliveStrategy(HttpClientUtil.createKeepAliveStrategy(config.getConnectionKeepAlive())).build();
    }

    public static Registry<ConnectionSocketFactory> createConnectionSocketFactory(@NotNull Map<String, ConnectionSocketFactory> map) {
        RegistryBuilder builder = RegistryBuilder.create();
        for (String key : map.keySet()) {
            builder.register(key, (Object)map.get(key));
        }
        return builder.build();
    }

    public static SSLContext createIgnoreVerifySSL() throws Exception {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }
        };
        sslContext.init(null, new TrustManager[]{trustManager}, null);
        return sslContext;
    }

    public static SSLContext buildSSLContext(String trustsFilePath, String keyStorePath, String keyStorePassword) throws Exception {
        X509Cert[] certs = HttpClientUtil.buildCertByString(Collections.singletonList(trustsFilePath));
        return HttpClientUtil.buildSSLContext(certs, keyStorePath, keyStorePassword);
    }

    public static SSLContext buildSSLContext(List<String> trustsFilePath, String keyStorePath, String keyStorePassword) throws Exception {
        X509Cert[] certs = HttpClientUtil.buildCertByString(trustsFilePath);
        return HttpClientUtil.buildSSLContext(certs, keyStorePath, keyStorePassword);
    }

    public static SSLContext buildSSLContext(X509Cert[] certs, String keyStorePath, String keyStorePassword) throws Exception {
        TrustManager[] trustManagers = KeystoreUtils.INSTANCE.buildTrustManager(certs);
        KeyManager[] keyManagers = HttpClientUtil.buildKeyManagerFactory(keyStorePath, keyStorePassword);
        return HttpClientUtil.buildSSLContext(trustManagers, keyManagers);
    }

    public static KeyManager[] buildKeyManagerFactory(String keyStorePath, String keyStorePassword) throws Exception {
        KeyManagerFactory keyManagerFactory = KeystoreUtils.INSTANCE.buildKeyManagerFactory(keyStorePath, keyStorePassword, keyStorePath, keyStorePassword);
        return keyManagerFactory == null ? null : keyManagerFactory.getKeyManagers();
    }

    public static KeyManager[] buildKeyManagerFactory(ByteArrayOutputStream keyStoreStream, String keyStorePassword) throws Exception {
        X509Cert cert;
        SM2PrivateKey privateKey = KeyUtil.getPrivateKeyFromSM2((InputStream)new ByteArrayInputStream(keyStoreStream.toByteArray()), (String)keyStorePassword);
        KeyManagerFactory keyManagerFactory = KeystoreUtils.INSTANCE.buildKeyManagerFactory((PrivateKey)privateKey, cert = CertUtil.getCertFromSM2((byte[])FileHelper.getBytesFromFile((InputStream)new ByteArrayInputStream(keyStoreStream.toByteArray()))), (PrivateKey)privateKey, cert);
        return keyManagerFactory == null ? null : keyManagerFactory.getKeyManagers();
    }

    public static SSLContext buildSSLContext(List<InputStream> trustsFileStream, ByteArrayOutputStream keyStoreStream, String keyStorePassword) throws Exception {
        X509Cert[] certs = HttpClientUtil.buildCertByStreams(trustsFileStream);
        TrustManager[] trustManagers = KeystoreUtils.INSTANCE.buildTrustManager(certs);
        KeyManager[] keyManagers = HttpClientUtil.buildKeyManagerFactory(keyStoreStream, keyStorePassword);
        return HttpClientUtil.buildSSLContext(trustManagers, keyManagers);
    }

    public static SSLContext buildSSLContext(TrustManager[] trustManagers, KeyManager[] keyManagers) throws Exception {
        SSLContext context = SSLContext.getInstance("GMTLSv1.1", JSSEProvider.INSTANCE);
        context.init(keyManagers, trustManagers, new SecureRandom());
        return context;
    }

    public static X509Cert[] buildCertByStreams(List<InputStream> trustsFileStreams) throws Exception {
        X509Cert[] certs = new X509Cert[trustsFileStreams.size()];
        for (int i = 0; i < trustsFileStreams.size(); ++i) {
            certs[i] = new X509Cert(FileHelper.getBytesFromFile((InputStream)trustsFileStreams.get(i)));
        }
        return certs;
    }

    public static X509Cert[] buildCertByString(List<String> trustFilePaths) throws Exception {
        X509Cert[] certs = new X509Cert[trustFilePaths.size()];
        for (int i = 0; i < trustFilePaths.size(); ++i) {
            byte[] bytes = FileHelper.read((String)trustFilePaths.get(i));
            certs[i] = new X509Cert(bytes);
        }
        return certs;
    }

    public static RequestConfig getRequestConfig(int connectionRequestTimeout, int socketTimeout, int connectTimeout) {
        return RequestConfig.custom().setConnectionRequestTimeout(connectionRequestTimeout).setSocketTimeout(socketTimeout).setConnectTimeout(connectTimeout).build();
    }

    public static void setHeader(HttpRequestBase request, Map<String, String> headerMap) {
        if (headerMap == null || headerMap.size() == 0) {
            return;
        }
        for (String key : headerMap.keySet()) {
            request.setHeader(key, headerMap.get(key));
        }
    }

    public static void close(CloseableHttpResponse response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException e) {
                logger.error("\u3010\u54cd\u5e94\u6d41\u5173\u95ed\u5f02\u5e38\u3011 ==> ", (Throwable)e);
            }
        }
    }

    public static String entityToString(HttpResponse response) {
        if (response == null) {
            return "";
        }
        String entity = null;
        try {
            entity = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            logger.error("\u54cd\u5e94\u5bf9\u8c61\u83b7\u53d6\u5f02\u5e38: ", (Throwable)e);
        }
        return entity;
    }

    public static String entityToBase64(HttpResponse response) {
        if (response == null) {
            return "";
        }
        byte[] bytes = null;
        try {
            bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            logger.error("\u54cd\u5e94\u5bf9\u8c61\u83b7\u53d6\u5f02\u5e38: ", (Throwable)e);
        }
        return new BASE64Encoder().encode(bytes);
    }

    public static Map<String, String> getAllHeaders(HttpResponse response) {
        Header[] headers;
        HashMap<String, String> headersMap = new HashMap<String, String>();
        if (response == null) {
            return headersMap;
        }
        for (Header header : headers = response.getAllHeaders()) {
            headersMap.put(header.getName(), header.getValue());
        }
        return headersMap;
    }

    public static void poolingShutdown() {
        HttpClientUtil.getPoolingManagers().forEach(PoolingHttpClientConnectionManager::shutdown);
    }

    static final class GMSSLLayeredConnectionSocketFactory
    implements LayeredConnectionSocketFactory {
        private final SSLSocketFactory socketfactory;

        public static ConnectionSocketFactory getSocketFactory(SSLContext sslContext) {
            return new GMSSLLayeredConnectionSocketFactory(sslContext);
        }

        public GMSSLLayeredConnectionSocketFactory(SSLContext sslContext) {
            this(sslContext.getSocketFactory());
        }

        public GMSSLLayeredConnectionSocketFactory(SSLSocketFactory socketfactory) {
            this.socketfactory = socketfactory;
        }

        public Socket createSocket(HttpContext context) throws IOException {
            return SocketFactory.getDefault().createSocket();
        }

        public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
            Socket sock;
            Socket socket2 = sock = socket != null ? socket : this.createSocket(context);
            if (localAddress != null) {
                sock.bind(localAddress);
            } else {
                sock.bind(new InetSocketAddress(0));
            }
            long startTime = System.currentTimeMillis();
            long connectTime = 0L;
            try {
                sock.connect(remoteAddress, connectTimeout);
                connectTime = System.currentTimeMillis() - startTime;
                if (connectTime > (long)connectTimeout) {
                    Loggings.handshaker.warn("ThresholdTime={}: connectTime={}", (Object)connectTimeout, (Object)connectTime);
                }
            }
            catch (IOException e) {
                Loggings.ERROR.error("connect failed", (Throwable)e);
                throw e;
            }
            if (sock instanceof SSLSocket) {
                SSLSocket sslsock = (SSLSocket)sock;
                this.handshake(sslsock, context);
                return sock;
            }
            return this.createLayeredSocket(sock, host.getHostName(), remoteAddress.getPort(), context);
        }

        public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
            SSLSocket sslsock = (SSLSocket)this.socketfactory.createSocket(socket, target, port, true);
            this.setEnabledCipherSuites(sslsock);
            this.prepareSocket(sslsock, context);
            this.handshake(sslsock, context);
            return sslsock;
        }

        final void setEnabledCipherSuites(SSLSocket sslsock) {
            sslsock.setEnabledCipherSuites(supportedCipherSuites);
            System.err.println("EnabledCipherSuites: " + Arrays.asList(supportedCipherSuites));
        }

        final void prepareSocket(SSLSocket socket, HttpContext context) throws IOException {
        }

        final SSLSession handshake(SSLSocket sslsock, HttpContext context) throws IOException {
            long startTime = System.currentTimeMillis();
            try {
                sslsock.startHandshake();
                long handshakeTime = System.currentTimeMillis() - startTime;
                if (handshakeTime > (long)sslsock.getSoTimeout()) {
                    Loggings.handshaker.warn("ThresholdTime={}: handshakeTime={}", (Object)sslsock.getSoTimeout(), (Object)handshakeTime);
                }
                return sslsock.getSession();
            }
            catch (IOException e) {
                Loggings.ERROR.error("handshake failed", (Throwable)e);
                throw e;
            }
        }
    }
}

