/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.utils;

import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleFileUtil {
    private static final HashMap<String, ResourceBundleFileUtil> CONFIG_MAP = new HashMap();
    private ResourceBundle resourceBundle = null;
    private static final String NAME = "config";

    private ResourceBundleFileUtil(String name) {
        this.resourceBundle = ResourceBundle.getBundle(name);
    }

    public static synchronized ResourceBundleFileUtil getInstance() {
        return ResourceBundleFileUtil.getInstance(NAME);
    }

    public static synchronized ResourceBundleFileUtil getInstance(String name) {
        ResourceBundleFileUtil conf = CONFIG_MAP.get(name);
        if (null == conf) {
            conf = new ResourceBundleFileUtil(name);
            CONFIG_MAP.put(name, conf);
        }
        return conf;
    }

    public String get(String key) {
        try {
            return this.resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "";
        }
    }

    public Integer getInt(String key) {
        try {
            String value = this.resourceBundle.getString(key);
            return Integer.parseInt(value);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public boolean getBool(String key) {
        try {
            String value = this.resourceBundle.getString(key);
            return "true".equals(value);
        }
        catch (MissingResourceException e) {
            return false;
        }
    }
}

