/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.utils;

import com.xwbank.sdk.utils.Md5Alg;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final String EMPTY = "";

    public static boolean isNull(String ... srcs) {
        if (srcs == null || srcs.length == 0) {
            return true;
        }
        int n = 0;
        String[] stringArray = srcs;
        int n2 = stringArray.length;
        if (n < n2) {
            String src = stringArray[n];
            boolean isEmpty = EMPTY.equals(src);
            boolean isNull_S = src == null;
            return isEmpty || isNull_S;
        }
        return false;
    }

    public static boolean isStartWithHttp(String src) {
        return src.startsWith("http") || src.startsWith("https");
    }

    public static String transform(String json) {
        if (StringUtils.isNull(json)) {
            return json.replaceAll(":", "==").replaceAll(",", "&").replaceAll("\"", EMPTY).replaceAll("\\{", EMPTY).replaceAll("\\}", EMPTY);
        }
        return EMPTY;
    }

    public static String getAESRandomKey() {
        Random random = new Random();
        long longValue = random.nextLong();
        return String.format("%016x", longValue);
    }

    public static String getRandomString(int length) {
        String base = "012345678917219219201177112919013737312109128173361631281190281";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static boolean isMatch(String regex, String str) {
        boolean b = true;
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        b = m.matches();
        return b;
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean checkMd5(String md5, byte[] src) {
        String srcMd5 = StringUtils.getContentMd5(src);
        return md5.equalsIgnoreCase(srcMd5);
    }

    public static String getContentMd5(byte[] src) {
        Md5Alg md5Alm = new Md5Alg();
        md5Alm.update(src);
        byte[] args = md5Alm.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            sb.append(Integer.toHexString(0xFF & args[i] | 0xFFFFFF00).substring(6));
        }
        return sb.toString();
    }

    public static String getRandomKey() {
        Random random = new Random();
        long longValue = random.nextLong();
        return String.format("%016x", longValue);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

