/*
 * Decompiled with CFR 0.152.
 */
package com.czb.sap.sdk.service.impl;

import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import com.czb.commons.cfca.SM2CertUtils;
import com.czb.commons.cfca.SignVerUtils;
import com.czb.commons.security.cipher.sm.SM3Digest;
import com.czb.commons.security.cipher.sm.SM4Utils;
import com.czb.sap.sdk.exception.SdkException;
import com.czb.sap.sdk.tools.StringUtils;
import com.czb.sap.sdk.type.ErrorCode;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vot4java.runtime.Frame;
import vot4java.runtime.GenericObject;
import vot4java.runtime.StubObject;

public class OpenApiSecurityService {
    private static final Logger log;
    private Session session;

    static {
        Frame frame = new Frame(1, 0);
        int[] nArray = new int[]{1086589024, -690319015, 1274381458, -867633549};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case 1086589024: {
                    GenericObject genericObject = new GenericObject();
                    genericObject.setObject(OpenApiSecurityService.class);
                    frame.push(genericObject);
                    ++n;
                    break;
                }
                case -690319015: {
                    Class clazz = (Class)frame.pop().getObject();
                    Logger logger = LoggerFactory.getLogger((Class)clazz);
                    GenericObject genericObject = new GenericObject();
                    genericObject.setObject((Object)logger);
                    frame.push(genericObject);
                    ++n;
                    break;
                }
                case 1274381458: {
                    GenericObject genericObject = frame.pop();
                    log = (Logger)genericObject.getObject();
                    ++n;
                    break;
                }
                case -867633549: {
                    return;
                }
            }
        }
    }

    private Session getSession() throws Exception {
        if (this.session != null) {
            return this.session;
        }
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        this.session = JCrypto.getInstance().openSession("JSOFT_LIB");
        return this.session;
    }

    public String signature(String data, String appcode) {
        try {
            StringBuilder sb = new StringBuilder(data);
            sb.append(appcode);
            String src = sb.toString();
            byte[] md = new byte[32];
            byte[] msg1 = src.getBytes("UTF-8");
            SM3Digest sm3 = new SM3Digest();
            sm3.update(msg1, 0, msg1.length);
            sm3.doFinal(md, 0);
            String sign = new String(Hex.encode((byte[])md));
            return sign;
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u8be5\u8fd0\u884c\u73af\u5883\u4e0d\u652f\u6301UTF-8\u7f16\u7801,\u8bf7\u68c0\u67e5", (Throwable)e);
            throw new SdkException(ErrorCode.E0001, (Throwable)e);
        }
    }

    public String fileAbstract(byte[] data) {
        byte[] md = new byte[32];
        SM3Digest sm3 = new SM3Digest();
        sm3.update(data, 0, data.length);
        sm3.doFinal(md, 0);
        String sign = new String(Hex.encode((byte[])md));
        return sign;
    }

    public String encrypt(String data, String appcode) {
        String secretKey = this.secretKey(appcode);
        SM4Utils sm4 = new SM4Utils(secretKey, null, false);
        return sm4.encryptData_ECB(data);
    }

    public String decrypt(String data, String appcode) {
        String secretKey = this.secretKey(appcode);
        SM4Utils sm4 = new SM4Utils(secretKey, null, false);
        return sm4.decryptData_ECB(data);
    }

    private String secretKey(String string) {
        Frame frame = new Frame(3, 5);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject((Object)this);
        frame.setLocal(0, genericObject);
        GenericObject genericObject2 = new GenericObject();
        genericObject2.setObject((Object)string);
        frame.setLocal(1, genericObject2);
        int[] nArray = new int[]{1391200638, 1, -1338265887, -1771538448, 1689668562, 13, 1391200638, 1, -1437233557, -2026786409, 1628763087, 529287763, 1, -502797191, -1930789824, 575771267, -1037571374, -1612061592, 2, -2137913165, 667430716, 3, 1070785012, 44, 530316055, 3, -499394106, -873378764, -2137913165, -508658372, 1882127413, 4, 1575517718, 2, 1391200638, 1, 1021220363, 4, 1276547991, 925308186, -1991263798, -717817738, 3, 1, 530316055, 3, -1772256417, -1904571180, 24, 1575517718, 2, -156175431, -1586853834};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case 1391200638: {
                    GenericObject genericObject3 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject3);
                    n += 2;
                    break;
                }
                case -1338265887: {
                    Object object = frame.pop().getObject();
                    int n2 = ((String)object).length();
                    GenericObject genericObject4 = new GenericObject();
                    genericObject4.setInt(n2);
                    frame.push(genericObject4);
                    ++n;
                    break;
                }
                case -1771538448: {
                    GenericObject genericObject5 = new GenericObject();
                    genericObject5.setInt(32);
                    frame.push(genericObject5);
                    ++n;
                    break;
                }
                case 1689668562: {
                    int n3 = frame.pop().toInt();
                    int n4 = frame.pop().toInt();
                    if (n4 >= n3) {
                        n = nArray[n + 1];
                        break;
                    }
                    n += 2;
                    break;
                }
                case -1437233557: {
                    GenericObject genericObject6 = new GenericObject();
                    genericObject6.setInt(32);
                    frame.push(genericObject6);
                    ++n;
                    break;
                }
                case -2026786409: {
                    GenericObject genericObject7 = new GenericObject();
                    genericObject7.setString("MA==");
                    frame.push(genericObject7);
                    ++n;
                    break;
                }
                case 1628763087: {
                    String string2 = (String)frame.pop().getObject();
                    int n5 = frame.pop().getInt();
                    String string3 = (String)frame.pop().getObject();
                    String string4 = StringUtils.leftPad(string3, n5, string2);
                    GenericObject genericObject8 = new GenericObject();
                    genericObject8.setObject((Object)string4);
                    frame.push(genericObject8);
                    ++n;
                    break;
                }
                case 529287763: {
                    GenericObject genericObject9 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject9);
                    n += 2;
                    break;
                }
                case -502797191: {
                    StubObject stubObject = new StubObject("java.lang.StringBuilder");
                    GenericObject genericObject10 = new GenericObject();
                    genericObject10.setObject((Object)stubObject);
                    frame.push(genericObject10);
                    ++n;
                    break;
                }
                case -1930789824: {
                    GenericObject genericObject11 = frame.peek();
                    frame.push(genericObject11);
                    ++n;
                    break;
                }
                case 575771267: {
                    GenericObject genericObject12 = new GenericObject();
                    genericObject12.setInt(16);
                    frame.push(genericObject12);
                    ++n;
                    break;
                }
                case -1037571374: {
                    int n6 = frame.pop().getInt();
                    StringBuilder stringBuilder = new StringBuilder(n6);
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject13 = new GenericObject();
                    genericObject13.setObject((Object)stringBuilder);
                    frame.push(genericObject13);
                    ++n;
                    break;
                }
                case -1612061592: {
                    GenericObject genericObject14 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject14);
                    n += 2;
                    break;
                }
                case -2137913165: {
                    GenericObject genericObject15 = new GenericObject();
                    genericObject15.setInt(1);
                    frame.push(genericObject15);
                    ++n;
                    break;
                }
                case 667430716: {
                    int n7 = frame.pop().toInt();
                    GenericObject genericObject16 = new GenericObject();
                    genericObject16.setInt(n7);
                    frame.setLocal(nArray[n + 1], genericObject16);
                    n += 2;
                    break;
                }
                case 1070785012: {
                    n = nArray[n + 1];
                    break;
                }
                case 530316055: {
                    GenericObject genericObject17 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject17);
                    n += 2;
                    break;
                }
                case -499394106: {
                    GenericObject genericObject18 = new GenericObject();
                    genericObject18.setInt(2);
                    frame.push(genericObject18);
                    ++n;
                    break;
                }
                case -873378764: {
                    GenericObject genericObject19 = frame.pop();
                    GenericObject genericObject20 = frame.pop();
                    GenericObject genericObject21 = new GenericObject();
                    genericObject21.setInt(genericObject20.getInt() * genericObject19.getInt());
                    frame.push(genericObject21);
                    ++n;
                    break;
                }
                case -508658372: {
                    GenericObject genericObject22 = frame.pop();
                    GenericObject genericObject23 = frame.pop();
                    GenericObject genericObject24 = new GenericObject();
                    genericObject24.setInt(genericObject23.getInt() - genericObject22.getInt());
                    frame.push(genericObject24);
                    ++n;
                    break;
                }
                case 1882127413: {
                    int n8 = frame.pop().toInt();
                    GenericObject genericObject25 = new GenericObject();
                    genericObject25.setInt(n8);
                    frame.setLocal(nArray[n + 1], genericObject25);
                    n += 2;
                    break;
                }
                case 1575517718: {
                    GenericObject genericObject26 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject26);
                    n += 2;
                    break;
                }
                case 1021220363: {
                    GenericObject genericObject27 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject27);
                    n += 2;
                    break;
                }
                case 1276547991: {
                    int n9 = frame.pop().getInt();
                    Object object = frame.pop().getObject();
                    char c = ((String)object).charAt(n9);
                    GenericObject genericObject28 = new GenericObject();
                    genericObject28.setChar(c);
                    frame.push(genericObject28);
                    ++n;
                    break;
                }
                case 925308186: {
                    char c = frame.pop().getChar();
                    Object object = frame.pop().getObject();
                    Object object2 = ((StringBuilder)object).append(c);
                    GenericObject genericObject29 = new GenericObject();
                    genericObject29.setObject(object2);
                    frame.push(genericObject29);
                    ++n;
                    break;
                }
                case -1991263798: {
                    frame.pop();
                    ++n;
                    break;
                }
                case -717817738: {
                    int n10 = nArray[n + 1];
                    int n11 = nArray[n + 2];
                    frame.iinc(n10, n11);
                    n += 3;
                    break;
                }
                case -1772256417: {
                    GenericObject genericObject30 = new GenericObject();
                    genericObject30.setInt(16);
                    frame.push(genericObject30);
                    ++n;
                    break;
                }
                case -1904571180: {
                    int n12 = frame.pop().toInt();
                    int n13 = frame.pop().toInt();
                    if (n13 <= n12) {
                        n = nArray[n + 1];
                        break;
                    }
                    n += 2;
                    break;
                }
                case -156175431: {
                    Object object = frame.pop().getObject();
                    Object object3 = ((StringBuilder)object).toString();
                    GenericObject genericObject31 = new GenericObject();
                    genericObject31.setObject(object3);
                    frame.push(genericObject31);
                    ++n;
                    break;
                }
                case -1586853834: {
                    return (String)frame.pop().getObject();
                }
            }
        }
    }

    public String cfcaSignature(String data, String sm2password, byte[] sm2Cert) {
        try {
            byte[] signedData = SignVerUtils.signature((byte[])sm2Cert, (String)sm2password, (byte[])data.getBytes(Charset.forName("UTF-8")), (Session)this.getSession());
            return new String(signedData, "UTF-8");
        }
        catch (Exception e) {
            log.error("\u7ec4\u88c5\u8bc1\u4e66\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
            throw new SdkException(ErrorCode.E0002, (Throwable)e);
        }
    }

    public boolean verify(String signData, String signResource) {
        try {
            return SignVerUtils.verify((byte[])signResource.getBytes(Charset.forName("UTF-8")), (byte[])signData.getBytes(Charset.forName("UTF-8")), (Session)this.getSession());
        }
        catch (Exception e) {
            log.error("\u8bc1\u4e66\u9a8c\u7b7e\u5f02\u5e38", (Throwable)e);
            throw new SdkException(ErrorCode.E0003, (Throwable)e);
        }
    }

    public boolean verifyDn(String signData, byte[] cerResource) {
        String cerDn;
        String signDn;
        block3: {
            try {
                signDn = SM2CertUtils.getDNFromSignData((byte[])signData.getBytes(Charset.forName("UTF-8")));
                signDn = signDn.replace("CN=", "cn=").replace(", OU=", ",ou=").replace(", O=", ",o=").replace(", C=", ",c=");
                X509Certificate certs = SM2CertUtils.getX509CertFromCer((byte[])cerResource);
                String dn = certs.getSubjectDN().getName();
                String[] s = dn.split(",");
                String[] ss0 = s[0].split("=");
                String ret0 = ss0[1].trim();
                String[] ss1 = s[1].split("=");
                String ret1 = ss1[1].trim();
                String[] ss2 = s[2].split("=");
                String ret2 = ss2[1].trim();
                String[] ss3 = s[3].split("=");
                String ret3 = ss3[1].trim();
                String[] ss4 = s[4].split("=");
                String ret4 = ss4[1].trim();
                cerDn = "cn=" + ret4 + ",ou=" + ret3 + ",ou=" + ret2 + ",o=" + ret1 + ",c=" + ret0;
                if (!StringUtils.equals(signDn, cerDn)) break block3;
                return true;
            }
            catch (Exception e) {
                log.error("\u8bc1\u4e66dn\u5f02\u5e38", (Throwable)e);
                throw new SdkException(ErrorCode.E0004, (Throwable)e);
            }
        }
        log.warn("\u8bc1\u4e66\u5173\u7cfb\u4e0d\u6b63\u786e \u62a5\u6587dn[{}],\u8bc1\u4e66dn [{}]", (Object)signDn, (Object)cerDn);
        return false;
    }
}

