/*
 * Decompiled with CFR 0.152.
 */
package com.czb.sap.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.czb.sap.sdk.config.EntAppConfig;
import com.czb.sap.sdk.exception.SdkException;
import com.czb.sap.sdk.inf.ApiHeader;
import com.czb.sap.sdk.inf.ApiRspData;
import com.czb.sap.sdk.inf.DownloadFileIn;
import com.czb.sap.sdk.inf.DownloadFileOut;
import com.czb.sap.sdk.inf.DownloadReqeust;
import com.czb.sap.sdk.inf.GetTokenIn;
import com.czb.sap.sdk.inf.GetTokenOut;
import com.czb.sap.sdk.inf.MakeH5GetOut;
import com.czb.sap.sdk.inf.OpenApiRequest;
import com.czb.sap.sdk.inf.OpenApiResponse;
import com.czb.sap.sdk.inf.RegisterTokenRequest;
import com.czb.sap.sdk.inf.RegisterTokenResponse;
import com.czb.sap.sdk.inf.UploadFileIn;
import com.czb.sap.sdk.inf.UploadFileOut;
import com.czb.sap.sdk.inf.UploadRequest;
import com.czb.sap.sdk.service.OpenApiService;
import com.czb.sap.sdk.service.impl.OpenApiSecurityService;
import com.czb.sap.sdk.tools.DateUtil;
import com.czb.sap.sdk.tools.HttpClientUtil;
import com.czb.sap.sdk.tools.SdkCache;
import com.czb.sap.sdk.tools.StringUtils;
import com.czb.sap.sdk.type.ErrorCode;
import com.czb.sap.sdk.type.TermianaType;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vot4java.runtime.Exp;
import vot4java.runtime.Frame;
import vot4java.runtime.GenericObject;
import vot4java.runtime.StubObject;

public class OpenApiServiceImpl
implements OpenApiService {
    private static final Logger log;
    private String appName;
    private EntAppConfig config;
    private OpenApiSecurityService securityService;
    private Lock lock = new ReentrantLock();

    static {
        Frame frame = new Frame(1, 0);
        int[] nArray = new int[]{-1362985661, 1765178410, -1569554664, 1775306088};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case -1362985661: {
                    GenericObject genericObject = new GenericObject();
                    genericObject.setObject(OpenApiServiceImpl.class);
                    frame.push(genericObject);
                    ++n;
                    break;
                }
                case 1765178410: {
                    Class clazz = (Class)frame.pop().getObject();
                    Logger logger = LoggerFactory.getLogger((Class)clazz);
                    GenericObject genericObject = new GenericObject();
                    genericObject.setObject((Object)logger);
                    frame.push(genericObject);
                    ++n;
                    break;
                }
                case -1569554664: {
                    GenericObject genericObject = frame.pop();
                    log = (Logger)genericObject.getObject();
                    ++n;
                    break;
                }
                case 1775306088: {
                    return;
                }
            }
        }
    }

    public OpenApiServiceImpl() {
        this.securityService = new OpenApiSecurityService();
    }

    @Override
    public GetTokenOut getToken(GetTokenIn in) throws SdkException {
        this.lock.lock();
        try {
            String outtimeout;
            String token;
            OpenApiRequest reqeust = new OpenApiRequest();
            reqeust.setAppid(this.config.getAppid());
            reqeust.setOpenid(this.config.getOpenid());
            if (StringUtils.isBlank(in.getSendtime())) {
                reqeust.setSendtime(DateUtil.getSendTime());
            } else {
                reqeust.setSendtime(in.getSendtime());
            }
            reqeust.setTermianatype(TermianaType.SDK.getCode());
            reqeust.setTraceno(in.getTraceno());
            String signResource = reqeust.signResource();
            String sign = this.securityService.signature(signResource, this.config.getAppkey());
            reqeust.setSign(sign);
            if (this.config.getCfcafile() != null && this.config.getCfcafile().length > 1) {
                String cfcaSign = this.securityService.cfcaSignature(signResource, this.config.getCfcapwd(), this.config.getCfcafile());
                reqeust.setCfcasign(cfcaSign);
            }
            URI url = this.config.createURI("token");
            String postJson = JSON.toJSONString((Object)reqeust);
            log.debug("\u83b7\u53d6token\u8bf7\u6c42:[{}]", (Object)postJson);
            String response = HttpClientUtil.post(url, postJson, this.config);
            log.debug("\u83b7\u53d6token\u5e94\u7b54:[{}]", (Object)response);
            OpenApiResponse out = (OpenApiResponse)JSON.parseObject((String)response, OpenApiResponse.class);
            GetTokenOut res = new GetTokenOut();
            res.setOrgtraceno(out.getOrgtraceno());
            res.setResultcode(out.getResultcode());
            res.setSenttime(out.getSendtime());
            res.setResultdesc(out.getResultdesc());
            if ("000000".equals(out.getResultcode())) {
                String body = this.securityService.decrypt(out.getBody(), this.config.getAppkey());
                JSONObject tokenBody = JSON.parseObject((String)body);
                token = tokenBody.getString("token");
                outtimeout = "19";
                if (tokenBody.containsKey((Object)"timeout")) {
                    outtimeout = tokenBody.getString("timeout");
                }
            } else {
                log.error("\u83b7\u53d6token\u5931\u8d25\uff0c\u5e94\u7b54\u7ed3\u679c[{}],\u53c2\u6570\u914d\u7f6e[{}}", (Object)JSON.toJSONString((Object)out), (Object)JSON.toJSONString((Object)this.config));
                throw new SdkException(ErrorCode.E0006);
            }
            res.setTimeout(outtimeout);
            res.setToken(token);
            SdkCache.getInstance().putValue(String.valueOf(this.appName) + "token", token);
            long timeout = Long.parseLong(outtimeout) * 1000L;
            long times = System.currentTimeMillis() + timeout;
            SdkCache.getInstance().putValue(String.valueOf(this.appName) + "tokentimeout", String.valueOf(times));
            GetTokenOut getTokenOut = res;
            return getTokenOut;
        }
        catch (SdkException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6token\u5931\u8d25,\u8bf7\u6c42\u6570\u636e[{}]", (Object)JSON.toJSONString((Object)in), (Object)e);
            throw new SdkException(ErrorCode.E0007, (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ApiRspData invoke(ApiHeader header, Map<String, Object> reqData) throws SdkException {
        try {
            OpenApiRequest reqeust = new OpenApiRequest();
            reqeust.setAppid(this.config.getAppid());
            reqeust.setOpenid(this.config.getOpenid());
            reqeust.setTermianatype(TermianaType.SDK.getCode());
            if (StringUtils.isNotBlank(header.getToken())) {
                reqeust.setToken(header.getToken());
            } else {
                reqeust.setToken(this.getCacheToken());
            }
            if (StringUtils.isBlank(header.getSendtime())) {
                reqeust.setSendtime(DateUtil.getSendTime());
            } else {
                reqeust.setSendtime(header.getSendtime());
            }
            reqeust.setTraceno(header.getTraceno());
            if (reqData != null && reqData.size() > 0) {
                String jsonBody = JSON.toJSONString(reqData);
                log.debug("\u6e90\u62a5\u6587[{}]", (Object)jsonBody);
                String body = this.securityService.encrypt(jsonBody, this.config.getAppkey());
                reqeust.setBody(body);
            }
            String signResource = reqeust.signResource();
            String sign = this.securityService.signature(signResource, this.config.getAppkey());
            reqeust.setSign(sign);
            if (this.config.getCfcafile() != null && this.config.getCfcafile().length > 1) {
                String cfcaSign = this.securityService.cfcaSignature(signResource, this.config.getCfcapwd(), this.config.getCfcafile());
                reqeust.setCfcasign(cfcaSign);
            }
            URI url = this.config.createURI(header.getMsgtype());
            String postJson = JSON.toJSONString((Object)reqeust);
            log.debug("\u8bf7\u6c42\u5730\u5740:[{}],\u62a5\u6587[{}]", (Object)url.toASCIIString(), (Object)postJson);
            String response = HttpClientUtil.post(url, postJson, this.config);
            log.debug("\u5e94\u7b54:[{}]", (Object)response);
            OpenApiResponse out = (OpenApiResponse)JSON.parseObject((String)response, OpenApiResponse.class);
            if (out != null && out.getResultcode() != null && !out.getResultcode().startsWith("820")) {
                this.checkApiSign(out);
            }
            if (out != null && "820019".equals(out.getResultcode())) {
                String token = SdkCache.getInstance().removeValue(String.valueOf(this.appName) + "token");
                log.warn("remove  token  [{}]", (Object)token);
                SdkCache.getInstance().removeValue(String.valueOf(this.appName) + "tokentimeout");
            }
            ApiRspData rsp = new ApiRspData();
            if (out != null) {
                rsp.setOrgtraceno(out.getOrgtraceno());
                rsp.setOrgmsgtype(out.getOrgtracetype());
                rsp.setResultcode(out.getResultcode());
                rsp.setResultdesc(out.getResultdesc());
                rsp.setSenttime(out.getSendtime());
                if (StringUtils.isNotBlank(out.getBody())) {
                    String jsonBody = this.securityService.decrypt(out.getBody(), this.config.getAppkey());
                    JSONObject outMap = JSON.parseObject((String)jsonBody);
                    rsp.setBody((Map<String, Object>)outMap);
                }
            }
            return rsp;
        }
        catch (SdkException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("\u53c2\u6570\u914d\u7f6e:[{}]", (Object)JSON.toJSONString((Object)this.config), (Object)e);
            throw new SdkException(ErrorCode.E0008, (Throwable)e);
        }
    }

    @Override
    public String getCacheToken() throws SdkException {
        Frame frame = new Frame(5, 5);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject((Object)this);
        frame.setLocal(0, genericObject);
        int[] nArray = new int[]{-308588775, -1476629480, -1051802703, -793491717, 0, 1439702569, -2038527121, 903241829, 1458563520, 112401413, -933363773, 1578218188, 2039753354, 1, -2102360240, -1476629480, -1051802703, -793491717, 0, -1518714731, 697559583, 1229437122, -325656378, 33306122, -2112705785, -1265648114, 1250460714, 2, 1203743136, 1, -697371638, 50, -226533216, 2, -697371638, 50, 2047421104, 1036474302, 3, -226533216, 2, -950117278, 696844540, 3, 1660204743, -1763084461, 50, 1203743136, 1, -74006628, -1476629480, -1051802703, -1002732308, 192897689, 3, -1706480247, 3, -1476629480, -1051802703, -848725353, 1761162184, -223484369, 1328468240, -1594781767, -793491717, 0, -1706480247, 3, 1714325818, -327499430, 4, 396767876, 4, -1540130794, 485891818};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case -308588775: {
                    SdkCache sdkCache = SdkCache.getInstance();
                    GenericObject genericObject2 = new GenericObject();
                    genericObject2.setObject((Object)sdkCache);
                    frame.push(genericObject2);
                    ++n;
                    break;
                }
                case -1476629480: {
                    StubObject stubObject = new StubObject("java.lang.StringBuilder");
                    GenericObject genericObject3 = new GenericObject();
                    genericObject3.setObject((Object)stubObject);
                    frame.push(genericObject3);
                    ++n;
                    break;
                }
                case -1051802703: {
                    GenericObject genericObject4 = frame.peek();
                    frame.push(genericObject4);
                    ++n;
                    break;
                }
                case -793491717: {
                    GenericObject genericObject5 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject5);
                    n += 2;
                    break;
                }
                case 1439702569: {
                    GenericObject genericObject6 = frame.pop();
                    GenericObject genericObject7 = new GenericObject();
                    genericObject7.setObject((Object)((OpenApiServiceImpl)genericObject6.getObject()).appName);
                    frame.push(genericObject7);
                    ++n;
                    break;
                }
                case -2038527121: {
                    Object object = frame.pop().getObject();
                    String string = String.valueOf(object);
                    GenericObject genericObject8 = new GenericObject();
                    genericObject8.setObject((Object)string);
                    frame.push(genericObject8);
                    ++n;
                    break;
                }
                case 903241829: {
                    Object object = frame.pop().getObject();
                    StringBuilder stringBuilder = new StringBuilder((String)object);
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject9 = new GenericObject();
                    genericObject9.setObject((Object)stringBuilder);
                    frame.push(genericObject9);
                    ++n;
                    break;
                }
                case 1458563520: {
                    GenericObject genericObject10 = new GenericObject();
                    genericObject10.setString("dG9rZW4=");
                    frame.push(genericObject10);
                    ++n;
                    break;
                }
                case 112401413: {
                    Object object = frame.pop().getObject();
                    Object object2 = frame.pop().getObject();
                    Object object3 = ((StringBuilder)object2).append((String)object);
                    GenericObject genericObject11 = new GenericObject();
                    genericObject11.setObject(object3);
                    frame.push(genericObject11);
                    ++n;
                    break;
                }
                case -933363773: {
                    Object object = frame.pop().getObject();
                    Object object4 = ((StringBuilder)object).toString();
                    GenericObject genericObject12 = new GenericObject();
                    genericObject12.setObject(object4);
                    frame.push(genericObject12);
                    ++n;
                    break;
                }
                case 1578218188: {
                    Object object = frame.pop().getObject();
                    Object object5 = frame.pop().getObject();
                    Object object6 = ((SdkCache)object5).getValue((String)object);
                    GenericObject genericObject13 = new GenericObject();
                    genericObject13.setObject(object6);
                    frame.push(genericObject13);
                    ++n;
                    break;
                }
                case 2039753354: {
                    GenericObject genericObject14 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject14);
                    n += 2;
                    break;
                }
                case -2102360240: {
                    SdkCache sdkCache = SdkCache.getInstance();
                    GenericObject genericObject15 = new GenericObject();
                    genericObject15.setObject((Object)sdkCache);
                    frame.push(genericObject15);
                    ++n;
                    break;
                }
                case -1518714731: {
                    GenericObject genericObject16 = frame.pop();
                    GenericObject genericObject17 = new GenericObject();
                    genericObject17.setObject((Object)((OpenApiServiceImpl)genericObject16.getObject()).appName);
                    frame.push(genericObject17);
                    ++n;
                    break;
                }
                case 697559583: {
                    Object object = frame.pop().getObject();
                    String string = String.valueOf(object);
                    GenericObject genericObject18 = new GenericObject();
                    genericObject18.setObject((Object)string);
                    frame.push(genericObject18);
                    ++n;
                    break;
                }
                case 1229437122: {
                    Object object = frame.pop().getObject();
                    StringBuilder stringBuilder = new StringBuilder((String)object);
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject19 = new GenericObject();
                    genericObject19.setObject((Object)stringBuilder);
                    frame.push(genericObject19);
                    ++n;
                    break;
                }
                case -325656378: {
                    GenericObject genericObject20 = new GenericObject();
                    genericObject20.setString("dG9rZW50aW1lb3V0");
                    frame.push(genericObject20);
                    ++n;
                    break;
                }
                case 33306122: {
                    Object object = frame.pop().getObject();
                    Object object7 = frame.pop().getObject();
                    Object object8 = ((StringBuilder)object7).append((String)object);
                    GenericObject genericObject21 = new GenericObject();
                    genericObject21.setObject(object8);
                    frame.push(genericObject21);
                    ++n;
                    break;
                }
                case -2112705785: {
                    Object object = frame.pop().getObject();
                    Object object9 = ((StringBuilder)object).toString();
                    GenericObject genericObject22 = new GenericObject();
                    genericObject22.setObject(object9);
                    frame.push(genericObject22);
                    ++n;
                    break;
                }
                case -1265648114: {
                    Object object = frame.pop().getObject();
                    Object object10 = frame.pop().getObject();
                    Object object11 = ((SdkCache)object10).getValue((String)object);
                    GenericObject genericObject23 = new GenericObject();
                    genericObject23.setObject(object11);
                    frame.push(genericObject23);
                    ++n;
                    break;
                }
                case 1250460714: {
                    GenericObject genericObject24 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject24);
                    n += 2;
                    break;
                }
                case 1203743136: {
                    GenericObject genericObject25 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject25);
                    n += 2;
                    break;
                }
                case -697371638: {
                    GenericObject genericObject26 = frame.pop();
                    if (genericObject26.getObject() == null) {
                        n = nArray[n + 1];
                        break;
                    }
                    n += 2;
                    break;
                }
                case -226533216: {
                    GenericObject genericObject27 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject27);
                    n += 2;
                    break;
                }
                case 2047421104: {
                    long l = System.currentTimeMillis();
                    GenericObject genericObject28 = new GenericObject();
                    genericObject28.setLong(l);
                    frame.push(genericObject28);
                    ++n;
                    break;
                }
                case 1036474302: {
                    long l = frame.pop().toLong();
                    GenericObject genericObject29 = new GenericObject();
                    genericObject29.setLong(l);
                    frame.setLocal(nArray[n + 1], genericObject29);
                    n += 2;
                    break;
                }
                case -950117278: {
                    String string = (String)frame.pop().getObject();
                    long l = Long.parseLong(string);
                    GenericObject genericObject30 = new GenericObject();
                    genericObject30.setLong(l);
                    frame.push(genericObject30);
                    ++n;
                    break;
                }
                case 696844540: {
                    GenericObject genericObject31 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject31);
                    n += 2;
                    break;
                }
                case 1660204743: {
                    long l = frame.pop().getLong();
                    long l2 = frame.pop().getLong();
                    GenericObject genericObject32 = new GenericObject();
                    int n2 = l2 == l ? 0 : (l2 > l ? 1 : -1);
                    genericObject32.setInt(n2);
                    frame.push(genericObject32);
                    ++n;
                    break;
                }
                case -1763084461: {
                    GenericObject genericObject33 = frame.pop();
                    int n3 = genericObject33.toInt();
                    if (n3 <= 0) {
                        n = nArray[n + 1];
                        break;
                    }
                    n += 2;
                    break;
                }
                case -74006628: {
                    return (String)frame.pop().getObject();
                }
                case -1002732308: {
                    GetTokenIn getTokenIn = new GetTokenIn();
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject34 = new GenericObject();
                    genericObject34.setObject((Object)getTokenIn);
                    frame.push(genericObject34);
                    ++n;
                    break;
                }
                case 192897689: {
                    GenericObject genericObject35 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject35);
                    n += 2;
                    break;
                }
                case -1706480247: {
                    GenericObject genericObject36 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject36);
                    n += 2;
                    break;
                }
                case -848725353: {
                    long l = System.currentTimeMillis();
                    GenericObject genericObject37 = new GenericObject();
                    genericObject37.setLong(l);
                    frame.push(genericObject37);
                    ++n;
                    break;
                }
                case 1761162184: {
                    long l = frame.pop().getLong();
                    String string = String.valueOf(l);
                    GenericObject genericObject38 = new GenericObject();
                    genericObject38.setObject((Object)string);
                    frame.push(genericObject38);
                    ++n;
                    break;
                }
                case -223484369: {
                    Object object = frame.pop().getObject();
                    StringBuilder stringBuilder = new StringBuilder((String)object);
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject39 = new GenericObject();
                    genericObject39.setObject((Object)stringBuilder);
                    frame.push(genericObject39);
                    ++n;
                    break;
                }
                case 1328468240: {
                    Object object = frame.pop().getObject();
                    Object object12 = ((StringBuilder)object).toString();
                    GenericObject genericObject40 = new GenericObject();
                    genericObject40.setObject(object12);
                    frame.push(genericObject40);
                    ++n;
                    break;
                }
                case -1594781767: {
                    Object object = frame.pop().getObject();
                    Object object13 = frame.pop().getObject();
                    ((GetTokenIn)object13).setTraceno((String)object);
                    ++n;
                    break;
                }
                case 1714325818: {
                    Object object = frame.pop().getObject();
                    Object object14 = frame.pop().getObject();
                    Object object15 = ((OpenApiServiceImpl)object14).getToken((GetTokenIn)object);
                    GenericObject genericObject41 = new GenericObject();
                    genericObject41.setObject(object15);
                    frame.push(genericObject41);
                    ++n;
                    break;
                }
                case -327499430: {
                    GenericObject genericObject42 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject42);
                    n += 2;
                    break;
                }
                case 396767876: {
                    GenericObject genericObject43 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject43);
                    n += 2;
                    break;
                }
                case -1540130794: {
                    Object object = frame.pop().getObject();
                    Object object16 = ((GetTokenOut)object).getToken();
                    GenericObject genericObject44 = new GenericObject();
                    genericObject44.setObject(object16);
                    frame.push(genericObject44);
                    ++n;
                    break;
                }
                case 485891818: {
                    return (String)frame.pop().getObject();
                }
            }
        }
    }

    private void checkApiSign(OpenApiResponse out) {
        String hsign = this.securityService.signature(out.signResource(), this.config.getAppkey());
        if (!StringUtils.equals(hsign, out.getSign())) {
            log.error("\u672c\u5730\u7b7e\u540d[{}],\u8fd4\u56de\u7b7e\u540d[{}]\uff0c\u8fd4\u56de\u62a5\u6587[{}]", new Object[]{hsign, out.getSign(), JSON.toJSONString((Object)out)});
            throw new SdkException(ErrorCode.E0010);
        }
        if (this.config.getCerfile() != null) {
            if (!this.securityService.verify(out.getCfcasign(), out.signResource())) {
                throw new SdkException(ErrorCode.E0011);
            }
            if (!this.securityService.verifyDn(out.getCfcasign(), this.config.getCerfile())) {
                throw new SdkException(ErrorCode.E0011);
            }
        }
    }

    /*
     * Opcode count of 13273 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    @Override
    public UploadFileOut uploadFile(UploadFileIn uploadFileIn) throws SdkException {
        Frame frame = new Frame(5, 9);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject((Object)this);
        frame.setLocal(0, genericObject);
        GenericObject genericObject2 = new GenericObject();
        genericObject2.setObject((Object)uploadFileIn);
        frame.setLocal(1, genericObject2);
        int[] nArray = new int[]{-309108469, -1480506984, 947215926, -154073476, 2, 260074518, 1, -1925915729, 1469306294, 3, 356626425, 1, -1482173465, 2115924921, -2102315625, 31, 1876964193, 1525754705, -1287284341, 3, 694055411, -1581226551, 764352784, 1843855454, -2083079258, 1, 1604026491, 1975436811, -285767231, -950902219, 3, 742205195, 2, -1810273320, 3, 295209936, 814444523, 2, 544357032, 1, 1334953861, -271726938, 2125292613, 2, 817958579, 1, -728796011, 1956166927, -1734627185, 1, -6827371, 1295414344, 547644546, 62, 1460722382, 2, -937999155, 1, 1695114528, 2045206606, 2043833056, 68, 1097663303, 2, 536424095, 0, 38943762, -1286339103, 370281716, -1797446316, 4, 956455281, 1, 652630993, 309807254, -243602664, 232, 466191622, 1, 1211419507, -51174181, -755658859, 5, 392521366, 2040455287, 6, -362764883, 1424995591, 7, 46219396, 226, 807997403, 2, 957444808, 740605254, 139440777, 6, -1986898291, 1538898828, -621198589, -1758366813, -908943788, 6, -1860828140, 110, 1069769553, 2, 666449742, 7, -350221071, 678965126, -644899993, 8, -886296079, 5, 2094506369, 0, 946494380, -1590739292, -660475749, 1283965989, -1200922173, 168, -173422382, 0, 937261038, 1998695396, -625864557, 486183086, 8, -1440424357, 8, 1631633103, 1, -1138658369, 1083743912, 6, 1337709967, 8, -221949851, 141147230, 0, -1596019738, -1980180692, 770859577, -604594487, 1195740558, 5, 892594364, 0, -1693168943, -435865162, -1782345660, 910764770, -240097583, 5, -800531835, 0, 1170704369, 475572177, 899430489, 271004378, 6, 1399756742, 1947211010, 6, 459053226, 188, 621400939, 5, -838863232, 8, -1520272351, 8, -904667121, 1, -1597243366, -173395219, 6, 1247608647, 8, -196073478, 942223685, 5, -1808679762, -855167890, 578358124, 5, 578934365, 2, 1123595581, 8, 1714459681, -340883046, 0, -1215222347, 2, -1060877007, -420178061, 4, -1562317107, 4, 134759836, 219, -2061225535, -707223247, -1207703671, 4, 11500205, 447008390, -1778893222, 219, 649929201, 4, -269416604, 742221700, 7, 2113259983, 226, -686743191, 4, 1220835573, 226, -1711845526, 4, -593649850, -946395011, 5, -1793319592, 91, -723796455, 257, 93653380, 2, 1307008256, 1, 1651687080, 1997146978, 810377163, 2, 797215352, 1, -836157523, -760196589, 2047280784, 2, -306895175, 1, 1246293431, -1782792396, -264812687, 0, 1607826639, 2, 1731763117, -1329720946, 4, -1772145563, 4, -874044895, 281, 1631574628, 1104022892, -1064236492, 4, -1564468782, -225123788, 818473125, 281, 1841612330, 4, 243157610, 1, 1634140617, -1933511976, 301196039, 4, -1257625163, 1, -434067914, 869137913, 855601465, 4, -1480736021, -1506193329, 2, 1112296205, 2, -1948058036, 317946640, 2, 2090928951, -1651048655, -85327967, 512898973, 2, 1465137207, 1418093792, 683979869};
        int n = 0;
        block761: while (true) {
            switch (nArray[n]) {
                case -309108469: {
                    try {
                        StubObject stubObject = new StubObject("com.czb.sap.sdk.inf.UploadRequest");
                        GenericObject genericObject3 = new GenericObject();
                        genericObject3.setObject((Object)stubObject);
                        frame.push(genericObject3);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject4 = new GenericObject();
                        genericObject4.setObject((Object)exception);
                        frame.push(genericObject4);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject5 = new GenericObject();
                        genericObject5.setObject((Object)error);
                        frame.push(genericObject5);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1480506984: {
                    try {
                        GenericObject genericObject6 = frame.peek();
                        frame.push(genericObject6);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject7 = new GenericObject();
                        genericObject7.setObject((Object)exception);
                        frame.push(genericObject7);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject8 = new GenericObject();
                        genericObject8.setObject((Object)error);
                        frame.push(genericObject8);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 947215926: {
                    try {
                        UploadRequest uploadRequest = new UploadRequest();
                        frame.pop();
                        frame.pop();
                        GenericObject genericObject9 = new GenericObject();
                        genericObject9.setObject((Object)uploadRequest);
                        frame.push(genericObject9);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject10 = new GenericObject();
                        genericObject10.setObject((Object)exception);
                        frame.push(genericObject10);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject11 = new GenericObject();
                        genericObject11.setObject((Object)error);
                        frame.push(genericObject11);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -154073476: {
                    try {
                        GenericObject genericObject12 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject12);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject13 = new GenericObject();
                        genericObject13.setObject((Object)exception);
                        frame.push(genericObject13);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject14 = new GenericObject();
                        genericObject14.setObject((Object)error);
                        frame.push(genericObject14);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 260074518: {
                    try {
                        GenericObject genericObject15 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject15);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject16 = new GenericObject();
                        genericObject16.setObject((Object)exception);
                        frame.push(genericObject16);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject17 = new GenericObject();
                        genericObject17.setObject((Object)error);
                        frame.push(genericObject17);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1925915729: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object2 = ((UploadFileIn)object).getFilename();
                        GenericObject genericObject18 = new GenericObject();
                        genericObject18.setObject(object2);
                        frame.push(genericObject18);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject19 = new GenericObject();
                        genericObject19.setObject((Object)exception);
                        frame.push(genericObject19);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject20 = new GenericObject();
                        genericObject20.setObject((Object)error);
                        frame.push(genericObject20);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1469306294: {
                    try {
                        GenericObject genericObject21 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject21);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject22 = new GenericObject();
                        genericObject22.setObject((Object)exception);
                        frame.push(genericObject22);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject23 = new GenericObject();
                        genericObject23.setObject((Object)error);
                        frame.push(genericObject23);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 356626425: {
                    try {
                        GenericObject genericObject24 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject24);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject25 = new GenericObject();
                        genericObject25.setObject((Object)exception);
                        frame.push(genericObject25);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject26 = new GenericObject();
                        genericObject26.setObject((Object)error);
                        frame.push(genericObject26);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1482173465: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object3 = ((UploadFileIn)object).getType();
                        GenericObject genericObject27 = new GenericObject();
                        genericObject27.setObject(object3);
                        frame.push(genericObject27);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject28 = new GenericObject();
                        genericObject28.setObject((Object)exception);
                        frame.push(genericObject28);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject29 = new GenericObject();
                        genericObject29.setObject((Object)error);
                        frame.push(genericObject29);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 2115924921: {
                    try {
                        CharSequence charSequence = (CharSequence)frame.pop().getObject();
                        boolean bl = StringUtils.isNotBlank(charSequence);
                        GenericObject genericObject30 = new GenericObject();
                        genericObject30.setBoolean(bl);
                        frame.push(genericObject30);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject31 = new GenericObject();
                        genericObject31.setObject((Object)exception);
                        frame.push(genericObject31);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject32 = new GenericObject();
                        genericObject32.setObject((Object)error);
                        frame.push(genericObject32);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -2102315625: {
                    try {
                        GenericObject genericObject33 = frame.pop();
                        int n2 = genericObject33.toInt();
                        if (n2 == 0) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject34 = new GenericObject();
                        genericObject34.setObject((Object)exception);
                        frame.push(genericObject34);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject35 = new GenericObject();
                        genericObject35.setObject((Object)error);
                        frame.push(genericObject35);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1876964193: {
                    try {
                        StubObject stubObject = new StubObject("java.lang.StringBuilder");
                        GenericObject genericObject36 = new GenericObject();
                        genericObject36.setObject((Object)stubObject);
                        frame.push(genericObject36);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject37 = new GenericObject();
                        genericObject37.setObject((Object)exception);
                        frame.push(genericObject37);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject38 = new GenericObject();
                        genericObject38.setObject((Object)error);
                        frame.push(genericObject38);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1525754705: {
                    try {
                        GenericObject genericObject39 = frame.peek();
                        frame.push(genericObject39);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject40 = new GenericObject();
                        genericObject40.setObject((Object)exception);
                        frame.push(genericObject40);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject41 = new GenericObject();
                        genericObject41.setObject((Object)error);
                        frame.push(genericObject41);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1287284341: {
                    try {
                        GenericObject genericObject42 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject42);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject43 = new GenericObject();
                        genericObject43.setObject((Object)exception);
                        frame.push(genericObject43);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject44 = new GenericObject();
                        genericObject44.setObject((Object)error);
                        frame.push(genericObject44);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 694055411: {
                    try {
                        Object object = frame.pop().getObject();
                        String string = String.valueOf(object);
                        GenericObject genericObject45 = new GenericObject();
                        genericObject45.setObject((Object)string);
                        frame.push(genericObject45);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject46 = new GenericObject();
                        genericObject46.setObject((Object)exception);
                        frame.push(genericObject46);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject47 = new GenericObject();
                        genericObject47.setObject((Object)error);
                        frame.push(genericObject47);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1581226551: {
                    try {
                        Object object = frame.pop().getObject();
                        StringBuilder stringBuilder = new StringBuilder((String)object);
                        frame.pop();
                        frame.pop();
                        GenericObject genericObject48 = new GenericObject();
                        genericObject48.setObject((Object)stringBuilder);
                        frame.push(genericObject48);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject49 = new GenericObject();
                        genericObject49.setObject((Object)exception);
                        frame.push(genericObject49);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject50 = new GenericObject();
                        genericObject50.setObject((Object)error);
                        frame.push(genericObject50);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 764352784: {
                    try {
                        GenericObject genericObject51 = new GenericObject();
                        genericObject51.setString("Lg==");
                        frame.push(genericObject51);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject52 = new GenericObject();
                        genericObject52.setObject((Object)exception);
                        frame.push(genericObject52);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject53 = new GenericObject();
                        genericObject53.setObject((Object)error);
                        frame.push(genericObject53);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1843855454: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object4 = frame.pop().getObject();
                        Object object5 = ((StringBuilder)object4).append((String)object);
                        GenericObject genericObject54 = new GenericObject();
                        genericObject54.setObject(object5);
                        frame.push(genericObject54);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject55 = new GenericObject();
                        genericObject55.setObject((Object)exception);
                        frame.push(genericObject55);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject56 = new GenericObject();
                        genericObject56.setObject((Object)error);
                        frame.push(genericObject56);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -2083079258: {
                    try {
                        GenericObject genericObject57 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject57);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject58 = new GenericObject();
                        genericObject58.setObject((Object)exception);
                        frame.push(genericObject58);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject59 = new GenericObject();
                        genericObject59.setObject((Object)error);
                        frame.push(genericObject59);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1604026491: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object6 = ((UploadFileIn)object).getType();
                        GenericObject genericObject60 = new GenericObject();
                        genericObject60.setObject(object6);
                        frame.push(genericObject60);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject61 = new GenericObject();
                        genericObject61.setObject((Object)exception);
                        frame.push(genericObject61);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject62 = new GenericObject();
                        genericObject62.setObject((Object)error);
                        frame.push(genericObject62);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1975436811: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object7 = frame.pop().getObject();
                        Object object8 = ((StringBuilder)object7).append((String)object);
                        GenericObject genericObject63 = new GenericObject();
                        genericObject63.setObject(object8);
                        frame.push(genericObject63);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject64 = new GenericObject();
                        genericObject64.setObject((Object)exception);
                        frame.push(genericObject64);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject65 = new GenericObject();
                        genericObject65.setObject((Object)error);
                        frame.push(genericObject65);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -285767231: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object9 = ((StringBuilder)object).toString();
                        GenericObject genericObject66 = new GenericObject();
                        genericObject66.setObject(object9);
                        frame.push(genericObject66);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject67 = new GenericObject();
                        genericObject67.setObject((Object)exception);
                        frame.push(genericObject67);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject68 = new GenericObject();
                        genericObject68.setObject((Object)error);
                        frame.push(genericObject68);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -950902219: {
                    try {
                        GenericObject genericObject69 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject69);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject70 = new GenericObject();
                        genericObject70.setObject((Object)exception);
                        frame.push(genericObject70);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject71 = new GenericObject();
                        genericObject71.setObject((Object)error);
                        frame.push(genericObject71);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 742205195: {
                    try {
                        GenericObject genericObject72 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject72);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject73 = new GenericObject();
                        genericObject73.setObject((Object)exception);
                        frame.push(genericObject73);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject74 = new GenericObject();
                        genericObject74.setObject((Object)error);
                        frame.push(genericObject74);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1810273320: {
                    try {
                        GenericObject genericObject75 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject75);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject76 = new GenericObject();
                        genericObject76.setObject((Object)exception);
                        frame.push(genericObject76);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject77 = new GenericObject();
                        genericObject77.setObject((Object)error);
                        frame.push(genericObject77);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 295209936: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object10 = frame.pop().getObject();
                        ((UploadRequest)object10).setFilename((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject78 = new GenericObject();
                        genericObject78.setObject((Object)exception);
                        frame.push(genericObject78);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject79 = new GenericObject();
                        genericObject79.setObject((Object)error);
                        frame.push(genericObject79);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 814444523: {
                    try {
                        GenericObject genericObject80 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject80);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject81 = new GenericObject();
                        genericObject81.setObject((Object)exception);
                        frame.push(genericObject81);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject82 = new GenericObject();
                        genericObject82.setObject((Object)error);
                        frame.push(genericObject82);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 544357032: {
                    try {
                        GenericObject genericObject83 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject83);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject84 = new GenericObject();
                        genericObject84.setObject((Object)exception);
                        frame.push(genericObject84);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject85 = new GenericObject();
                        genericObject85.setObject((Object)error);
                        frame.push(genericObject85);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1334953861: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object11 = ((UploadFileIn)object).getTraceno();
                        GenericObject genericObject86 = new GenericObject();
                        genericObject86.setObject(object11);
                        frame.push(genericObject86);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject87 = new GenericObject();
                        genericObject87.setObject((Object)exception);
                        frame.push(genericObject87);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject88 = new GenericObject();
                        genericObject88.setObject((Object)error);
                        frame.push(genericObject88);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -271726938: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object12 = frame.pop().getObject();
                        ((UploadRequest)object12).setTraceno((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject89 = new GenericObject();
                        genericObject89.setObject((Object)exception);
                        frame.push(genericObject89);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject90 = new GenericObject();
                        genericObject90.setObject((Object)error);
                        frame.push(genericObject90);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 2125292613: {
                    try {
                        GenericObject genericObject91 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject91);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject92 = new GenericObject();
                        genericObject92.setObject((Object)exception);
                        frame.push(genericObject92);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject93 = new GenericObject();
                        genericObject93.setObject((Object)error);
                        frame.push(genericObject93);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 817958579: {
                    try {
                        GenericObject genericObject94 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject94);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject95 = new GenericObject();
                        genericObject95.setObject((Object)exception);
                        frame.push(genericObject95);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject96 = new GenericObject();
                        genericObject96.setObject((Object)error);
                        frame.push(genericObject96);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -728796011: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object13 = ((UploadFileIn)object).getFilegroup();
                        GenericObject genericObject97 = new GenericObject();
                        genericObject97.setObject(object13);
                        frame.push(genericObject97);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject98 = new GenericObject();
                        genericObject98.setObject((Object)exception);
                        frame.push(genericObject98);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject99 = new GenericObject();
                        genericObject99.setObject((Object)error);
                        frame.push(genericObject99);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1956166927: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object14 = frame.pop().getObject();
                        ((UploadRequest)object14).setGroup((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject100 = new GenericObject();
                        genericObject100.setObject((Object)exception);
                        frame.push(genericObject100);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject101 = new GenericObject();
                        genericObject101.setObject((Object)error);
                        frame.push(genericObject101);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1734627185: {
                    try {
                        GenericObject genericObject102 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject102);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject103 = new GenericObject();
                        genericObject103.setObject((Object)exception);
                        frame.push(genericObject103);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject104 = new GenericObject();
                        genericObject104.setObject((Object)error);
                        frame.push(genericObject104);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -6827371: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object15 = ((UploadFileIn)object).getToken();
                        GenericObject genericObject105 = new GenericObject();
                        genericObject105.setObject(object15);
                        frame.push(genericObject105);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject106 = new GenericObject();
                        genericObject106.setObject((Object)exception);
                        frame.push(genericObject106);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject107 = new GenericObject();
                        genericObject107.setObject((Object)error);
                        frame.push(genericObject107);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1295414344: {
                    try {
                        CharSequence charSequence = (CharSequence)frame.pop().getObject();
                        boolean bl = StringUtils.isNotBlank(charSequence);
                        GenericObject genericObject108 = new GenericObject();
                        genericObject108.setBoolean(bl);
                        frame.push(genericObject108);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject109 = new GenericObject();
                        genericObject109.setObject((Object)exception);
                        frame.push(genericObject109);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject110 = new GenericObject();
                        genericObject110.setObject((Object)error);
                        frame.push(genericObject110);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 547644546: {
                    try {
                        GenericObject genericObject111 = frame.pop();
                        int n3 = genericObject111.toInt();
                        if (n3 == 0) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject112 = new GenericObject();
                        genericObject112.setObject((Object)exception);
                        frame.push(genericObject112);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject113 = new GenericObject();
                        genericObject113.setObject((Object)error);
                        frame.push(genericObject113);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1460722382: {
                    try {
                        GenericObject genericObject114 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject114);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject115 = new GenericObject();
                        genericObject115.setObject((Object)exception);
                        frame.push(genericObject115);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject116 = new GenericObject();
                        genericObject116.setObject((Object)error);
                        frame.push(genericObject116);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -937999155: {
                    try {
                        GenericObject genericObject117 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject117);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject118 = new GenericObject();
                        genericObject118.setObject((Object)exception);
                        frame.push(genericObject118);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject119 = new GenericObject();
                        genericObject119.setObject((Object)error);
                        frame.push(genericObject119);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1695114528: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object16 = ((UploadFileIn)object).getToken();
                        GenericObject genericObject120 = new GenericObject();
                        genericObject120.setObject(object16);
                        frame.push(genericObject120);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject121 = new GenericObject();
                        genericObject121.setObject((Object)exception);
                        frame.push(genericObject121);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject122 = new GenericObject();
                        genericObject122.setObject((Object)error);
                        frame.push(genericObject122);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 2045206606: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object17 = frame.pop().getObject();
                        ((UploadRequest)object17).setToken((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject123 = new GenericObject();
                        genericObject123.setObject((Object)exception);
                        frame.push(genericObject123);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject124 = new GenericObject();
                        genericObject124.setObject((Object)error);
                        frame.push(genericObject124);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 2043833056: {
                    try {
                        n = nArray[n + 1];
                    }
                    catch (Exception exception) {
                        GenericObject genericObject125 = new GenericObject();
                        genericObject125.setObject((Object)exception);
                        frame.push(genericObject125);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject126 = new GenericObject();
                        genericObject126.setObject((Object)error);
                        frame.push(genericObject126);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1097663303: {
                    try {
                        GenericObject genericObject127 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject127);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject128 = new GenericObject();
                        genericObject128.setObject((Object)exception);
                        frame.push(genericObject128);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject129 = new GenericObject();
                        genericObject129.setObject((Object)error);
                        frame.push(genericObject129);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 536424095: {
                    try {
                        GenericObject genericObject130 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject130);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject131 = new GenericObject();
                        genericObject131.setObject((Object)exception);
                        frame.push(genericObject131);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject132 = new GenericObject();
                        genericObject132.setObject((Object)error);
                        frame.push(genericObject132);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 38943762: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object18 = ((OpenApiServiceImpl)object).getCacheToken();
                        GenericObject genericObject133 = new GenericObject();
                        genericObject133.setObject(object18);
                        frame.push(genericObject133);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject134 = new GenericObject();
                        genericObject134.setObject((Object)exception);
                        frame.push(genericObject134);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject135 = new GenericObject();
                        genericObject135.setObject((Object)error);
                        frame.push(genericObject135);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1286339103: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object19 = frame.pop().getObject();
                        ((UploadRequest)object19).setToken((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject136 = new GenericObject();
                        genericObject136.setObject((Object)exception);
                        frame.push(genericObject136);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject137 = new GenericObject();
                        genericObject137.setObject((Object)error);
                        frame.push(genericObject137);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 370281716: {
                    try {
                        GenericObject genericObject138 = new GenericObject();
                        genericObject138.setObject(null);
                        frame.push(genericObject138);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject139 = new GenericObject();
                        genericObject139.setObject((Object)exception);
                        frame.push(genericObject139);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject140 = new GenericObject();
                        genericObject140.setObject((Object)error);
                        frame.push(genericObject140);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1797446316: {
                    try {
                        GenericObject genericObject141 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject141);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject142 = new GenericObject();
                        genericObject142.setObject((Object)exception);
                        frame.push(genericObject142);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject143 = new GenericObject();
                        genericObject143.setObject((Object)error);
                        frame.push(genericObject143);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 956455281: {
                    try {
                        GenericObject genericObject144 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject144);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject145 = new GenericObject();
                        genericObject145.setObject((Object)exception);
                        frame.push(genericObject145);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject146 = new GenericObject();
                        genericObject146.setObject((Object)error);
                        frame.push(genericObject146);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 652630993: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object20 = ((UploadFileIn)object).getFileid();
                        GenericObject genericObject147 = new GenericObject();
                        genericObject147.setObject(object20);
                        frame.push(genericObject147);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject148 = new GenericObject();
                        genericObject148.setObject((Object)exception);
                        frame.push(genericObject148);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject149 = new GenericObject();
                        genericObject149.setObject((Object)error);
                        frame.push(genericObject149);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 309807254: {
                    try {
                        CharSequence charSequence = (CharSequence)frame.pop().getObject();
                        boolean bl = StringUtils.isBlank(charSequence);
                        GenericObject genericObject150 = new GenericObject();
                        genericObject150.setBoolean(bl);
                        frame.push(genericObject150);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject151 = new GenericObject();
                        genericObject151.setObject((Object)exception);
                        frame.push(genericObject151);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject152 = new GenericObject();
                        genericObject152.setObject((Object)error);
                        frame.push(genericObject152);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -243602664: {
                    try {
                        GenericObject genericObject153 = frame.pop();
                        int n4 = genericObject153.toInt();
                        if (n4 == 0) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject154 = new GenericObject();
                        genericObject154.setObject((Object)exception);
                        frame.push(genericObject154);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject155 = new GenericObject();
                        genericObject155.setObject((Object)error);
                        frame.push(genericObject155);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 466191622: {
                    try {
                        GenericObject genericObject156 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject156);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject157 = new GenericObject();
                        genericObject157.setObject((Object)exception);
                        frame.push(genericObject157);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject158 = new GenericObject();
                        genericObject158.setObject((Object)error);
                        frame.push(genericObject158);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1211419507: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object21 = ((UploadFileIn)object).getFile();
                        GenericObject genericObject159 = new GenericObject();
                        genericObject159.setObject(object21);
                        frame.push(genericObject159);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject160 = new GenericObject();
                        genericObject160.setObject((Object)exception);
                        frame.push(genericObject160);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject161 = new GenericObject();
                        genericObject161.setObject((Object)error);
                        frame.push(genericObject161);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -51174181: {
                    try {
                        GenericObject genericObject162 = frame.pop();
                        int n5 = genericObject162.arrayLength();
                        GenericObject genericObject163 = new GenericObject();
                        genericObject163.setInt(n5);
                        frame.push(genericObject163);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject164 = new GenericObject();
                        genericObject164.setObject((Object)exception);
                        frame.push(genericObject164);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject165 = new GenericObject();
                        genericObject165.setObject((Object)error);
                        frame.push(genericObject165);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -755658859: {
                    try {
                        int n6 = frame.pop().toInt();
                        GenericObject genericObject166 = new GenericObject();
                        genericObject166.setInt(n6);
                        frame.setLocal(nArray[n + 1], genericObject166);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject167 = new GenericObject();
                        genericObject167.setObject((Object)exception);
                        frame.push(genericObject167);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject168 = new GenericObject();
                        genericObject168.setObject((Object)error);
                        frame.push(genericObject168);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 392521366: {
                    try {
                        GenericObject genericObject169 = new GenericObject();
                        genericObject169.setInt(0);
                        frame.push(genericObject169);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject170 = new GenericObject();
                        genericObject170.setObject((Object)exception);
                        frame.push(genericObject170);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject171 = new GenericObject();
                        genericObject171.setObject((Object)error);
                        frame.push(genericObject171);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 2040455287: {
                    try {
                        int n7 = frame.pop().toInt();
                        GenericObject genericObject172 = new GenericObject();
                        genericObject172.setInt(n7);
                        frame.setLocal(nArray[n + 1], genericObject172);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject173 = new GenericObject();
                        genericObject173.setObject((Object)exception);
                        frame.push(genericObject173);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject174 = new GenericObject();
                        genericObject174.setObject((Object)error);
                        frame.push(genericObject174);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -362764883: {
                    try {
                        GenericObject genericObject175 = new GenericObject();
                        genericObject175.setString("");
                        frame.push(genericObject175);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject176 = new GenericObject();
                        genericObject176.setObject((Object)exception);
                        frame.push(genericObject176);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject177 = new GenericObject();
                        genericObject177.setObject((Object)error);
                        frame.push(genericObject177);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1424995591: {
                    try {
                        GenericObject genericObject178 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject178);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject179 = new GenericObject();
                        genericObject179.setObject((Object)exception);
                        frame.push(genericObject179);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject180 = new GenericObject();
                        genericObject180.setObject((Object)error);
                        frame.push(genericObject180);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 46219396: {
                    try {
                        n = nArray[n + 1];
                    }
                    catch (Exception exception) {
                        GenericObject genericObject181 = new GenericObject();
                        genericObject181.setObject((Object)exception);
                        frame.push(genericObject181);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject182 = new GenericObject();
                        genericObject182.setObject((Object)error);
                        frame.push(genericObject182);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 807997403: {
                    try {
                        GenericObject genericObject183 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject183);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject184 = new GenericObject();
                        genericObject184.setObject((Object)exception);
                        frame.push(genericObject184);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject185 = new GenericObject();
                        genericObject185.setObject((Object)error);
                        frame.push(genericObject185);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 957444808: {
                    try {
                        StubObject stubObject = new StubObject("java.lang.StringBuilder");
                        GenericObject genericObject186 = new GenericObject();
                        genericObject186.setObject((Object)stubObject);
                        frame.push(genericObject186);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject187 = new GenericObject();
                        genericObject187.setObject((Object)exception);
                        frame.push(genericObject187);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject188 = new GenericObject();
                        genericObject188.setObject((Object)error);
                        frame.push(genericObject188);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 740605254: {
                    try {
                        GenericObject genericObject189 = frame.peek();
                        frame.push(genericObject189);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject190 = new GenericObject();
                        genericObject190.setObject((Object)exception);
                        frame.push(genericObject190);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject191 = new GenericObject();
                        genericObject191.setObject((Object)error);
                        frame.push(genericObject191);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 139440777: {
                    try {
                        GenericObject genericObject192 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject192);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject193 = new GenericObject();
                        genericObject193.setObject((Object)exception);
                        frame.push(genericObject193);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject194 = new GenericObject();
                        genericObject194.setObject((Object)error);
                        frame.push(genericObject194);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1986898291: {
                    try {
                        int n8 = frame.pop().getInt();
                        String string = String.valueOf(n8);
                        GenericObject genericObject195 = new GenericObject();
                        genericObject195.setObject((Object)string);
                        frame.push(genericObject195);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject196 = new GenericObject();
                        genericObject196.setObject((Object)exception);
                        frame.push(genericObject196);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject197 = new GenericObject();
                        genericObject197.setObject((Object)error);
                        frame.push(genericObject197);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1538898828: {
                    try {
                        Object object = frame.pop().getObject();
                        StringBuilder stringBuilder = new StringBuilder((String)object);
                        frame.pop();
                        frame.pop();
                        GenericObject genericObject198 = new GenericObject();
                        genericObject198.setObject((Object)stringBuilder);
                        frame.push(genericObject198);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject199 = new GenericObject();
                        genericObject199.setObject((Object)exception);
                        frame.push(genericObject199);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject200 = new GenericObject();
                        genericObject200.setObject((Object)error);
                        frame.push(genericObject200);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -621198589: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object22 = ((StringBuilder)object).toString();
                        GenericObject genericObject201 = new GenericObject();
                        genericObject201.setObject(object22);
                        frame.push(genericObject201);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject202 = new GenericObject();
                        genericObject202.setObject((Object)exception);
                        frame.push(genericObject202);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject203 = new GenericObject();
                        genericObject203.setObject((Object)error);
                        frame.push(genericObject203);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1758366813: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object23 = frame.pop().getObject();
                        ((UploadRequest)object23).setOffset((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject204 = new GenericObject();
                        genericObject204.setObject((Object)exception);
                        frame.push(genericObject204);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject205 = new GenericObject();
                        genericObject205.setObject((Object)error);
                        frame.push(genericObject205);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -908943788: {
                    try {
                        GenericObject genericObject206 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject206);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject207 = new GenericObject();
                        genericObject207.setObject((Object)exception);
                        frame.push(genericObject207);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject208 = new GenericObject();
                        genericObject208.setObject((Object)error);
                        frame.push(genericObject208);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1860828140: {
                    try {
                        GenericObject genericObject209 = frame.pop();
                        int n9 = genericObject209.toInt();
                        if (n9 == 0) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject210 = new GenericObject();
                        genericObject210.setObject((Object)exception);
                        frame.push(genericObject210);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject211 = new GenericObject();
                        genericObject211.setObject((Object)error);
                        frame.push(genericObject211);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1069769553: {
                    try {
                        GenericObject genericObject212 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject212);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject213 = new GenericObject();
                        genericObject213.setObject((Object)exception);
                        frame.push(genericObject213);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject214 = new GenericObject();
                        genericObject214.setObject((Object)error);
                        frame.push(genericObject214);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 666449742: {
                    try {
                        GenericObject genericObject215 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject215);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject216 = new GenericObject();
                        genericObject216.setObject((Object)exception);
                        frame.push(genericObject216);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject217 = new GenericObject();
                        genericObject217.setObject((Object)error);
                        frame.push(genericObject217);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -350221071: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object24 = frame.pop().getObject();
                        ((UploadRequest)object24).setFileid((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject218 = new GenericObject();
                        genericObject218.setObject((Object)exception);
                        frame.push(genericObject218);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject219 = new GenericObject();
                        genericObject219.setObject((Object)error);
                        frame.push(genericObject219);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 678965126: {
                    try {
                        GenericObject genericObject220 = new GenericObject();
                        genericObject220.setObject(null);
                        frame.push(genericObject220);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject221 = new GenericObject();
                        genericObject221.setObject((Object)exception);
                        frame.push(genericObject221);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject222 = new GenericObject();
                        genericObject222.setObject((Object)error);
                        frame.push(genericObject222);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -644899993: {
                    try {
                        GenericObject genericObject223 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject223);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject224 = new GenericObject();
                        genericObject224.setObject((Object)exception);
                        frame.push(genericObject224);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject225 = new GenericObject();
                        genericObject225.setObject((Object)error);
                        frame.push(genericObject225);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -886296079: {
                    try {
                        GenericObject genericObject226 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject226);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject227 = new GenericObject();
                        genericObject227.setObject((Object)exception);
                        frame.push(genericObject227);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject228 = new GenericObject();
                        genericObject228.setObject((Object)error);
                        frame.push(genericObject228);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 2094506369: {
                    try {
                        GenericObject genericObject229 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject229);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject230 = new GenericObject();
                        genericObject230.setObject((Object)exception);
                        frame.push(genericObject230);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject231 = new GenericObject();
                        genericObject231.setObject((Object)error);
                        frame.push(genericObject231);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 946494380: {
                    try {
                        GenericObject genericObject232 = frame.pop();
                        GenericObject genericObject233 = new GenericObject();
                        genericObject233.setObject((Object)((OpenApiServiceImpl)genericObject232.getObject()).config);
                        frame.push(genericObject233);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject234 = new GenericObject();
                        genericObject234.setObject((Object)exception);
                        frame.push(genericObject234);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject235 = new GenericObject();
                        genericObject235.setObject((Object)error);
                        frame.push(genericObject235);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1590739292: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object25 = ((EntAppConfig)object).getUpdatasize();
                        GenericObject genericObject236 = new GenericObject();
                        genericObject236.setObject(object25);
                        frame.push(genericObject236);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject237 = new GenericObject();
                        genericObject237.setObject((Object)exception);
                        frame.push(genericObject237);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject238 = new GenericObject();
                        genericObject238.setObject((Object)error);
                        frame.push(genericObject238);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -660475749: {
                    try {
                        Object object = frame.pop().getObject();
                        int n10 = (Integer)object;
                        GenericObject genericObject239 = new GenericObject();
                        genericObject239.setInt(n10);
                        frame.push(genericObject239);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject240 = new GenericObject();
                        genericObject240.setObject((Object)exception);
                        frame.push(genericObject240);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject241 = new GenericObject();
                        genericObject241.setObject((Object)error);
                        frame.push(genericObject241);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1283965989: {
                    try {
                        GenericObject genericObject242 = frame.pop();
                        GenericObject genericObject243 = frame.pop();
                        GenericObject genericObject244 = new GenericObject();
                        genericObject244.setInt(genericObject243.getInt() - genericObject242.getInt());
                        frame.push(genericObject244);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject245 = new GenericObject();
                        genericObject245.setObject((Object)exception);
                        frame.push(genericObject245);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject246 = new GenericObject();
                        genericObject246.setObject((Object)error);
                        frame.push(genericObject246);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1200922173: {
                    try {
                        GenericObject genericObject247 = frame.pop();
                        int n11 = genericObject247.toInt();
                        if (n11 <= 0) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject248 = new GenericObject();
                        genericObject248.setObject((Object)exception);
                        frame.push(genericObject248);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject249 = new GenericObject();
                        genericObject249.setObject((Object)error);
                        frame.push(genericObject249);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -173422382: {
                    try {
                        GenericObject genericObject250 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject250);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject251 = new GenericObject();
                        genericObject251.setObject((Object)exception);
                        frame.push(genericObject251);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject252 = new GenericObject();
                        genericObject252.setObject((Object)error);
                        frame.push(genericObject252);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 937261038: {
                    try {
                        GenericObject genericObject253 = frame.pop();
                        GenericObject genericObject254 = new GenericObject();
                        genericObject254.setObject((Object)((OpenApiServiceImpl)genericObject253.getObject()).config);
                        frame.push(genericObject254);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject255 = new GenericObject();
                        genericObject255.setObject((Object)exception);
                        frame.push(genericObject255);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject256 = new GenericObject();
                        genericObject256.setObject((Object)error);
                        frame.push(genericObject256);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1998695396: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object26 = ((EntAppConfig)object).getUpdatasize();
                        GenericObject genericObject257 = new GenericObject();
                        genericObject257.setObject(object26);
                        frame.push(genericObject257);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject258 = new GenericObject();
                        genericObject258.setObject((Object)exception);
                        frame.push(genericObject258);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject259 = new GenericObject();
                        genericObject259.setObject((Object)error);
                        frame.push(genericObject259);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -625864557: {
                    try {
                        Object object = frame.pop().getObject();
                        int n12 = (Integer)object;
                        GenericObject genericObject260 = new GenericObject();
                        genericObject260.setInt(n12);
                        frame.push(genericObject260);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject261 = new GenericObject();
                        genericObject261.setObject((Object)exception);
                        frame.push(genericObject261);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject262 = new GenericObject();
                        genericObject262.setObject((Object)error);
                        frame.push(genericObject262);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 486183086: {
                    try {
                        int n13 = frame.pop().getInt();
                        int n14 = nArray[n + 1];
                        GenericObject genericObject263 = new GenericObject();
                        genericObject263.newarray(n13, n14);
                        frame.push(genericObject263);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject264 = new GenericObject();
                        genericObject264.setObject((Object)exception);
                        frame.push(genericObject264);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject265 = new GenericObject();
                        genericObject265.setObject((Object)error);
                        frame.push(genericObject265);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1440424357: {
                    try {
                        GenericObject genericObject266 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject266);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject267 = new GenericObject();
                        genericObject267.setObject((Object)exception);
                        frame.push(genericObject267);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject268 = new GenericObject();
                        genericObject268.setObject((Object)error);
                        frame.push(genericObject268);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1631633103: {
                    try {
                        GenericObject genericObject269 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject269);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject270 = new GenericObject();
                        genericObject270.setObject((Object)exception);
                        frame.push(genericObject270);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject271 = new GenericObject();
                        genericObject271.setObject((Object)error);
                        frame.push(genericObject271);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1138658369: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object27 = ((UploadFileIn)object).getFile();
                        GenericObject genericObject272 = new GenericObject();
                        genericObject272.setObject(object27);
                        frame.push(genericObject272);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject273 = new GenericObject();
                        genericObject273.setObject((Object)exception);
                        frame.push(genericObject273);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject274 = new GenericObject();
                        genericObject274.setObject((Object)error);
                        frame.push(genericObject274);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1083743912: {
                    try {
                        GenericObject genericObject275 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject275);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject276 = new GenericObject();
                        genericObject276.setObject((Object)exception);
                        frame.push(genericObject276);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject277 = new GenericObject();
                        genericObject277.setObject((Object)error);
                        frame.push(genericObject277);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1337709967: {
                    try {
                        GenericObject genericObject278 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject278);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject279 = new GenericObject();
                        genericObject279.setObject((Object)exception);
                        frame.push(genericObject279);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject280 = new GenericObject();
                        genericObject280.setObject((Object)error);
                        frame.push(genericObject280);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -221949851: {
                    try {
                        GenericObject genericObject281 = new GenericObject();
                        genericObject281.setInt(0);
                        frame.push(genericObject281);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject282 = new GenericObject();
                        genericObject282.setObject((Object)exception);
                        frame.push(genericObject282);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject283 = new GenericObject();
                        genericObject283.setObject((Object)error);
                        frame.push(genericObject283);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 141147230: {
                    try {
                        GenericObject genericObject284 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject284);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject285 = new GenericObject();
                        genericObject285.setObject((Object)exception);
                        frame.push(genericObject285);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject286 = new GenericObject();
                        genericObject286.setObject((Object)error);
                        frame.push(genericObject286);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1596019738: {
                    try {
                        GenericObject genericObject287 = frame.pop();
                        GenericObject genericObject288 = new GenericObject();
                        genericObject288.setObject((Object)((OpenApiServiceImpl)genericObject287.getObject()).config);
                        frame.push(genericObject288);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject289 = new GenericObject();
                        genericObject289.setObject((Object)exception);
                        frame.push(genericObject289);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject290 = new GenericObject();
                        genericObject290.setObject((Object)error);
                        frame.push(genericObject290);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1980180692: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object28 = ((EntAppConfig)object).getUpdatasize();
                        GenericObject genericObject291 = new GenericObject();
                        genericObject291.setObject(object28);
                        frame.push(genericObject291);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject292 = new GenericObject();
                        genericObject292.setObject((Object)exception);
                        frame.push(genericObject292);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject293 = new GenericObject();
                        genericObject293.setObject((Object)error);
                        frame.push(genericObject293);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 770859577: {
                    try {
                        Object object = frame.pop().getObject();
                        int n15 = (Integer)object;
                        GenericObject genericObject294 = new GenericObject();
                        genericObject294.setInt(n15);
                        frame.push(genericObject294);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject295 = new GenericObject();
                        genericObject295.setObject((Object)exception);
                        frame.push(genericObject295);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject296 = new GenericObject();
                        genericObject296.setObject((Object)error);
                        frame.push(genericObject296);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -604594487: {
                    try {
                        int n16 = frame.pop().getInt();
                        int n17 = frame.pop().getInt();
                        Object object = frame.pop().getObject();
                        int n18 = frame.pop().getInt();
                        Object object29 = frame.pop().getObject();
                        System.arraycopy(object29, n18, object, n17, n16);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject297 = new GenericObject();
                        genericObject297.setObject((Object)exception);
                        frame.push(genericObject297);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject298 = new GenericObject();
                        genericObject298.setObject((Object)error);
                        frame.push(genericObject298);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1195740558: {
                    try {
                        GenericObject genericObject299 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject299);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject300 = new GenericObject();
                        genericObject300.setObject((Object)exception);
                        frame.push(genericObject300);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject301 = new GenericObject();
                        genericObject301.setObject((Object)error);
                        frame.push(genericObject301);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 892594364: {
                    try {
                        GenericObject genericObject302 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject302);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject303 = new GenericObject();
                        genericObject303.setObject((Object)exception);
                        frame.push(genericObject303);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject304 = new GenericObject();
                        genericObject304.setObject((Object)error);
                        frame.push(genericObject304);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1693168943: {
                    try {
                        GenericObject genericObject305 = frame.pop();
                        GenericObject genericObject306 = new GenericObject();
                        genericObject306.setObject((Object)((OpenApiServiceImpl)genericObject305.getObject()).config);
                        frame.push(genericObject306);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject307 = new GenericObject();
                        genericObject307.setObject((Object)exception);
                        frame.push(genericObject307);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject308 = new GenericObject();
                        genericObject308.setObject((Object)error);
                        frame.push(genericObject308);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -435865162: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object30 = ((EntAppConfig)object).getUpdatasize();
                        GenericObject genericObject309 = new GenericObject();
                        genericObject309.setObject(object30);
                        frame.push(genericObject309);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject310 = new GenericObject();
                        genericObject310.setObject((Object)exception);
                        frame.push(genericObject310);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject311 = new GenericObject();
                        genericObject311.setObject((Object)error);
                        frame.push(genericObject311);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1782345660: {
                    try {
                        Object object = frame.pop().getObject();
                        int n19 = (Integer)object;
                        GenericObject genericObject312 = new GenericObject();
                        genericObject312.setInt(n19);
                        frame.push(genericObject312);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject313 = new GenericObject();
                        genericObject313.setObject((Object)exception);
                        frame.push(genericObject313);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject314 = new GenericObject();
                        genericObject314.setObject((Object)error);
                        frame.push(genericObject314);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 910764770: {
                    try {
                        GenericObject genericObject315 = frame.pop();
                        GenericObject genericObject316 = frame.pop();
                        GenericObject genericObject317 = new GenericObject();
                        genericObject317.setInt(genericObject316.getInt() - genericObject315.getInt());
                        frame.push(genericObject317);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject318 = new GenericObject();
                        genericObject318.setObject((Object)exception);
                        frame.push(genericObject318);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject319 = new GenericObject();
                        genericObject319.setObject((Object)error);
                        frame.push(genericObject319);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -240097583: {
                    try {
                        int n20 = frame.pop().toInt();
                        GenericObject genericObject320 = new GenericObject();
                        genericObject320.setInt(n20);
                        frame.setLocal(nArray[n + 1], genericObject320);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject321 = new GenericObject();
                        genericObject321.setObject((Object)exception);
                        frame.push(genericObject321);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject322 = new GenericObject();
                        genericObject322.setObject((Object)error);
                        frame.push(genericObject322);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -800531835: {
                    try {
                        GenericObject genericObject323 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject323);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject324 = new GenericObject();
                        genericObject324.setObject((Object)exception);
                        frame.push(genericObject324);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject325 = new GenericObject();
                        genericObject325.setObject((Object)error);
                        frame.push(genericObject325);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1170704369: {
                    try {
                        GenericObject genericObject326 = frame.pop();
                        GenericObject genericObject327 = new GenericObject();
                        genericObject327.setObject((Object)((OpenApiServiceImpl)genericObject326.getObject()).config);
                        frame.push(genericObject327);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject328 = new GenericObject();
                        genericObject328.setObject((Object)exception);
                        frame.push(genericObject328);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject329 = new GenericObject();
                        genericObject329.setObject((Object)error);
                        frame.push(genericObject329);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 475572177: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object31 = ((EntAppConfig)object).getUpdatasize();
                        GenericObject genericObject330 = new GenericObject();
                        genericObject330.setObject(object31);
                        frame.push(genericObject330);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject331 = new GenericObject();
                        genericObject331.setObject((Object)exception);
                        frame.push(genericObject331);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject332 = new GenericObject();
                        genericObject332.setObject((Object)error);
                        frame.push(genericObject332);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 899430489: {
                    try {
                        Object object = frame.pop().getObject();
                        int n21 = (Integer)object;
                        GenericObject genericObject333 = new GenericObject();
                        genericObject333.setInt(n21);
                        frame.push(genericObject333);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject334 = new GenericObject();
                        genericObject334.setObject((Object)exception);
                        frame.push(genericObject334);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject335 = new GenericObject();
                        genericObject335.setObject((Object)error);
                        frame.push(genericObject335);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 271004378: {
                    try {
                        GenericObject genericObject336 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject336);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject337 = new GenericObject();
                        genericObject337.setObject((Object)exception);
                        frame.push(genericObject337);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject338 = new GenericObject();
                        genericObject338.setObject((Object)error);
                        frame.push(genericObject338);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1399756742: {
                    try {
                        GenericObject genericObject339 = frame.pop();
                        GenericObject genericObject340 = frame.pop();
                        GenericObject genericObject341 = new GenericObject();
                        genericObject341.setInt(genericObject340.getInt() + genericObject339.getInt());
                        frame.push(genericObject341);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject342 = new GenericObject();
                        genericObject342.setObject((Object)exception);
                        frame.push(genericObject342);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject343 = new GenericObject();
                        genericObject343.setObject((Object)error);
                        frame.push(genericObject343);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1947211010: {
                    try {
                        int n22 = frame.pop().toInt();
                        GenericObject genericObject344 = new GenericObject();
                        genericObject344.setInt(n22);
                        frame.setLocal(nArray[n + 1], genericObject344);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject345 = new GenericObject();
                        genericObject345.setObject((Object)exception);
                        frame.push(genericObject345);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject346 = new GenericObject();
                        genericObject346.setObject((Object)error);
                        frame.push(genericObject346);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 459053226: {
                    try {
                        n = nArray[n + 1];
                    }
                    catch (Exception exception) {
                        GenericObject genericObject347 = new GenericObject();
                        genericObject347.setObject((Object)exception);
                        frame.push(genericObject347);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject348 = new GenericObject();
                        genericObject348.setObject((Object)error);
                        frame.push(genericObject348);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 621400939: {
                    try {
                        GenericObject genericObject349 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject349);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject350 = new GenericObject();
                        genericObject350.setObject((Object)exception);
                        frame.push(genericObject350);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject351 = new GenericObject();
                        genericObject351.setObject((Object)error);
                        frame.push(genericObject351);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -838863232: {
                    try {
                        int n23 = frame.pop().getInt();
                        int n24 = nArray[n + 1];
                        GenericObject genericObject352 = new GenericObject();
                        genericObject352.newarray(n23, n24);
                        frame.push(genericObject352);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject353 = new GenericObject();
                        genericObject353.setObject((Object)exception);
                        frame.push(genericObject353);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject354 = new GenericObject();
                        genericObject354.setObject((Object)error);
                        frame.push(genericObject354);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1520272351: {
                    try {
                        GenericObject genericObject355 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject355);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject356 = new GenericObject();
                        genericObject356.setObject((Object)exception);
                        frame.push(genericObject356);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject357 = new GenericObject();
                        genericObject357.setObject((Object)error);
                        frame.push(genericObject357);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -904667121: {
                    try {
                        GenericObject genericObject358 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject358);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject359 = new GenericObject();
                        genericObject359.setObject((Object)exception);
                        frame.push(genericObject359);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject360 = new GenericObject();
                        genericObject360.setObject((Object)error);
                        frame.push(genericObject360);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1597243366: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object32 = ((UploadFileIn)object).getFile();
                        GenericObject genericObject361 = new GenericObject();
                        genericObject361.setObject(object32);
                        frame.push(genericObject361);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject362 = new GenericObject();
                        genericObject362.setObject((Object)exception);
                        frame.push(genericObject362);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject363 = new GenericObject();
                        genericObject363.setObject((Object)error);
                        frame.push(genericObject363);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -173395219: {
                    try {
                        GenericObject genericObject364 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject364);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject365 = new GenericObject();
                        genericObject365.setObject((Object)exception);
                        frame.push(genericObject365);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject366 = new GenericObject();
                        genericObject366.setObject((Object)error);
                        frame.push(genericObject366);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1247608647: {
                    try {
                        GenericObject genericObject367 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject367);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject368 = new GenericObject();
                        genericObject368.setObject((Object)exception);
                        frame.push(genericObject368);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject369 = new GenericObject();
                        genericObject369.setObject((Object)error);
                        frame.push(genericObject369);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -196073478: {
                    try {
                        GenericObject genericObject370 = new GenericObject();
                        genericObject370.setInt(0);
                        frame.push(genericObject370);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject371 = new GenericObject();
                        genericObject371.setObject((Object)exception);
                        frame.push(genericObject371);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject372 = new GenericObject();
                        genericObject372.setObject((Object)error);
                        frame.push(genericObject372);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 942223685: {
                    try {
                        GenericObject genericObject373 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject373);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject374 = new GenericObject();
                        genericObject374.setObject((Object)exception);
                        frame.push(genericObject374);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject375 = new GenericObject();
                        genericObject375.setObject((Object)error);
                        frame.push(genericObject375);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1808679762: {
                    try {
                        int n25 = frame.pop().getInt();
                        int n26 = frame.pop().getInt();
                        Object object = frame.pop().getObject();
                        int n27 = frame.pop().getInt();
                        Object object33 = frame.pop().getObject();
                        System.arraycopy(object33, n27, object, n26, n25);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject376 = new GenericObject();
                        genericObject376.setObject((Object)exception);
                        frame.push(genericObject376);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject377 = new GenericObject();
                        genericObject377.setObject((Object)error);
                        frame.push(genericObject377);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -855167890: {
                    try {
                        GenericObject genericObject378 = new GenericObject();
                        genericObject378.setInt(-1);
                        frame.push(genericObject378);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject379 = new GenericObject();
                        genericObject379.setObject((Object)exception);
                        frame.push(genericObject379);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject380 = new GenericObject();
                        genericObject380.setObject((Object)error);
                        frame.push(genericObject380);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 578358124: {
                    try {
                        int n28 = frame.pop().toInt();
                        GenericObject genericObject381 = new GenericObject();
                        genericObject381.setInt(n28);
                        frame.setLocal(nArray[n + 1], genericObject381);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject382 = new GenericObject();
                        genericObject382.setObject((Object)exception);
                        frame.push(genericObject382);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject383 = new GenericObject();
                        genericObject383.setObject((Object)error);
                        frame.push(genericObject383);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 578934365: {
                    try {
                        GenericObject genericObject384 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject384);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject385 = new GenericObject();
                        genericObject385.setObject((Object)exception);
                        frame.push(genericObject385);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject386 = new GenericObject();
                        genericObject386.setObject((Object)error);
                        frame.push(genericObject386);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1123595581: {
                    try {
                        GenericObject genericObject387 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject387);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject388 = new GenericObject();
                        genericObject388.setObject((Object)exception);
                        frame.push(genericObject388);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject389 = new GenericObject();
                        genericObject389.setObject((Object)error);
                        frame.push(genericObject389);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1714459681: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object34 = frame.pop().getObject();
                        ((UploadRequest)object34).setFile((byte[])object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject390 = new GenericObject();
                        genericObject390.setObject((Object)exception);
                        frame.push(genericObject390);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject391 = new GenericObject();
                        genericObject391.setObject((Object)error);
                        frame.push(genericObject391);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -340883046: {
                    try {
                        GenericObject genericObject392 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject392);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject393 = new GenericObject();
                        genericObject393.setObject((Object)exception);
                        frame.push(genericObject393);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject394 = new GenericObject();
                        genericObject394.setObject((Object)error);
                        frame.push(genericObject394);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1215222347: {
                    try {
                        GenericObject genericObject395 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject395);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject396 = new GenericObject();
                        genericObject396.setObject((Object)exception);
                        frame.push(genericObject396);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject397 = new GenericObject();
                        genericObject397.setObject((Object)error);
                        frame.push(genericObject397);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1060877007: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object35 = frame.pop().getObject();
                        Object object36 = ((OpenApiServiceImpl)object35).fileUpload((UploadRequest)object);
                        GenericObject genericObject398 = new GenericObject();
                        genericObject398.setObject(object36);
                        frame.push(genericObject398);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject399 = new GenericObject();
                        genericObject399.setObject((Object)exception);
                        frame.push(genericObject399);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject400 = new GenericObject();
                        genericObject400.setObject((Object)error);
                        frame.push(genericObject400);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -420178061: {
                    try {
                        GenericObject genericObject401 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject401);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject402 = new GenericObject();
                        genericObject402.setObject((Object)exception);
                        frame.push(genericObject402);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject403 = new GenericObject();
                        genericObject403.setObject((Object)error);
                        frame.push(genericObject403);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1562317107: {
                    try {
                        GenericObject genericObject404 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject404);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject405 = new GenericObject();
                        genericObject405.setObject((Object)exception);
                        frame.push(genericObject405);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject406 = new GenericObject();
                        genericObject406.setObject((Object)error);
                        frame.push(genericObject406);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 134759836: {
                    try {
                        GenericObject genericObject407 = frame.pop();
                        if (genericObject407.getObject() == null) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject408 = new GenericObject();
                        genericObject408.setObject((Object)exception);
                        frame.push(genericObject408);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject409 = new GenericObject();
                        genericObject409.setObject((Object)error);
                        frame.push(genericObject409);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -2061225535: {
                    try {
                        GenericObject genericObject410 = new GenericObject();
                        genericObject410.setObject((Object)ErrorCode.E0000);
                        frame.push(genericObject410);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject411 = new GenericObject();
                        genericObject411.setObject((Object)exception);
                        frame.push(genericObject411);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject412 = new GenericObject();
                        genericObject412.setObject((Object)error);
                        frame.push(genericObject412);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -707223247: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object37 = ((ErrorCode)((Object)object)).getCode();
                        GenericObject genericObject413 = new GenericObject();
                        genericObject413.setObject(object37);
                        frame.push(genericObject413);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject414 = new GenericObject();
                        genericObject414.setObject((Object)exception);
                        frame.push(genericObject414);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject415 = new GenericObject();
                        genericObject415.setObject((Object)error);
                        frame.push(genericObject415);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1207703671: {
                    try {
                        GenericObject genericObject416 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject416);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject417 = new GenericObject();
                        genericObject417.setObject((Object)exception);
                        frame.push(genericObject417);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject418 = new GenericObject();
                        genericObject418.setObject((Object)error);
                        frame.push(genericObject418);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 11500205: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object38 = ((UploadFileOut)object).getResultcode();
                        GenericObject genericObject419 = new GenericObject();
                        genericObject419.setObject(object38);
                        frame.push(genericObject419);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject420 = new GenericObject();
                        genericObject420.setObject((Object)exception);
                        frame.push(genericObject420);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject421 = new GenericObject();
                        genericObject421.setObject((Object)error);
                        frame.push(genericObject421);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 447008390: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object39 = frame.pop().getObject();
                        boolean bl = ((String)object39).equals(object);
                        GenericObject genericObject422 = new GenericObject();
                        genericObject422.setBoolean(bl);
                        frame.push(genericObject422);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject423 = new GenericObject();
                        genericObject423.setObject((Object)exception);
                        frame.push(genericObject423);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject424 = new GenericObject();
                        genericObject424.setObject((Object)error);
                        frame.push(genericObject424);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1778893222: {
                    try {
                        GenericObject genericObject425 = frame.pop();
                        int n29 = genericObject425.toInt();
                        if (n29 == 0) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject426 = new GenericObject();
                        genericObject426.setObject((Object)exception);
                        frame.push(genericObject426);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject427 = new GenericObject();
                        genericObject427.setObject((Object)error);
                        frame.push(genericObject427);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 649929201: {
                    try {
                        GenericObject genericObject428 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject428);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject429 = new GenericObject();
                        genericObject429.setObject((Object)exception);
                        frame.push(genericObject429);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject430 = new GenericObject();
                        genericObject430.setObject((Object)error);
                        frame.push(genericObject430);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -269416604: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object40 = ((UploadFileOut)object).getFileid();
                        GenericObject genericObject431 = new GenericObject();
                        genericObject431.setObject(object40);
                        frame.push(genericObject431);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject432 = new GenericObject();
                        genericObject432.setObject((Object)exception);
                        frame.push(genericObject432);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject433 = new GenericObject();
                        genericObject433.setObject((Object)error);
                        frame.push(genericObject433);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 742221700: {
                    try {
                        GenericObject genericObject434 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject434);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject435 = new GenericObject();
                        genericObject435.setObject((Object)exception);
                        frame.push(genericObject435);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject436 = new GenericObject();
                        genericObject436.setObject((Object)error);
                        frame.push(genericObject436);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 2113259983: {
                    try {
                        n = nArray[n + 1];
                    }
                    catch (Exception exception) {
                        GenericObject genericObject437 = new GenericObject();
                        genericObject437.setObject((Object)exception);
                        frame.push(genericObject437);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject438 = new GenericObject();
                        genericObject438.setObject((Object)error);
                        frame.push(genericObject438);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -686743191: {
                    try {
                        GenericObject genericObject439 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject439);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject440 = new GenericObject();
                        genericObject440.setObject((Object)exception);
                        frame.push(genericObject440);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject441 = new GenericObject();
                        genericObject441.setObject((Object)error);
                        frame.push(genericObject441);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1220835573: {
                    try {
                        GenericObject genericObject442 = frame.pop();
                        if (genericObject442.getObject() == null) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject443 = new GenericObject();
                        genericObject443.setObject((Object)exception);
                        frame.push(genericObject443);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject444 = new GenericObject();
                        genericObject444.setObject((Object)error);
                        frame.push(genericObject444);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1711845526: {
                    try {
                        GenericObject genericObject445 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject445);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject446 = new GenericObject();
                        genericObject446.setObject((Object)exception);
                        frame.push(genericObject446);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject447 = new GenericObject();
                        genericObject447.setObject((Object)error);
                        frame.push(genericObject447);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -593649850: {
                    try {
                        return (UploadFileOut)frame.pop().getObject();
                    }
                    catch (Exception exception) {
                        GenericObject genericObject448 = new GenericObject();
                        genericObject448.setObject((Object)exception);
                        frame.push(genericObject448);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject449 = new GenericObject();
                        genericObject449.setObject((Object)error);
                        frame.push(genericObject449);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                }
                case -946395011: {
                    try {
                        GenericObject genericObject450 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject450);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject451 = new GenericObject();
                        genericObject451.setObject((Object)exception);
                        frame.push(genericObject451);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject452 = new GenericObject();
                        genericObject452.setObject((Object)error);
                        frame.push(genericObject452);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1793319592: {
                    try {
                        GenericObject genericObject453 = frame.pop();
                        int n30 = genericObject453.toInt();
                        if (n30 > 0) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject454 = new GenericObject();
                        genericObject454.setObject((Object)exception);
                        frame.push(genericObject454);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject455 = new GenericObject();
                        genericObject455.setObject((Object)error);
                        frame.push(genericObject455);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -723796455: {
                    try {
                        n = nArray[n + 1];
                    }
                    catch (Exception exception) {
                        GenericObject genericObject456 = new GenericObject();
                        genericObject456.setObject((Object)exception);
                        frame.push(genericObject456);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject457 = new GenericObject();
                        genericObject457.setObject((Object)error);
                        frame.push(genericObject457);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 93653380: {
                    try {
                        GenericObject genericObject458 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject458);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject459 = new GenericObject();
                        genericObject459.setObject((Object)exception);
                        frame.push(genericObject459);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject460 = new GenericObject();
                        genericObject460.setObject((Object)error);
                        frame.push(genericObject460);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1307008256: {
                    try {
                        GenericObject genericObject461 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject461);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject462 = new GenericObject();
                        genericObject462.setObject((Object)exception);
                        frame.push(genericObject462);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject463 = new GenericObject();
                        genericObject463.setObject((Object)error);
                        frame.push(genericObject463);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1651687080: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object41 = ((UploadFileIn)object).getFileid();
                        GenericObject genericObject464 = new GenericObject();
                        genericObject464.setObject(object41);
                        frame.push(genericObject464);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject465 = new GenericObject();
                        genericObject465.setObject((Object)exception);
                        frame.push(genericObject465);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject466 = new GenericObject();
                        genericObject466.setObject((Object)error);
                        frame.push(genericObject466);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1997146978: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object42 = frame.pop().getObject();
                        ((UploadRequest)object42).setFileid((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject467 = new GenericObject();
                        genericObject467.setObject((Object)exception);
                        frame.push(genericObject467);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject468 = new GenericObject();
                        genericObject468.setObject((Object)error);
                        frame.push(genericObject468);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 810377163: {
                    try {
                        GenericObject genericObject469 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject469);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject470 = new GenericObject();
                        genericObject470.setObject((Object)exception);
                        frame.push(genericObject470);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject471 = new GenericObject();
                        genericObject471.setObject((Object)error);
                        frame.push(genericObject471);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 797215352: {
                    try {
                        GenericObject genericObject472 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject472);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject473 = new GenericObject();
                        genericObject473.setObject((Object)exception);
                        frame.push(genericObject473);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject474 = new GenericObject();
                        genericObject474.setObject((Object)error);
                        frame.push(genericObject474);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -836157523: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object43 = ((UploadFileIn)object).getOffSett();
                        GenericObject genericObject475 = new GenericObject();
                        genericObject475.setObject(object43);
                        frame.push(genericObject475);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject476 = new GenericObject();
                        genericObject476.setObject((Object)exception);
                        frame.push(genericObject476);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject477 = new GenericObject();
                        genericObject477.setObject((Object)error);
                        frame.push(genericObject477);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -760196589: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object44 = frame.pop().getObject();
                        ((UploadRequest)object44).setOffset((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject478 = new GenericObject();
                        genericObject478.setObject((Object)exception);
                        frame.push(genericObject478);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject479 = new GenericObject();
                        genericObject479.setObject((Object)error);
                        frame.push(genericObject479);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 2047280784: {
                    try {
                        GenericObject genericObject480 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject480);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject481 = new GenericObject();
                        genericObject481.setObject((Object)exception);
                        frame.push(genericObject481);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject482 = new GenericObject();
                        genericObject482.setObject((Object)error);
                        frame.push(genericObject482);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -306895175: {
                    try {
                        GenericObject genericObject483 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject483);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject484 = new GenericObject();
                        genericObject484.setObject((Object)exception);
                        frame.push(genericObject484);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject485 = new GenericObject();
                        genericObject485.setObject((Object)error);
                        frame.push(genericObject485);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1246293431: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object45 = ((UploadFileIn)object).getFile();
                        GenericObject genericObject486 = new GenericObject();
                        genericObject486.setObject(object45);
                        frame.push(genericObject486);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject487 = new GenericObject();
                        genericObject487.setObject((Object)exception);
                        frame.push(genericObject487);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject488 = new GenericObject();
                        genericObject488.setObject((Object)error);
                        frame.push(genericObject488);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1782792396: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object46 = frame.pop().getObject();
                        ((UploadRequest)object46).setFile((byte[])object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject489 = new GenericObject();
                        genericObject489.setObject((Object)exception);
                        frame.push(genericObject489);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject490 = new GenericObject();
                        genericObject490.setObject((Object)error);
                        frame.push(genericObject490);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -264812687: {
                    try {
                        GenericObject genericObject491 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject491);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject492 = new GenericObject();
                        genericObject492.setObject((Object)exception);
                        frame.push(genericObject492);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject493 = new GenericObject();
                        genericObject493.setObject((Object)error);
                        frame.push(genericObject493);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1607826639: {
                    try {
                        GenericObject genericObject494 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject494);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject495 = new GenericObject();
                        genericObject495.setObject((Object)exception);
                        frame.push(genericObject495);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject496 = new GenericObject();
                        genericObject496.setObject((Object)error);
                        frame.push(genericObject496);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1731763117: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object47 = frame.pop().getObject();
                        Object object48 = ((OpenApiServiceImpl)object47).fileUpload((UploadRequest)object);
                        GenericObject genericObject497 = new GenericObject();
                        genericObject497.setObject(object48);
                        frame.push(genericObject497);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject498 = new GenericObject();
                        genericObject498.setObject((Object)exception);
                        frame.push(genericObject498);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject499 = new GenericObject();
                        genericObject499.setObject((Object)error);
                        frame.push(genericObject499);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1329720946: {
                    try {
                        GenericObject genericObject500 = frame.pop();
                        frame.setLocal(nArray[n + 1], genericObject500);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject501 = new GenericObject();
                        genericObject501.setObject((Object)exception);
                        frame.push(genericObject501);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject502 = new GenericObject();
                        genericObject502.setObject((Object)error);
                        frame.push(genericObject502);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1772145563: {
                    try {
                        GenericObject genericObject503 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject503);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject504 = new GenericObject();
                        genericObject504.setObject((Object)exception);
                        frame.push(genericObject504);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject505 = new GenericObject();
                        genericObject505.setObject((Object)error);
                        frame.push(genericObject505);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -874044895: {
                    try {
                        GenericObject genericObject506 = frame.pop();
                        if (genericObject506.getObject() == null) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject507 = new GenericObject();
                        genericObject507.setObject((Object)exception);
                        frame.push(genericObject507);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject508 = new GenericObject();
                        genericObject508.setObject((Object)error);
                        frame.push(genericObject508);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1631574628: {
                    try {
                        GenericObject genericObject509 = new GenericObject();
                        genericObject509.setObject((Object)ErrorCode.E0000);
                        frame.push(genericObject509);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject510 = new GenericObject();
                        genericObject510.setObject((Object)exception);
                        frame.push(genericObject510);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject511 = new GenericObject();
                        genericObject511.setObject((Object)error);
                        frame.push(genericObject511);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1104022892: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object49 = ((ErrorCode)((Object)object)).getCode();
                        GenericObject genericObject512 = new GenericObject();
                        genericObject512.setObject(object49);
                        frame.push(genericObject512);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject513 = new GenericObject();
                        genericObject513.setObject((Object)exception);
                        frame.push(genericObject513);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject514 = new GenericObject();
                        genericObject514.setObject((Object)error);
                        frame.push(genericObject514);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1064236492: {
                    try {
                        GenericObject genericObject515 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject515);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject516 = new GenericObject();
                        genericObject516.setObject((Object)exception);
                        frame.push(genericObject516);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject517 = new GenericObject();
                        genericObject517.setObject((Object)error);
                        frame.push(genericObject517);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1564468782: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object50 = ((UploadFileOut)object).getResultcode();
                        GenericObject genericObject518 = new GenericObject();
                        genericObject518.setObject(object50);
                        frame.push(genericObject518);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject519 = new GenericObject();
                        genericObject519.setObject((Object)exception);
                        frame.push(genericObject519);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject520 = new GenericObject();
                        genericObject520.setObject((Object)error);
                        frame.push(genericObject520);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -225123788: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object51 = frame.pop().getObject();
                        boolean bl = ((String)object51).equals(object);
                        GenericObject genericObject521 = new GenericObject();
                        genericObject521.setBoolean(bl);
                        frame.push(genericObject521);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject522 = new GenericObject();
                        genericObject522.setObject((Object)exception);
                        frame.push(genericObject522);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject523 = new GenericObject();
                        genericObject523.setObject((Object)error);
                        frame.push(genericObject523);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 818473125: {
                    try {
                        GenericObject genericObject524 = frame.pop();
                        int n31 = genericObject524.toInt();
                        if (n31 == 0) {
                            n = nArray[n + 1];
                            break;
                        }
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject525 = new GenericObject();
                        genericObject525.setObject((Object)exception);
                        frame.push(genericObject525);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject526 = new GenericObject();
                        genericObject526.setObject((Object)error);
                        frame.push(genericObject526);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1841612330: {
                    try {
                        GenericObject genericObject527 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject527);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject528 = new GenericObject();
                        genericObject528.setObject((Object)exception);
                        frame.push(genericObject528);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject529 = new GenericObject();
                        genericObject529.setObject((Object)error);
                        frame.push(genericObject529);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 243157610: {
                    try {
                        GenericObject genericObject530 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject530);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject531 = new GenericObject();
                        genericObject531.setObject((Object)exception);
                        frame.push(genericObject531);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject532 = new GenericObject();
                        genericObject532.setObject((Object)error);
                        frame.push(genericObject532);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 1634140617: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object52 = ((UploadFileIn)object).getFilename();
                        GenericObject genericObject533 = new GenericObject();
                        genericObject533.setObject(object52);
                        frame.push(genericObject533);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject534 = new GenericObject();
                        genericObject534.setObject((Object)exception);
                        frame.push(genericObject534);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject535 = new GenericObject();
                        genericObject535.setObject((Object)error);
                        frame.push(genericObject535);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1933511976: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object53 = frame.pop().getObject();
                        ((UploadFileOut)object53).setFilename((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject536 = new GenericObject();
                        genericObject536.setObject((Object)exception);
                        frame.push(genericObject536);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject537 = new GenericObject();
                        genericObject537.setObject((Object)error);
                        frame.push(genericObject537);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 301196039: {
                    try {
                        GenericObject genericObject538 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject538);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject539 = new GenericObject();
                        genericObject539.setObject((Object)exception);
                        frame.push(genericObject539);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject540 = new GenericObject();
                        genericObject540.setObject((Object)error);
                        frame.push(genericObject540);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1257625163: {
                    try {
                        GenericObject genericObject541 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject541);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject542 = new GenericObject();
                        genericObject542.setObject((Object)exception);
                        frame.push(genericObject542);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject543 = new GenericObject();
                        genericObject543.setObject((Object)error);
                        frame.push(genericObject543);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -434067914: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object54 = ((UploadFileIn)object).getTraceno();
                        GenericObject genericObject544 = new GenericObject();
                        genericObject544.setObject(object54);
                        frame.push(genericObject544);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject545 = new GenericObject();
                        genericObject545.setObject((Object)exception);
                        frame.push(genericObject545);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject546 = new GenericObject();
                        genericObject546.setObject((Object)error);
                        frame.push(genericObject546);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 869137913: {
                    try {
                        Object object = frame.pop().getObject();
                        Object object55 = frame.pop().getObject();
                        ((UploadFileOut)object55).setResourceId((String)object);
                        ++n;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject547 = new GenericObject();
                        genericObject547.setObject((Object)exception);
                        frame.push(genericObject547);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject548 = new GenericObject();
                        genericObject548.setObject((Object)error);
                        frame.push(genericObject548);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case 855601465: {
                    try {
                        GenericObject genericObject549 = frame.getLocal(nArray[n + 1]);
                        frame.push(genericObject549);
                        n += 2;
                    }
                    catch (Exception exception) {
                        GenericObject genericObject550 = new GenericObject();
                        genericObject550.setObject((Object)exception);
                        frame.push(genericObject550);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject551 = new GenericObject();
                        genericObject551.setObject((Object)error);
                        frame.push(genericObject551);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                    continue block761;
                }
                case -1480736021: {
                    try {
                        return (UploadFileOut)frame.pop().getObject();
                    }
                    catch (Exception exception) {
                        GenericObject genericObject552 = new GenericObject();
                        genericObject552.setObject((Object)exception);
                        frame.push(genericObject552);
                        frame.setExpPc(n);
                        frame.setEx((Throwable)exception);
                        n = 298;
                    }
                    catch (Error error) {
                        GenericObject genericObject553 = new GenericObject();
                        genericObject553.setObject((Object)error);
                        frame.push(genericObject553);
                        frame.setExpPc(n);
                        frame.setError(error);
                        n = 298;
                    }
                }
                case -1506193329: {
                    GenericObject genericObject554 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject554);
                    n += 2;
                    break;
                }
                case 1112296205: {
                    GenericObject genericObject555 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject555);
                    n += 2;
                    break;
                }
                case -1948058036: {
                    GenericObject genericObject556 = frame.pop();
                    frame.empty();
                    frame.push(genericObject556);
                    genericObject556.throwException();
                    ++n;
                    break;
                }
                case 317946640: {
                    GenericObject genericObject557 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject557);
                    n += 2;
                    break;
                }
                case 2090928951: {
                    StubObject stubObject = new StubObject("com.czb.sap.sdk.exception.SdkException");
                    GenericObject genericObject558 = new GenericObject();
                    genericObject558.setObject((Object)stubObject);
                    frame.push(genericObject558);
                    ++n;
                    break;
                }
                case -1651048655: {
                    GenericObject genericObject559 = frame.peek();
                    frame.push(genericObject559);
                    ++n;
                    break;
                }
                case -85327967: {
                    GenericObject genericObject560 = new GenericObject();
                    genericObject560.setObject((Object)ErrorCode.E0014);
                    frame.push(genericObject560);
                    ++n;
                    break;
                }
                case 512898973: {
                    GenericObject genericObject561 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject561);
                    n += 2;
                    break;
                }
                case 1465137207: {
                    Object object = frame.pop().getObject();
                    Object object56 = frame.pop().getObject();
                    SdkException sdkException = new SdkException((ErrorCode)((Object)object56), (Throwable)object);
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject562 = new GenericObject();
                    genericObject562.setObject((Object)sdkException);
                    frame.push(genericObject562);
                    ++n;
                    break;
                }
                case 1418093792: {
                    GenericObject genericObject563 = frame.pop();
                    frame.empty();
                    frame.push(genericObject563);
                    genericObject563.throwException();
                    ++n;
                    break;
                }
                case 683979869: {
                    int n32;
                    Exp[] expArray = new Exp[]{new Exp(0, 225, 284), new Exp(226, 283, 284), new Exp(0, 225, 289), new Exp(226, 283, 289)};
                    Throwable throwable = frame.getEx();
                    int[] nArray2 = new int[4];
                    for (int i = 0; i < 4; ++i) {
                        nArray2[i] = 0;
                    }
                    if (throwable instanceof SdkException) {
                        nArray2[0] = 1;
                    }
                    if (throwable instanceof SdkException) {
                        nArray2[1] = 1;
                    }
                    if (throwable instanceof Exception) {
                        nArray2[2] = 1;
                    }
                    if (throwable instanceof Exception) {
                        nArray2[3] = 1;
                    }
                    if ((n32 = frame.findCatchBlock(expArray, nArray2)) != -1) {
                        n = expArray[n32].handlerPc;
                        break;
                    }
                    if (throwable instanceof Exception) {
                        frame.throwException();
                        break;
                    }
                    frame.throwError();
                    break;
                }
            }
        }
    }

    private UploadFileOut fileUpload(UploadRequest request) {
        request.setAppid(this.config.getAppid());
        request.setOpenid(this.config.getOpenid());
        request.setSendtime(DateUtil.getSendTime());
        request.setTermianatype(TermianaType.SDK.getCode());
        request.setFileabstract("fileabstract");
        String signResource = request.signResource();
        String sign = this.securityService.signature(signResource, this.config.getAppkey());
        request.setSign(sign);
        if (this.config.getCfcafile() != null && this.config.getCfcafile().length > 1) {
            String cfcaSign = this.securityService.cfcaSignature(signResource, this.config.getCfcapwd(), this.config.getCfcafile());
            request.setCfcasign(cfcaSign);
        }
        URI url = URI.create(String.valueOf(this.config.getFileurl()) + "filev2/upload");
        log.debug("\u8bf7\u6c42\u5730\u5740:[{}],\u62a5\u6587[{}]", (Object)url.toASCIIString(), (Object)JSON.toJSONString((Object)request));
        String response = HttpClientUtil.sendPostFile(request, url, this.config);
        UploadFileOut out = (UploadFileOut)JSON.parseObject((String)response, UploadFileOut.class);
        if (out != null && ErrorCode.E0000.getCode().equals(out.getResultcode())) {
            this.checkUploadSign(out);
        }
        if (out != null && "840010".equals(out.getResultcode())) {
            String token = SdkCache.getInstance().removeValue(String.valueOf(this.appName) + "token");
            log.warn("remove  token  [{}]", (Object)token);
            SdkCache.getInstance().removeValue(String.valueOf(this.appName) + "tokentimeout");
        }
        return out;
    }

    private void checkUploadSign(UploadFileOut out) {
        String hsign = this.securityService.signature(out.signResource(), this.config.getAppkey());
        if (!StringUtils.equals(hsign, out.getSign())) {
            log.error("\u672c\u5730\u7b7e\u540d[{}],\u8fd4\u56de\u7b7e\u540d[{}]\uff0c\u8fd4\u56de\u62a5\u6587[{}]", new Object[]{hsign, out.getSign(), JSON.toJSONString((Object)out)});
            throw new SdkException(ErrorCode.E0010);
        }
    }

    @Override
    public DownloadFileOut downloadFile(DownloadFileIn in) throws SdkException {
        DownloadReqeust request = new DownloadReqeust();
        request.setAppid(this.config.getAppid());
        request.setOpenid(this.config.getOpenid());
        request.setSendtime(DateUtil.getSendTime());
        request.setTermianatype(TermianaType.SDK.getCode());
        request.setFileid(in.getFileid());
        if (StringUtils.isNotBlank(in.getToken())) {
            request.setToken(in.getToken());
        } else {
            request.setToken(this.getCacheToken());
        }
        request.setTraceno(in.getTraceno());
        String signResource = request.signResource();
        log.debug("\u5f3a\u6c42\u7b7e\u540d\u539f\u7a9c[{}]", (Object)signResource);
        String sign = this.securityService.signature(signResource, this.config.getAppkey());
        request.setSign(sign);
        if (this.config.getCfcafile() != null && this.config.getCfcafile().length > 1) {
            String cfcaSign = this.securityService.cfcaSignature(signResource, this.config.getCfcapwd(), this.config.getCfcafile());
            request.setCfcasign(cfcaSign);
        }
        URI url = URI.create(String.valueOf(this.config.getFileurl()) + "filev2/download");
        String body = JSON.toJSONString((Object)request);
        log.debug("\u8bf7\u6c42\u5730\u5740:[{}],\u62a5\u6587[{}]", (Object)url.toASCIIString(), (Object)body);
        return HttpClientUtil.downloadFile(url, body, this.config);
    }

    @Override
    public MakeH5GetOut makeGetH5Url(String h5group, String traceno, Map<String, String> request) throws SdkException {
        MakeH5GetOut out = new MakeH5GetOut();
        RegisterTokenRequest in = new RegisterTokenRequest();
        in.setAppid(this.config.getAppid());
        if (request != null && request.size() > 0) {
            String jsonBody = JSON.toJSONString(request);
            String body = this.securityService.encrypt(jsonBody, this.config.getAppkey());
            in.setBody(body);
        }
        in.setH5group(h5group);
        in.setOpenid(this.config.getOpenid());
        in.setSendtime(DateUtil.getSendTime());
        in.setTraceno(traceno);
        String signResource = in.signResource();
        String sign = this.securityService.signature(signResource, this.config.getAppkey());
        in.setSign(sign);
        if (this.config.getCfcafile() != null && this.config.getCfcafile().length > 1) {
            String cfcaSign = this.securityService.cfcaSignature(signResource, this.config.getCfcapwd(), this.config.getCfcafile());
            in.setCfcasign(cfcaSign);
        }
        URI url = URI.create(String.valueOf(this.config.getHgtwurl()) + "commv2/token");
        String postJson = JSON.toJSONString((Object)in);
        log.debug("\u8bf7\u6c42\u5730\u5740:[{}],\u62a5\u6587[{}]", (Object)url.toASCIIString(), (Object)postJson);
        String response = HttpClientUtil.post(url, postJson, this.config);
        log.debug("\u5e94\u7b54:[{}]", (Object)response);
        RegisterTokenResponse registerTokenResponse = (RegisterTokenResponse)JSON.parseObject((String)response, RegisterTokenResponse.class);
        out.setResultcode(registerTokenResponse.getResultcode());
        out.setResultdesc(registerTokenResponse.getResultdesc());
        if (out != null && ErrorCode.E0000.getCode().equals(registerTokenResponse.getResultcode())) {
            String tmpToken = registerTokenResponse.getH5token();
            String h5sgin = this.securityService.signature(tmpToken, this.config.getAppkey());
            String params = "h5token=" + tmpToken + "&sgin=" + h5sgin;
            out.setParams(params);
            out.setH5url(this.config.getH5baseurl());
        }
        return out;
    }

    @Override
    public void checkSign(String string, String string2, String string3) throws SdkException {
        Frame frame = new Frame(6, 5);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject((Object)this);
        frame.setLocal(0, genericObject);
        GenericObject genericObject2 = new GenericObject();
        genericObject2.setObject((Object)string);
        frame.setLocal(1, genericObject2);
        GenericObject genericObject3 = new GenericObject();
        genericObject3.setObject((Object)string2);
        frame.setLocal(2, genericObject3);
        GenericObject genericObject4 = new GenericObject();
        genericObject4.setObject((Object)string3);
        frame.setLocal(3, genericObject4);
        int[] nArray = new int[]{-1216600590, 0, -2075757258, -1971282735, 3, -1216600590, 0, 1981404930, 1643901804, -352363147, -1572156008, 4, -1902672993, 4, 180416834, 2, -683376129, 797286601, 44, -1713117633, -297473093, 1697248794, 729511083, -1432391335, -1916062133, -1902672993, 4, 580037538, -1432391335, -100918145, 180416834, 2, 580037538, -1432391335, 451973601, -1971282735, 3, 580037538, -1074823633, -171306118, -1432391335, 2008266409, -811052846, -860791419, -1216600590, 0, 1813631399, 913083967, -737922297, 82, -1216600590, 0, -1452472454, -1710586662, 1, -1971282735, 3, 1322929378, 797286601, 65, -171306118, -1432391335, 1667157219, 152516763, 781151407, -1216600590, 0, 866339425, -1710586662, 1, -1216600590, 0, -1754149010, 1209114199, -449273045, 797286601, 82, -171306118, -1432391335, 1142698091, 1620369816, 1201008301, -587854017};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case -1216600590: {
                    GenericObject genericObject5 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject5);
                    n += 2;
                    break;
                }
                case -2075757258: {
                    GenericObject genericObject6 = frame.pop();
                    GenericObject genericObject7 = new GenericObject();
                    genericObject7.setObject((Object)((OpenApiServiceImpl)genericObject6.getObject()).securityService);
                    frame.push(genericObject7);
                    ++n;
                    break;
                }
                case -1971282735: {
                    GenericObject genericObject8 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject8);
                    n += 2;
                    break;
                }
                case 1981404930: {
                    GenericObject genericObject9 = frame.pop();
                    GenericObject genericObject10 = new GenericObject();
                    genericObject10.setObject((Object)((OpenApiServiceImpl)genericObject9.getObject()).config);
                    frame.push(genericObject10);
                    ++n;
                    break;
                }
                case 1643901804: {
                    Object object = frame.pop().getObject();
                    Object object2 = ((EntAppConfig)object).getAppkey();
                    GenericObject genericObject11 = new GenericObject();
                    genericObject11.setObject(object2);
                    frame.push(genericObject11);
                    ++n;
                    break;
                }
                case -352363147: {
                    Object object = frame.pop().getObject();
                    Object object3 = frame.pop().getObject();
                    Object object4 = frame.pop().getObject();
                    Object object5 = ((OpenApiSecurityService)object4).signature((String)object3, (String)object);
                    GenericObject genericObject12 = new GenericObject();
                    genericObject12.setObject(object5);
                    frame.push(genericObject12);
                    ++n;
                    break;
                }
                case -1572156008: {
                    GenericObject genericObject13 = frame.pop();
                    frame.setLocal(nArray[n + 1], genericObject13);
                    n += 2;
                    break;
                }
                case -1902672993: {
                    GenericObject genericObject14 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject14);
                    n += 2;
                    break;
                }
                case 180416834: {
                    GenericObject genericObject15 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject15);
                    n += 2;
                    break;
                }
                case -683376129: {
                    CharSequence charSequence = (CharSequence)frame.pop().getObject();
                    CharSequence charSequence2 = (CharSequence)frame.pop().getObject();
                    boolean bl = StringUtils.equals(charSequence2, charSequence);
                    GenericObject genericObject16 = new GenericObject();
                    genericObject16.setBoolean(bl);
                    frame.push(genericObject16);
                    ++n;
                    break;
                }
                case 797286601: {
                    GenericObject genericObject17 = frame.pop();
                    int n2 = genericObject17.toInt();
                    if (n2 != 0) {
                        n = nArray[n + 1];
                        break;
                    }
                    n += 2;
                    break;
                }
                case -1713117633: {
                    GenericObject genericObject18 = new GenericObject();
                    genericObject18.setObject((Object)log);
                    frame.push(genericObject18);
                    ++n;
                    break;
                }
                case -297473093: {
                    GenericObject genericObject19 = new GenericObject();
                    genericObject19.setString("5pys5Zyw562+5ZCNW3t9XSzov5Tlm57nrb7lkI1be31d77yM6L+U5Zue5oql5paHW3t9XQ==");
                    frame.push(genericObject19);
                    ++n;
                    break;
                }
                case 1697248794: {
                    GenericObject genericObject20 = new GenericObject();
                    genericObject20.setInt(3);
                    frame.push(genericObject20);
                    ++n;
                    break;
                }
                case 729511083: {
                    int n3 = frame.pop().getInt();
                    Object[] objectArray = new Object[n3];
                    GenericObject genericObject21 = new GenericObject();
                    genericObject21.setObject((Object)objectArray);
                    frame.push(genericObject21);
                    ++n;
                    break;
                }
                case -1432391335: {
                    GenericObject genericObject22 = frame.peek();
                    frame.push(genericObject22);
                    ++n;
                    break;
                }
                case -1916062133: {
                    GenericObject genericObject23 = new GenericObject();
                    genericObject23.setInt(0);
                    frame.push(genericObject23);
                    ++n;
                    break;
                }
                case 580037538: {
                    GenericObject genericObject24 = frame.pop();
                    int n4 = frame.pop().getInt();
                    GenericObject genericObject25 = frame.pop();
                    Object object = genericObject25.getObject();
                    Object[] objectArray = (Object[])object;
                    objectArray[n4] = genericObject24.getObject();
                    ++n;
                    break;
                }
                case -100918145: {
                    GenericObject genericObject26 = new GenericObject();
                    genericObject26.setInt(1);
                    frame.push(genericObject26);
                    ++n;
                    break;
                }
                case 451973601: {
                    GenericObject genericObject27 = new GenericObject();
                    genericObject27.setInt(2);
                    frame.push(genericObject27);
                    ++n;
                    break;
                }
                case -1074823633: {
                    Object object = frame.pop().getObject();
                    Object object6 = frame.pop().getObject();
                    Object object7 = frame.pop().getObject();
                    ((Logger)object7).error((String)object6, (Object[])object);
                    ++n;
                    break;
                }
                case -171306118: {
                    StubObject stubObject = new StubObject("com.czb.sap.sdk.exception.SdkException");
                    GenericObject genericObject28 = new GenericObject();
                    genericObject28.setObject((Object)stubObject);
                    frame.push(genericObject28);
                    ++n;
                    break;
                }
                case 2008266409: {
                    GenericObject genericObject29 = new GenericObject();
                    genericObject29.setObject((Object)ErrorCode.E0010);
                    frame.push(genericObject29);
                    ++n;
                    break;
                }
                case -811052846: {
                    Object object = frame.pop().getObject();
                    SdkException sdkException = new SdkException((ErrorCode)((Object)object));
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject30 = new GenericObject();
                    genericObject30.setObject((Object)sdkException);
                    frame.push(genericObject30);
                    ++n;
                    break;
                }
                case -860791419: {
                    GenericObject genericObject31 = frame.pop();
                    frame.empty();
                    frame.push(genericObject31);
                    genericObject31.throwException();
                    ++n;
                    break;
                }
                case 1813631399: {
                    GenericObject genericObject32 = frame.pop();
                    GenericObject genericObject33 = new GenericObject();
                    genericObject33.setObject((Object)((OpenApiServiceImpl)genericObject32.getObject()).config);
                    frame.push(genericObject33);
                    ++n;
                    break;
                }
                case 913083967: {
                    Object object = frame.pop().getObject();
                    Object object8 = ((EntAppConfig)object).getCerfile();
                    GenericObject genericObject34 = new GenericObject();
                    genericObject34.setObject(object8);
                    frame.push(genericObject34);
                    ++n;
                    break;
                }
                case -737922297: {
                    GenericObject genericObject35 = frame.pop();
                    if (genericObject35.getObject() == null) {
                        n = nArray[n + 1];
                        break;
                    }
                    n += 2;
                    break;
                }
                case -1452472454: {
                    GenericObject genericObject36 = frame.pop();
                    GenericObject genericObject37 = new GenericObject();
                    genericObject37.setObject((Object)((OpenApiServiceImpl)genericObject36.getObject()).securityService);
                    frame.push(genericObject37);
                    ++n;
                    break;
                }
                case -1710586662: {
                    GenericObject genericObject38 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject38);
                    n += 2;
                    break;
                }
                case 1322929378: {
                    Object object = frame.pop().getObject();
                    Object object9 = frame.pop().getObject();
                    Object object10 = frame.pop().getObject();
                    boolean bl = ((OpenApiSecurityService)object10).verify((String)object9, (String)object);
                    GenericObject genericObject39 = new GenericObject();
                    genericObject39.setBoolean(bl);
                    frame.push(genericObject39);
                    ++n;
                    break;
                }
                case 1667157219: {
                    GenericObject genericObject40 = new GenericObject();
                    genericObject40.setObject((Object)ErrorCode.E0011);
                    frame.push(genericObject40);
                    ++n;
                    break;
                }
                case 152516763: {
                    Object object = frame.pop().getObject();
                    SdkException sdkException = new SdkException((ErrorCode)((Object)object));
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject41 = new GenericObject();
                    genericObject41.setObject((Object)sdkException);
                    frame.push(genericObject41);
                    ++n;
                    break;
                }
                case 781151407: {
                    GenericObject genericObject42 = frame.pop();
                    frame.empty();
                    frame.push(genericObject42);
                    genericObject42.throwException();
                    ++n;
                    break;
                }
                case 866339425: {
                    GenericObject genericObject43 = frame.pop();
                    GenericObject genericObject44 = new GenericObject();
                    genericObject44.setObject((Object)((OpenApiServiceImpl)genericObject43.getObject()).securityService);
                    frame.push(genericObject44);
                    ++n;
                    break;
                }
                case -1754149010: {
                    GenericObject genericObject45 = frame.pop();
                    GenericObject genericObject46 = new GenericObject();
                    genericObject46.setObject((Object)((OpenApiServiceImpl)genericObject45.getObject()).config);
                    frame.push(genericObject46);
                    ++n;
                    break;
                }
                case 1209114199: {
                    Object object = frame.pop().getObject();
                    Object object11 = ((EntAppConfig)object).getCerfile();
                    GenericObject genericObject47 = new GenericObject();
                    genericObject47.setObject(object11);
                    frame.push(genericObject47);
                    ++n;
                    break;
                }
                case -449273045: {
                    Object object = frame.pop().getObject();
                    Object object12 = frame.pop().getObject();
                    Object object13 = frame.pop().getObject();
                    boolean bl = ((OpenApiSecurityService)object13).verifyDn((String)object12, (byte[])object);
                    GenericObject genericObject48 = new GenericObject();
                    genericObject48.setBoolean(bl);
                    frame.push(genericObject48);
                    ++n;
                    break;
                }
                case 1142698091: {
                    GenericObject genericObject49 = new GenericObject();
                    genericObject49.setObject((Object)ErrorCode.E0016);
                    frame.push(genericObject49);
                    ++n;
                    break;
                }
                case 1620369816: {
                    Object object = frame.pop().getObject();
                    SdkException sdkException = new SdkException((ErrorCode)((Object)object));
                    frame.pop();
                    frame.pop();
                    GenericObject genericObject50 = new GenericObject();
                    genericObject50.setObject((Object)sdkException);
                    frame.push(genericObject50);
                    ++n;
                    break;
                }
                case 1201008301: {
                    GenericObject genericObject51 = frame.pop();
                    frame.empty();
                    frame.push(genericObject51);
                    genericObject51.throwException();
                    ++n;
                    break;
                }
                case -587854017: {
                    return;
                }
            }
        }
    }

    @Override
    @Deprecated
    public UploadFileOut uploadBigFile(UploadFileIn uploadFileIn) throws SdkException {
        Frame frame = new Frame(2, 2);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject((Object)this);
        frame.setLocal(0, genericObject);
        GenericObject genericObject2 = new GenericObject();
        genericObject2.setObject((Object)uploadFileIn);
        frame.setLocal(1, genericObject2);
        int[] nArray = new int[]{1969217085, 0, 1843532385, 1, -669847213, -1721255759};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case 1969217085: {
                    GenericObject genericObject3 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject3);
                    n += 2;
                    break;
                }
                case 1843532385: {
                    GenericObject genericObject4 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject4);
                    n += 2;
                    break;
                }
                case -669847213: {
                    Object object = frame.pop().getObject();
                    Object object2 = frame.pop().getObject();
                    Object object3 = ((OpenApiServiceImpl)object2).uploadFile((UploadFileIn)object);
                    GenericObject genericObject5 = new GenericObject();
                    genericObject5.setObject(object3);
                    frame.push(genericObject5);
                    ++n;
                    break;
                }
                case -1721255759: {
                    return (UploadFileOut)frame.pop().getObject();
                }
            }
        }
    }

    @Override
    public UploadFileOut uploadCheckFile(UploadFileIn in) throws SdkException {
        UploadRequest request = new UploadRequest();
        String filename = in.getFilename();
        request.setFilename(filename);
        request.setTraceno(in.getTraceno());
        request.setGroup(in.getFilegroup());
        if (StringUtils.isNotBlank(in.getToken())) {
            request.setToken(in.getToken());
        } else {
            request.setToken(this.getCacheToken());
        }
        request.setFile(in.getFile());
        request.setAppid(this.config.getAppid());
        request.setOpenid(this.config.getOpenid());
        request.setSendtime(DateUtil.getSendTime());
        request.setTermianatype(TermianaType.SDK.getCode());
        String fileabstract = this.securityService.fileAbstract(request.getFile());
        request.setFileabstract(fileabstract);
        String signResource = request.signResource();
        String sign = this.securityService.signature(signResource, this.config.getAppkey());
        request.setSign(sign);
        if (this.config.getCfcafile() != null && this.config.getCfcafile().length > 1) {
            String cfcaSign = this.securityService.cfcaSignature(signResource, this.config.getCfcapwd(), this.config.getCfcafile());
            request.setCfcasign(cfcaSign);
        }
        URI url = URI.create(String.valueOf(this.config.getFileurl()) + "filev2/uploadcheckfile");
        log.debug("\u8bf7\u6c42\u5730\u5740:[{}],\u62a5\u6587[{}]", (Object)url.toASCIIString(), (Object)JSON.toJSONString((Object)request));
        String response = HttpClientUtil.sendPostFile(request, url, this.config);
        UploadFileOut out = (UploadFileOut)JSON.parseObject((String)response, UploadFileOut.class);
        if (out != null && ErrorCode.E0000.getCode().equals(out.getResultcode())) {
            this.checkUploadSign(out);
        }
        if (out != null && "840010".equals(out.getResultcode())) {
            String token = SdkCache.getInstance().removeValue(String.valueOf(this.appName) + "token");
            log.warn("remove  token  [{}]", (Object)token);
            SdkCache.getInstance().removeValue(String.valueOf(this.appName) + "tokentimeout");
        }
        return out;
    }

    public String getAppName() {
        Frame frame = new Frame(1, 1);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject((Object)this);
        frame.setLocal(0, genericObject);
        int[] nArray = new int[]{1291958207, 0, -314144767, 1498409255};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case 1291958207: {
                    GenericObject genericObject2 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject2);
                    n += 2;
                    break;
                }
                case -314144767: {
                    GenericObject genericObject3 = frame.pop();
                    GenericObject genericObject4 = new GenericObject();
                    genericObject4.setObject((Object)((OpenApiServiceImpl)genericObject3.getObject()).appName);
                    frame.push(genericObject4);
                    ++n;
                    break;
                }
                case 1498409255: {
                    return (String)frame.pop().getObject();
                }
            }
        }
    }

    public EntAppConfig getConfig() {
        Frame frame = new Frame(1, 1);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject((Object)this);
        frame.setLocal(0, genericObject);
        int[] nArray = new int[]{382314454, 0, -788560919, -557063291};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case 382314454: {
                    GenericObject genericObject2 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject2);
                    n += 2;
                    break;
                }
                case -788560919: {
                    GenericObject genericObject3 = frame.pop();
                    GenericObject genericObject4 = new GenericObject();
                    genericObject4.setObject((Object)((OpenApiServiceImpl)genericObject3.getObject()).config);
                    frame.push(genericObject4);
                    ++n;
                    break;
                }
                case -557063291: {
                    return (EntAppConfig)frame.pop().getObject();
                }
            }
        }
    }

    public OpenApiSecurityService getSecurityService() {
        Frame frame = new Frame(1, 1);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject((Object)this);
        frame.setLocal(0, genericObject);
        int[] nArray = new int[]{1488826653, 0, 486944695, -225631135};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case 1488826653: {
                    GenericObject genericObject2 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject2);
                    n += 2;
                    break;
                }
                case 486944695: {
                    GenericObject genericObject3 = frame.pop();
                    GenericObject genericObject4 = new GenericObject();
                    genericObject4.setObject((Object)((OpenApiServiceImpl)genericObject3.getObject()).securityService);
                    frame.push(genericObject4);
                    ++n;
                    break;
                }
                case -225631135: {
                    return (OpenApiSecurityService)frame.pop().getObject();
                }
            }
        }
    }

    public Lock getLock() {
        Frame frame = new Frame(1, 1);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject((Object)this);
        frame.setLocal(0, genericObject);
        int[] nArray = new int[]{836113944, 0, -44484100, -1802402941};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case 836113944: {
                    GenericObject genericObject2 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject2);
                    n += 2;
                    break;
                }
                case -44484100: {
                    GenericObject genericObject3 = frame.pop();
                    GenericObject genericObject4 = new GenericObject();
                    genericObject4.setObject((Object)((OpenApiServiceImpl)genericObject3.getObject()).lock);
                    frame.push(genericObject4);
                    ++n;
                    break;
                }
                case -1802402941: {
                    return (Lock)frame.pop().getObject();
                }
            }
        }
    }

    public void setAppName(String string) {
        Frame frame = new Frame(2, 2);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject((Object)this);
        frame.setLocal(0, genericObject);
        GenericObject genericObject2 = new GenericObject();
        genericObject2.setObject((Object)string);
        frame.setLocal(1, genericObject2);
        int[] nArray = new int[]{361969638, 0, -712212579, 1, 1364789678, 1964728932};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case 361969638: {
                    GenericObject genericObject3 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject3);
                    n += 2;
                    break;
                }
                case -712212579: {
                    GenericObject genericObject4 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject4);
                    n += 2;
                    break;
                }
                case 1364789678: {
                    GenericObject genericObject5 = frame.pop();
                    ((OpenApiServiceImpl)frame.pop().getObject()).appName = (String)genericObject5.getObject();
                    ++n;
                    break;
                }
                case 1964728932: {
                    return;
                }
            }
        }
    }

    public void setConfig(EntAppConfig entAppConfig) {
        Frame frame = new Frame(2, 2);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject((Object)this);
        frame.setLocal(0, genericObject);
        GenericObject genericObject2 = new GenericObject();
        genericObject2.setObject((Object)entAppConfig);
        frame.setLocal(1, genericObject2);
        int[] nArray = new int[]{-691609279, 0, 1785423567, 1, -1987580621, 367127819};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case -691609279: {
                    GenericObject genericObject3 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject3);
                    n += 2;
                    break;
                }
                case 1785423567: {
                    GenericObject genericObject4 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject4);
                    n += 2;
                    break;
                }
                case -1987580621: {
                    GenericObject genericObject5 = frame.pop();
                    ((OpenApiServiceImpl)frame.pop().getObject()).config = (EntAppConfig)genericObject5.getObject();
                    ++n;
                    break;
                }
                case 367127819: {
                    return;
                }
            }
        }
    }

    public void setSecurityService(OpenApiSecurityService openApiSecurityService) {
        Frame frame = new Frame(2, 2);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject((Object)this);
        frame.setLocal(0, genericObject);
        GenericObject genericObject2 = new GenericObject();
        genericObject2.setObject((Object)openApiSecurityService);
        frame.setLocal(1, genericObject2);
        int[] nArray = new int[]{1055349322, 0, 1357148707, 1, 1339002438, -732042596};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case 1055349322: {
                    GenericObject genericObject3 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject3);
                    n += 2;
                    break;
                }
                case 1357148707: {
                    GenericObject genericObject4 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject4);
                    n += 2;
                    break;
                }
                case 1339002438: {
                    GenericObject genericObject5 = frame.pop();
                    ((OpenApiServiceImpl)frame.pop().getObject()).securityService = (OpenApiSecurityService)genericObject5.getObject();
                    ++n;
                    break;
                }
                case -732042596: {
                    return;
                }
            }
        }
    }

    public void setLock(Lock lock) {
        Frame frame = new Frame(2, 2);
        GenericObject genericObject = new GenericObject();
        genericObject.setObject((Object)this);
        frame.setLocal(0, genericObject);
        GenericObject genericObject2 = new GenericObject();
        genericObject2.setObject((Object)lock);
        frame.setLocal(1, genericObject2);
        int[] nArray = new int[]{582376758, 0, -578587238, 1, -815744984, -325255528};
        int n = 0;
        while (true) {
            switch (nArray[n]) {
                case 582376758: {
                    GenericObject genericObject3 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject3);
                    n += 2;
                    break;
                }
                case -578587238: {
                    GenericObject genericObject4 = frame.getLocal(nArray[n + 1]);
                    frame.push(genericObject4);
                    n += 2;
                    break;
                }
                case -815744984: {
                    GenericObject genericObject5 = frame.pop();
                    ((OpenApiServiceImpl)frame.pop().getObject()).lock = (Lock)genericObject5.getObject();
                    ++n;
                    break;
                }
                case -325255528: {
                    return;
                }
            }
        }
    }
}

