/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.auth;

import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.auth.BasicUserPrincipal;
import com.icbc.api.internal.apache.http.auth.Credentials;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.LangUtils;
import java.io.Serializable;
import java.security.Principal;

@Immutable
public class UsernamePasswordCredentials
implements Credentials,
Serializable {
    private static final long serialVersionUID = 243343858802739403L;
    private final BasicUserPrincipal principal;
    private final String password;

    @Deprecated
    public UsernamePasswordCredentials(String string) {
        Args.notNull((Object)string, (String)"Username:password string");
        int n = string.indexOf(58);
        if (n >= 0) {
            this.principal = new BasicUserPrincipal(string.substring(0, n));
            this.password = string.substring(n + 1);
        } else {
            this.principal = new BasicUserPrincipal(string);
            this.password = null;
        }
    }

    public UsernamePasswordCredentials(String string, String string2) {
        Args.notNull((Object)string, (String)"Username");
        this.principal = new BasicUserPrincipal(string);
        this.password = string2;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.principal;
    }

    public String getUserName() {
        return this.principal.getName();
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public int hashCode() {
        return this.principal.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)object;
            if (LangUtils.equals((Object)this.principal, (Object)usernamePasswordCredentials.principal)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.principal.toString();
    }
}

