/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.client.entity;

import com.icbc.api.internal.apache.http.annotation.NotThreadSafe;
import com.icbc.api.internal.apache.http.client.entity.InputStreamFactory;
import java.io.IOException;
import java.io.InputStream;

@NotThreadSafe
class LazyDecompressingInputStream
extends InputStream {
    private final InputStream wrappedStream;
    private final InputStreamFactory inputStreamFactory;
    private InputStream wrapperStream;

    public LazyDecompressingInputStream(InputStream inputStream, InputStreamFactory inputStreamFactory) {
        this.wrappedStream = inputStream;
        this.inputStreamFactory = inputStreamFactory;
    }

    private void initWrapper() throws IOException {
        if (this.wrapperStream == null) {
            this.wrapperStream = this.inputStreamFactory.create(this.wrappedStream);
        }
    }

    @Override
    public int read() throws IOException {
        this.initWrapper();
        return this.wrapperStream.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        this.initWrapper();
        return this.wrapperStream.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.initWrapper();
        return this.wrapperStream.read(byArray, n, n2);
    }

    @Override
    public long skip(long l) throws IOException {
        this.initWrapper();
        return this.wrapperStream.skip(l);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        this.initWrapper();
        return this.wrapperStream.available();
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.wrapperStream != null) {
                this.wrapperStream.close();
            }
        }
        finally {
            this.wrappedStream.close();
        }
    }
}

