/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.client.protocol;

import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpRequestInterceptor;
import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.conn.routing.RouteInfo;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Immutable
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull((Object)httpRequest, (String)"HTTP request");
        String string = httpRequest.getRequestLine().getMethod();
        if (string.equalsIgnoreCase("CONNECT")) {
            httpRequest.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        RouteInfo routeInfo = httpClientContext.getHttpRoute();
        if (routeInfo == null) {
            this.log.debug((Object)"Connection route not set in the context");
            return;
        }
        if ((routeInfo.getHopCount() == 1 || routeInfo.isTunnelled()) && !httpRequest.containsHeader("Connection")) {
            httpRequest.addHeader("Connection", "Keep-Alive");
        }
        if (routeInfo.getHopCount() == 2 && !routeInfo.isTunnelled() && !httpRequest.containsHeader(PROXY_CONN_DIRECTIVE)) {
            httpRequest.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

