/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.client.protocol;

import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.HeaderIterator;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.HttpResponseInterceptor;
import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.client.CookieStore;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.cookie.Cookie;
import com.icbc.api.internal.apache.http.cookie.CookieOrigin;
import com.icbc.api.internal.apache.http.cookie.CookieSpec;
import com.icbc.api.internal.apache.http.cookie.MalformedCookieException;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Immutable
public class ResponseProcessCookies
implements HttpResponseInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull((Object)httpResponse, (String)"HTTP request");
        Args.notNull((Object)httpContext, (String)"HTTP context");
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        CookieSpec cookieSpec = httpClientContext.getCookieSpec();
        if (cookieSpec == null) {
            this.log.debug((Object)"Cookie spec not specified in HTTP context");
            return;
        }
        CookieStore cookieStore = httpClientContext.getCookieStore();
        if (cookieStore == null) {
            this.log.debug((Object)"Cookie store not specified in HTTP context");
            return;
        }
        CookieOrigin cookieOrigin = httpClientContext.getCookieOrigin();
        if (cookieOrigin == null) {
            this.log.debug((Object)"Cookie origin not specified in HTTP context");
            return;
        }
        HeaderIterator headerIterator = httpResponse.headerIterator("Set-Cookie");
        this.processCookies(headerIterator, cookieSpec, cookieOrigin, cookieStore);
        if (cookieSpec.getVersion() > 0) {
            headerIterator = httpResponse.headerIterator("Set-Cookie2");
            this.processCookies(headerIterator, cookieSpec, cookieOrigin, cookieStore);
        }
    }

    private void processCookies(HeaderIterator headerIterator, CookieSpec cookieSpec, CookieOrigin cookieOrigin, CookieStore cookieStore) {
        while (headerIterator.hasNext()) {
            Header header = headerIterator.nextHeader();
            try {
                List<Cookie> list = cookieSpec.parse(header, cookieOrigin);
                for (Cookie cookie : list) {
                    try {
                        cookieSpec.validate(cookie, cookieOrigin);
                        cookieStore.addCookie(cookie);
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)("Cookie accepted [" + ResponseProcessCookies.formatCooke(cookie) + "]"));
                    }
                    catch (MalformedCookieException malformedCookieException) {
                        if (!this.log.isWarnEnabled()) continue;
                        this.log.warn((Object)("Cookie rejected [" + ResponseProcessCookies.formatCooke(cookie) + "] " + malformedCookieException.getMessage()));
                    }
                }
            }
            catch (MalformedCookieException malformedCookieException) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)("Invalid cookie header: \"" + header + "\". " + malformedCookieException.getMessage()));
            }
        }
    }

    private static String formatCooke(Cookie cookie) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(cookie.getName());
        stringBuilder.append("=\"");
        String string = cookie.getValue();
        if (string != null) {
            if (string.length() > 100) {
                string = string.substring(0, 100) + "...";
            }
            stringBuilder.append(string);
        }
        stringBuilder.append("\"");
        stringBuilder.append(", version:");
        stringBuilder.append(Integer.toString(cookie.getVersion()));
        stringBuilder.append(", domain:");
        stringBuilder.append(cookie.getDomain());
        stringBuilder.append(", path:");
        stringBuilder.append(cookie.getPath());
        stringBuilder.append(", expiry:");
        stringBuilder.append(cookie.getExpiryDate());
        return stringBuilder.toString();
    }
}

