/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.client.utils;

import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.client.HttpClient;
import com.icbc.api.internal.apache.http.client.methods.CloseableHttpResponse;
import com.icbc.api.internal.apache.http.util.EntityUtils;
import java.io.Closeable;
import java.io.IOException;

public class HttpClientUtils {
    private HttpClientUtils() {
    }

    public static void closeQuietly(HttpResponse httpResponse) {
        HttpEntity httpEntity;
        if (httpResponse != null && (httpEntity = httpResponse.getEntity()) != null) {
            try {
                EntityUtils.consume(httpEntity);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(CloseableHttpResponse closeableHttpResponse) {
        if (closeableHttpResponse != null) {
            try {
                try {
                    EntityUtils.consume(closeableHttpResponse.getEntity());
                }
                finally {
                    closeableHttpResponse.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(HttpClient httpClient) {
        if (httpClient != null && httpClient instanceof Closeable) {
            try {
                ((Closeable)((Object)httpClient)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

