/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.conn.util;

import com.icbc.api.internal.apache.http.Consts;
import com.icbc.api.internal.apache.http.annotation.ThreadSafe;
import com.icbc.api.internal.apache.http.conn.util.PublicSuffixListParser;
import com.icbc.api.internal.apache.http.conn.util.PublicSuffixMatcher;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public final class PublicSuffixMatcherLoader {
    private static volatile PublicSuffixMatcher DEFAULT_INSTANCE;

    private static PublicSuffixMatcher load(InputStream inputStream) throws IOException {
        List list = new PublicSuffixListParser().parseByType((Reader)new InputStreamReader(inputStream, Consts.UTF_8));
        return new PublicSuffixMatcher((Collection)list);
    }

    public static PublicSuffixMatcher load(URL uRL) throws IOException {
        Args.notNull((Object)uRL, (String)"URL");
        try (InputStream inputStream = uRL.openStream();){
            PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.load(inputStream);
            return publicSuffixMatcher;
        }
    }

    public static PublicSuffixMatcher load(File file) throws IOException {
        Args.notNull((Object)file, (String)"File");
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.load(fileInputStream);
            return publicSuffixMatcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PublicSuffixMatcher getDefault() {
        if (DEFAULT_INSTANCE != null) return DEFAULT_INSTANCE;
        Class<PublicSuffixMatcherLoader> clazz = PublicSuffixMatcherLoader.class;
        synchronized (PublicSuffixMatcherLoader.class) {
            if (DEFAULT_INSTANCE != null) return DEFAULT_INSTANCE;
            URL uRL = PublicSuffixMatcherLoader.class.getResource("/mozilla/public-suffix-list.txt");
            if (uRL != null) {
                try {
                    DEFAULT_INSTANCE = PublicSuffixMatcherLoader.load(uRL);
                }
                catch (IOException iOException) {
                    Log log = LogFactory.getLog(PublicSuffixMatcherLoader.class);
                    if (!log.isWarnEnabled()) return DEFAULT_INSTANCE;
                    log.warn((Object)"Failure loading public suffix list from default resource", (Throwable)iOException);
                }
            } else {
                DEFAULT_INSTANCE = new PublicSuffixMatcher(Arrays.asList("com"), null);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return DEFAULT_INSTANCE;
        }
    }
}

