/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.cookie;

import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.TextUtils;
import java.util.Locale;

@Immutable
public final class CookieOrigin {
    private final String host;
    private final int port;
    private final String path;
    private final boolean secure;

    public CookieOrigin(String string, int n, String string2, boolean bl) {
        Args.notBlank((CharSequence)string, (String)"Host");
        Args.notNegative((int)n, (String)"Port");
        Args.notNull((Object)string2, (String)"Path");
        this.host = string.toLowerCase(Locale.ROOT);
        this.port = n;
        this.path = !TextUtils.isBlank((CharSequence)string2) ? string2 : "/";
        this.secure = bl;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        if (this.secure) {
            stringBuilder.append("(secure)");
        }
        stringBuilder.append(this.host);
        stringBuilder.append(':');
        stringBuilder.append(Integer.toString(this.port));
        stringBuilder.append(this.path);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

