/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl;

import com.icbc.api.internal.apache.http.HttpClientConnection;
import com.icbc.api.internal.apache.http.HttpConnectionMetrics;
import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpEntityEnclosingRequest;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.HttpResponseFactory;
import com.icbc.api.internal.apache.http.impl.DefaultHttpResponseFactory;
import com.icbc.api.internal.apache.http.impl.HttpConnectionMetricsImpl;
import com.icbc.api.internal.apache.http.impl.entity.EntityDeserializer;
import com.icbc.api.internal.apache.http.impl.entity.EntitySerializer;
import com.icbc.api.internal.apache.http.impl.entity.LaxContentLengthStrategy;
import com.icbc.api.internal.apache.http.impl.entity.StrictContentLengthStrategy;
import com.icbc.api.internal.apache.http.impl.io.DefaultHttpResponseParser;
import com.icbc.api.internal.apache.http.impl.io.HttpRequestWriter;
import com.icbc.api.internal.apache.http.io.EofSensor;
import com.icbc.api.internal.apache.http.io.HttpMessageParser;
import com.icbc.api.internal.apache.http.io.HttpMessageWriter;
import com.icbc.api.internal.apache.http.io.HttpTransportMetrics;
import com.icbc.api.internal.apache.http.io.SessionInputBuffer;
import com.icbc.api.internal.apache.http.io.SessionOutputBuffer;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.net.SocketTimeoutException;

@Deprecated
public abstract class AbstractHttpClientConnection
implements HttpClientConnection {
    private final EntitySerializer entityserializer = this.createEntitySerializer();
    private final EntityDeserializer entitydeserializer = this.createEntityDeserializer();
    private SessionInputBuffer inbuffer = null;
    private SessionOutputBuffer outbuffer = null;
    private EofSensor eofSensor = null;
    private HttpMessageParser<HttpResponse> responseParser = null;
    private HttpMessageWriter<HttpRequest> requestWriter = null;
    private HttpConnectionMetricsImpl metrics = null;

    protected abstract void assertOpen() throws IllegalStateException;

    protected EntityDeserializer createEntityDeserializer() {
        return new EntityDeserializer(new LaxContentLengthStrategy());
    }

    protected EntitySerializer createEntitySerializer() {
        return new EntitySerializer(new StrictContentLengthStrategy());
    }

    protected HttpResponseFactory createHttpResponseFactory() {
        return DefaultHttpResponseFactory.INSTANCE;
    }

    protected HttpMessageParser<HttpResponse> createResponseParser(SessionInputBuffer sessionInputBuffer, HttpResponseFactory httpResponseFactory, HttpParams httpParams) {
        return new DefaultHttpResponseParser(sessionInputBuffer, null, httpResponseFactory, httpParams);
    }

    protected HttpMessageWriter<HttpRequest> createRequestWriter(SessionOutputBuffer sessionOutputBuffer, HttpParams httpParams) {
        return new HttpRequestWriter(sessionOutputBuffer, null, httpParams);
    }

    protected HttpConnectionMetricsImpl createConnectionMetrics(HttpTransportMetrics httpTransportMetrics, HttpTransportMetrics httpTransportMetrics2) {
        return new HttpConnectionMetricsImpl(httpTransportMetrics, httpTransportMetrics2);
    }

    protected void init(SessionInputBuffer sessionInputBuffer, SessionOutputBuffer sessionOutputBuffer, HttpParams httpParams) {
        this.inbuffer = (SessionInputBuffer)Args.notNull((Object)sessionInputBuffer, (String)"Input session buffer");
        this.outbuffer = (SessionOutputBuffer)Args.notNull((Object)sessionOutputBuffer, (String)"Output session buffer");
        if (sessionInputBuffer instanceof EofSensor) {
            this.eofSensor = (EofSensor)((Object)sessionInputBuffer);
        }
        this.responseParser = this.createResponseParser(sessionInputBuffer, this.createHttpResponseFactory(), httpParams);
        this.requestWriter = this.createRequestWriter(sessionOutputBuffer, httpParams);
        this.metrics = this.createConnectionMetrics(sessionInputBuffer.getMetrics(), sessionOutputBuffer.getMetrics());
    }

    @Override
    public boolean isResponseAvailable(int n) throws IOException {
        this.assertOpen();
        try {
            return this.inbuffer.isDataAvailable(n);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return false;
        }
    }

    @Override
    public void sendRequestHeader(HttpRequest httpRequest) throws HttpException, IOException {
        Args.notNull((Object)httpRequest, (String)"HTTP request");
        this.assertOpen();
        this.requestWriter.write(httpRequest);
        this.metrics.incrementRequestCount();
    }

    @Override
    public void sendRequestEntity(HttpEntityEnclosingRequest httpEntityEnclosingRequest) throws HttpException, IOException {
        Args.notNull((Object)httpEntityEnclosingRequest, (String)"HTTP request");
        this.assertOpen();
        if (httpEntityEnclosingRequest.getEntity() == null) {
            return;
        }
        this.entityserializer.serialize(this.outbuffer, httpEntityEnclosingRequest, httpEntityEnclosingRequest.getEntity());
    }

    protected void doFlush() throws IOException {
        this.outbuffer.flush();
    }

    @Override
    public void flush() throws IOException {
        this.assertOpen();
        this.doFlush();
    }

    @Override
    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        this.assertOpen();
        HttpResponse httpResponse = this.responseParser.parse();
        if (httpResponse.getStatusLine().getStatusCode() >= 200) {
            this.metrics.incrementResponseCount();
        }
        return httpResponse;
    }

    @Override
    public void receiveResponseEntity(HttpResponse httpResponse) throws HttpException, IOException {
        Args.notNull((Object)httpResponse, (String)"HTTP response");
        this.assertOpen();
        HttpEntity httpEntity = this.entitydeserializer.deserialize(this.inbuffer, httpResponse);
        httpResponse.setEntity(httpEntity);
    }

    protected boolean isEof() {
        return this.eofSensor != null && this.eofSensor.isEof();
    }

    @Override
    public boolean isStale() {
        if (!this.isOpen()) {
            return true;
        }
        if (this.isEof()) {
            return true;
        }
        try {
            this.inbuffer.isDataAvailable(1);
            return this.isEof();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return false;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return this.metrics;
    }
}

