/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl;

import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpRequestFactory;
import com.icbc.api.internal.apache.http.MethodNotSupportedException;
import com.icbc.api.internal.apache.http.RequestLine;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.message.BasicHttpEntityEnclosingRequest;
import com.icbc.api.internal.apache.http.message.BasicHttpRequest;
import com.icbc.api.internal.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultHttpRequestFactory
implements HttpRequestFactory {
    public static final DefaultHttpRequestFactory INSTANCE = new DefaultHttpRequestFactory();
    private static final String[] RFC2616_COMMON_METHODS = new String[]{"GET"};
    private static final String[] RFC2616_ENTITY_ENC_METHODS = new String[]{"POST", "PUT"};
    private static final String[] RFC2616_SPECIAL_METHODS = new String[]{"HEAD", "OPTIONS", "DELETE", "TRACE", "CONNECT"};
    private static final String[] RFC5789_ENTITY_ENC_METHODS = new String[]{"PATCH"};

    private static boolean isOneOf(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public HttpRequest newHttpRequest(RequestLine requestLine) throws MethodNotSupportedException {
        Args.notNull((Object)requestLine, (String)"Request line");
        String string = requestLine.getMethod();
        if (DefaultHttpRequestFactory.isOneOf(RFC2616_COMMON_METHODS, string)) {
            return new BasicHttpRequest(requestLine);
        }
        if (DefaultHttpRequestFactory.isOneOf(RFC2616_ENTITY_ENC_METHODS, string)) {
            return new BasicHttpEntityEnclosingRequest(requestLine);
        }
        if (DefaultHttpRequestFactory.isOneOf(RFC2616_SPECIAL_METHODS, string)) {
            return new BasicHttpRequest(requestLine);
        }
        if (DefaultHttpRequestFactory.isOneOf(RFC5789_ENTITY_ENC_METHODS, string)) {
            return new BasicHttpEntityEnclosingRequest(requestLine);
        }
        throw new MethodNotSupportedException(string + " method not supported");
    }

    @Override
    public HttpRequest newHttpRequest(String string, String string2) throws MethodNotSupportedException {
        if (DefaultHttpRequestFactory.isOneOf(RFC2616_COMMON_METHODS, string)) {
            return new BasicHttpRequest(string, string2);
        }
        if (DefaultHttpRequestFactory.isOneOf(RFC2616_ENTITY_ENC_METHODS, string)) {
            return new BasicHttpEntityEnclosingRequest(string, string2);
        }
        if (DefaultHttpRequestFactory.isOneOf(RFC2616_SPECIAL_METHODS, string)) {
            return new BasicHttpRequest(string, string2);
        }
        if (DefaultHttpRequestFactory.isOneOf(RFC5789_ENTITY_ENC_METHODS, string)) {
            return new BasicHttpEntityEnclosingRequest(string, string2);
        }
        throw new MethodNotSupportedException(string + " method not supported");
    }
}

