/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.auth;

import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.annotation.NotThreadSafe;
import com.icbc.api.internal.apache.http.auth.AuthenticationException;
import com.icbc.api.internal.apache.http.auth.Credentials;
import com.icbc.api.internal.apache.http.impl.auth.GGSSchemeBase;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

@NotThreadSafe
public class KerberosScheme
extends GGSSchemeBase {
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";

    public KerberosScheme(boolean bl, boolean bl2) {
        super(bl, bl2);
    }

    public KerberosScheme(boolean bl) {
        super(bl);
    }

    public KerberosScheme() {
    }

    @Override
    public String getSchemeName() {
        return "Kerberos";
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest httpRequest, HttpContext httpContext) throws AuthenticationException {
        return super.authenticate(credentials, httpRequest, httpContext);
    }

    @Override
    protected byte[] generateToken(byte[] byArray, String string) throws GSSException {
        return super.generateToken(byArray, string);
    }

    @Override
    protected byte[] generateToken(byte[] byArray, String string, Credentials credentials) throws GSSException {
        return this.generateGSSToken(byArray, new Oid(KERBEROS_OID), string, credentials);
    }

    @Override
    public String getParameter(String string) {
        Args.notNull((Object)string, (String)"Parameter name");
        return null;
    }

    @Override
    public String getRealm() {
        return null;
    }

    @Override
    public boolean isConnectionBased() {
        return true;
    }
}

