/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.auth;

import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.annotation.NotThreadSafe;
import com.icbc.api.internal.apache.http.auth.AuthenticationException;
import com.icbc.api.internal.apache.http.auth.Credentials;
import com.icbc.api.internal.apache.http.auth.InvalidCredentialsException;
import com.icbc.api.internal.apache.http.auth.MalformedChallengeException;
import com.icbc.api.internal.apache.http.auth.NTCredentials;
import com.icbc.api.internal.apache.http.impl.auth.AuthSchemeBase;
import com.icbc.api.internal.apache.http.impl.auth.NTLMEngine;
import com.icbc.api.internal.apache.http.impl.auth.NTLMEngineImpl;
import com.icbc.api.internal.apache.http.impl.auth.NTLMScheme;
import com.icbc.api.internal.apache.http.message.BufferedHeader;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public class NTLMScheme
extends AuthSchemeBase {
    private final NTLMEngine engine;
    private State state;
    private String challenge;

    public NTLMScheme(NTLMEngine nTLMEngine) {
        Args.notNull((Object)nTLMEngine, (String)"NTLM engine");
        this.engine = nTLMEngine;
        this.state = State.UNINITIATED;
        this.challenge = null;
    }

    public NTLMScheme() {
        this(new NTLMEngineImpl());
    }

    @Override
    public String getSchemeName() {
        return "ntlm";
    }

    @Override
    public String getParameter(String string) {
        return null;
    }

    @Override
    public String getRealm() {
        return null;
    }

    @Override
    public boolean isConnectionBased() {
        return true;
    }

    @Override
    protected void parseChallenge(CharArrayBuffer charArrayBuffer, int n, int n2) throws MalformedChallengeException {
        this.challenge = charArrayBuffer.substringTrimmed(n, n2);
        if (this.challenge.isEmpty()) {
            this.state = this.state == State.UNINITIATED ? State.CHALLENGE_RECEIVED : State.FAILED;
        } else {
            if (this.state.compareTo((Enum)State.MSG_TYPE1_GENERATED) < 0) {
                this.state = State.FAILED;
                throw new MalformedChallengeException("Out of sequence NTLM response message");
            }
            if (this.state == State.MSG_TYPE1_GENERATED) {
                this.state = State.MSG_TYPE2_RECEVIED;
            }
        }
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest httpRequest) throws AuthenticationException {
        NTCredentials nTCredentials = null;
        try {
            nTCredentials = (NTCredentials)credentials;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidCredentialsException("Credentials cannot be used for NTLM authentication: " + credentials.getClass().getName());
        }
        String string = null;
        if (this.state == State.FAILED) {
            throw new AuthenticationException("NTLM authentication failed");
        }
        if (this.state == State.CHALLENGE_RECEIVED) {
            string = this.engine.generateType1Msg(nTCredentials.getDomain(), nTCredentials.getWorkstation());
            this.state = State.MSG_TYPE1_GENERATED;
        } else if (this.state == State.MSG_TYPE2_RECEVIED) {
            string = this.engine.generateType3Msg(nTCredentials.getUserName(), nTCredentials.getPassword(), nTCredentials.getDomain(), nTCredentials.getWorkstation(), this.challenge);
            this.state = State.MSG_TYPE3_GENERATED;
        } else {
            throw new AuthenticationException("Unexpected state: " + this.state);
        }
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(32);
        if (this.isProxy()) {
            charArrayBuffer.append("Proxy-Authorization");
        } else {
            charArrayBuffer.append("Authorization");
        }
        charArrayBuffer.append(": NTLM ");
        charArrayBuffer.append(string);
        return new BufferedHeader(charArrayBuffer);
    }

    @Override
    public boolean isComplete() {
        return this.state == State.MSG_TYPE3_GENERATED || this.state == State.FAILED;
    }
}

