/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.bootstrap;

import com.icbc.api.internal.apache.http.ExceptionLogger;
import com.icbc.api.internal.apache.http.HttpServerConnection;
import com.icbc.api.internal.apache.http.protocol.BasicHttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpCoreContext;
import com.icbc.api.internal.apache.http.protocol.HttpService;
import java.io.IOException;

class Worker
implements Runnable {
    private final HttpService httpservice;
    private final HttpServerConnection conn;
    private final ExceptionLogger exceptionLogger;

    Worker(HttpService httpService, HttpServerConnection httpServerConnection, ExceptionLogger exceptionLogger) {
        this.httpservice = httpService;
        this.conn = httpServerConnection;
        this.exceptionLogger = exceptionLogger;
    }

    public HttpServerConnection getConnection() {
        return this.conn;
    }

    @Override
    public void run() {
        try {
            BasicHttpContext basicHttpContext = new BasicHttpContext();
            HttpCoreContext httpCoreContext = HttpCoreContext.adapt(basicHttpContext);
            while (!Thread.interrupted() && this.conn.isOpen()) {
                this.httpservice.handleRequest(this.conn, httpCoreContext);
                basicHttpContext.clear();
            }
            this.conn.close();
        }
        catch (Exception exception) {
            this.exceptionLogger.log(exception);
        }
        finally {
            try {
                this.conn.shutdown();
            }
            catch (IOException iOException) {
                this.exceptionLogger.log(iOException);
            }
        }
    }
}

