/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.client;

import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.annotation.ThreadSafe;
import com.icbc.api.internal.apache.http.client.HttpClient;
import com.icbc.api.internal.apache.http.client.ResponseHandler;
import com.icbc.api.internal.apache.http.client.ServiceUnavailableRetryStrategy;
import com.icbc.api.internal.apache.http.client.methods.HttpUriRequest;
import com.icbc.api.internal.apache.http.conn.ClientConnectionManager;
import com.icbc.api.internal.apache.http.impl.client.DefaultHttpClient;
import com.icbc.api.internal.apache.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.EntityUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
@ThreadSafe
public class AutoRetryHttpClient
implements HttpClient {
    private final HttpClient backend;
    private final ServiceUnavailableRetryStrategy retryStrategy;
    private final Log log = LogFactory.getLog(this.getClass());

    public AutoRetryHttpClient(HttpClient httpClient, ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy) {
        Args.notNull((Object)httpClient, (String)"HttpClient");
        Args.notNull((Object)serviceUnavailableRetryStrategy, (String)"ServiceUnavailableRetryStrategy");
        this.backend = httpClient;
        this.retryStrategy = serviceUnavailableRetryStrategy;
    }

    public AutoRetryHttpClient() {
        this(new DefaultHttpClient(), new DefaultServiceUnavailableRetryStrategy());
    }

    public AutoRetryHttpClient(ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy) {
        this(new DefaultHttpClient(), serviceUnavailableRetryStrategy);
    }

    public AutoRetryHttpClient(HttpClient httpClient) {
        this(httpClient, new DefaultServiceUnavailableRetryStrategy());
    }

    @Override
    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest) throws IOException {
        HttpContext httpContext = null;
        return this.execute(httpHost, httpRequest, httpContext);
    }

    @Override
    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(httpHost, httpRequest, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException {
        HttpResponse httpResponse = this.execute(httpHost, httpRequest, httpContext);
        return responseHandler.handleResponse(httpResponse);
    }

    @Override
    public HttpResponse execute(HttpUriRequest httpUriRequest) throws IOException {
        HttpContext httpContext = null;
        return this.execute(httpUriRequest, httpContext);
    }

    @Override
    public HttpResponse execute(HttpUriRequest httpUriRequest, HttpContext httpContext) throws IOException {
        URI uRI = httpUriRequest.getURI();
        HttpHost httpHost = new HttpHost(uRI.getHost(), uRI.getPort(), uRI.getScheme());
        return this.execute(httpHost, (HttpRequest)httpUriRequest, httpContext);
    }

    @Override
    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(httpUriRequest, responseHandler, null);
    }

    @Override
    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException {
        HttpResponse httpResponse = this.execute(httpUriRequest, httpContext);
        return responseHandler.handleResponse(httpResponse);
    }

    @Override
    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws IOException {
        int n = 1;
        while (true) {
            block8: {
                HttpResponse httpResponse = this.backend.execute(httpHost, httpRequest, httpContext);
                try {
                    if (this.retryStrategy.retryRequest(httpResponse, n, httpContext)) {
                        EntityUtils.consume(httpResponse.getEntity());
                        long l = this.retryStrategy.getRetryInterval();
                        try {
                            this.log.trace((Object)("Wait for " + l));
                            Thread.sleep(l);
                            break block8;
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                    return httpResponse;
                }
                catch (RuntimeException runtimeException) {
                    try {
                        EntityUtils.consume(httpResponse.getEntity());
                    }
                    catch (IOException iOException) {
                        this.log.warn((Object)"I/O error consuming response content", (Throwable)iOException);
                    }
                    throw runtimeException;
                }
            }
            ++n;
        }
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return this.backend.getConnectionManager();
    }

    @Override
    public HttpParams getParams() {
        return this.backend.getParams();
    }
}

