/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.client;

import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.ProtocolException;
import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.client.CircularRedirectException;
import com.icbc.api.internal.apache.http.client.RedirectHandler;
import com.icbc.api.internal.apache.http.client.utils.URIUtils;
import com.icbc.api.internal.apache.http.impl.client.RedirectLocations;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
@Immutable
public class DefaultRedirectHandler
implements RedirectHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String REDIRECT_LOCATIONS = "http.protocol.redirect-locations";

    @Override
    public boolean isRedirectRequested(HttpResponse httpResponse, HttpContext httpContext) {
        Args.notNull((Object)httpResponse, (String)"HTTP response");
        int n = httpResponse.getStatusLine().getStatusCode();
        switch (n) {
            case 301: 
            case 302: 
            case 307: {
                HttpRequest httpRequest = (HttpRequest)httpContext.getAttribute("http.request");
                String string = httpRequest.getRequestLine().getMethod();
                return string.equalsIgnoreCase("GET") || string.equalsIgnoreCase("HEAD");
            }
            case 303: {
                return true;
            }
        }
        return false;
    }

    @Override
    public URI getLocationURI(HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
        Serializable serializable;
        Object object;
        Object object2;
        URI uRI;
        Args.notNull((Object)httpResponse, (String)"HTTP response");
        Header header = httpResponse.getFirstHeader("location");
        if (header == null) {
            throw new ProtocolException("Received redirect response " + httpResponse.getStatusLine() + " but no location header");
        }
        String string = header.getValue();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Redirect requested to location '" + string + "'"));
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException("Invalid redirect URI: " + string, uRISyntaxException);
        }
        HttpParams httpParams = httpResponse.getParams();
        if (!uRI.isAbsolute()) {
            if (httpParams.isParameterTrue("http.protocol.reject-relative-redirect")) {
                throw new ProtocolException("Relative redirect location '" + uRI + "' not allowed");
            }
            object2 = (HttpHost)httpContext.getAttribute("http.target_host");
            Asserts.notNull((Object)object2, (String)"Target host");
            object = (HttpRequest)httpContext.getAttribute("http.request");
            try {
                serializable = new URI(object.getRequestLine().getUri());
                URI uRI2 = URIUtils.rewriteURI(serializable, (HttpHost)object2, true);
                uRI = URIUtils.resolve(uRI2, uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ProtocolException(uRISyntaxException.getMessage(), uRISyntaxException);
            }
        }
        if (httpParams.isParameterFalse("http.protocol.allow-circular-redirects")) {
            object2 = (RedirectLocations)httpContext.getAttribute(REDIRECT_LOCATIONS);
            if (object2 == null) {
                object2 = new RedirectLocations();
                httpContext.setAttribute(REDIRECT_LOCATIONS, object2);
            }
            if (uRI.getFragment() != null) {
                try {
                    serializable = new HttpHost(uRI.getHost(), uRI.getPort(), uRI.getScheme());
                    object = URIUtils.rewriteURI(uRI, (HttpHost)serializable, true);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new ProtocolException(uRISyntaxException.getMessage(), uRISyntaxException);
                }
            } else {
                object = uRI;
            }
            if (((RedirectLocations)object2).contains((URI)object)) {
                throw new CircularRedirectException("Circular redirect to '" + object + "'");
            }
            ((RedirectLocations)object2).add((URI)object);
        }
        return uRI;
    }
}

