/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.client;

import com.icbc.api.internal.apache.http.conn.HttpClientConnectionManager;
import com.icbc.api.internal.apache.http.util.Args;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class IdleConnectionEvictor {
    private final HttpClientConnectionManager connectionManager;
    private final ThreadFactory threadFactory;
    private final Thread thread;
    private final long sleepTimeMs;
    private final long maxIdleTimeMs;
    private volatile Exception exception;

    public IdleConnectionEvictor(final HttpClientConnectionManager httpClientConnectionManager, ThreadFactory threadFactory, long l, TimeUnit timeUnit, long l2, TimeUnit timeUnit2) {
        this.connectionManager = (HttpClientConnectionManager)Args.notNull((Object)httpClientConnectionManager, (String)"Connection manager");
        this.threadFactory = threadFactory != null ? threadFactory : new DefaultThreadFactory();
        this.sleepTimeMs = timeUnit != null ? timeUnit.toMillis(l) : l;
        this.maxIdleTimeMs = timeUnit2 != null ? timeUnit2.toMillis(l2) : l2;
        this.thread = this.threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        Thread.sleep(IdleConnectionEvictor.this.sleepTimeMs);
                        httpClientConnectionManager.closeExpiredConnections();
                        if (IdleConnectionEvictor.this.maxIdleTimeMs <= 0L) continue;
                        httpClientConnectionManager.closeIdleConnections(IdleConnectionEvictor.this.maxIdleTimeMs, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception exception) {
                    IdleConnectionEvictor.this.exception = exception;
                }
            }
        });
    }

    public IdleConnectionEvictor(HttpClientConnectionManager httpClientConnectionManager, long l, TimeUnit timeUnit, long l2, TimeUnit timeUnit2) {
        this(httpClientConnectionManager, null, l, timeUnit, l2, timeUnit2);
    }

    public IdleConnectionEvictor(HttpClientConnectionManager httpClientConnectionManager, long l, TimeUnit timeUnit) {
        this(httpClientConnectionManager, null, l > 0L ? l : 5L, timeUnit != null ? timeUnit : TimeUnit.SECONDS, l, timeUnit);
    }

    public void start() {
        this.thread.start();
    }

    public void shutdown() {
        this.thread.interrupt();
    }

    public boolean isRunning() {
        return this.thread.isAlive();
    }

    public void awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        this.thread.join((timeUnit != null ? timeUnit : TimeUnit.MILLISECONDS).toMillis(l));
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        DefaultThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "Connection evictor");
            thread.setDaemon(true);
            return thread;
        }
    }
}

