/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.client;

import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.HttpVersion;
import com.icbc.api.internal.apache.http.auth.AuthSchemeRegistry;
import com.icbc.api.internal.apache.http.auth.AuthScope;
import com.icbc.api.internal.apache.http.auth.AuthState;
import com.icbc.api.internal.apache.http.auth.Credentials;
import com.icbc.api.internal.apache.http.client.config.RequestConfig;
import com.icbc.api.internal.apache.http.client.params.HttpClientParamConfig;
import com.icbc.api.internal.apache.http.client.protocol.RequestClientConnControl;
import com.icbc.api.internal.apache.http.config.ConnectionConfig;
import com.icbc.api.internal.apache.http.conn.HttpConnectionFactory;
import com.icbc.api.internal.apache.http.conn.ManagedHttpClientConnection;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.conn.routing.RouteInfo;
import com.icbc.api.internal.apache.http.entity.BufferedHttpEntity;
import com.icbc.api.internal.apache.http.impl.DefaultConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.impl.auth.BasicSchemeFactory;
import com.icbc.api.internal.apache.http.impl.auth.DigestSchemeFactory;
import com.icbc.api.internal.apache.http.impl.auth.HttpAuthenticator;
import com.icbc.api.internal.apache.http.impl.auth.KerberosSchemeFactory;
import com.icbc.api.internal.apache.http.impl.auth.NTLMSchemeFactory;
import com.icbc.api.internal.apache.http.impl.auth.SPNegoSchemeFactory;
import com.icbc.api.internal.apache.http.impl.client.BasicCredentialsProvider;
import com.icbc.api.internal.apache.http.impl.client.ProxyAuthenticationStrategy;
import com.icbc.api.internal.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import com.icbc.api.internal.apache.http.impl.execchain.TunnelRefusedException;
import com.icbc.api.internal.apache.http.message.BasicHttpRequest;
import com.icbc.api.internal.apache.http.params.BasicHttpParams;
import com.icbc.api.internal.apache.http.params.HttpParamConfig;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.protocol.BasicHttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import com.icbc.api.internal.apache.http.protocol.HttpRequestExecutor;
import com.icbc.api.internal.apache.http.protocol.ImmutableHttpProcessor;
import com.icbc.api.internal.apache.http.protocol.RequestTargetHost;
import com.icbc.api.internal.apache.http.protocol.RequestUserAgent;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.EntityUtils;
import java.io.IOException;
import java.net.Socket;

public class ProxyClient {
    private final HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory;
    private final ConnectionConfig connectionConfig;
    private final RequestConfig requestConfig;
    private final HttpProcessor httpProcessor;
    private final HttpRequestExecutor requestExec;
    private final ProxyAuthenticationStrategy proxyAuthStrategy;
    private final HttpAuthenticator authenticator;
    private final AuthState proxyAuthState;
    private final AuthSchemeRegistry authSchemeRegistry;
    private final ConnectionReuseStrategy reuseStrategy;

    public ProxyClient(HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> managedHttpClientConnectionFactory, ConnectionConfig connectionConfig, RequestConfig requestConfig) {
        this.connFactory = managedHttpClientConnectionFactory != null ? managedHttpClientConnectionFactory : ManagedHttpClientConnectionFactory.INSTANCE;
        this.connectionConfig = connectionConfig != null ? connectionConfig : ConnectionConfig.DEFAULT;
        this.requestConfig = requestConfig != null ? requestConfig : RequestConfig.DEFAULT;
        this.httpProcessor = new ImmutableHttpProcessor(new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent());
        this.requestExec = new HttpRequestExecutor();
        this.proxyAuthStrategy = new ProxyAuthenticationStrategy();
        this.authenticator = new HttpAuthenticator();
        this.proxyAuthState = new AuthState();
        this.authSchemeRegistry = new AuthSchemeRegistry();
        this.authSchemeRegistry.register("Basic", new BasicSchemeFactory());
        this.authSchemeRegistry.register("Digest", new DigestSchemeFactory());
        this.authSchemeRegistry.register("NTLM", new NTLMSchemeFactory());
        this.authSchemeRegistry.register("Negotiate", new SPNegoSchemeFactory());
        this.authSchemeRegistry.register("Kerberos", new KerberosSchemeFactory());
        this.reuseStrategy = new DefaultConnectionReuseStrategy();
    }

    @Deprecated
    public ProxyClient(HttpParams httpParams) {
        this(null, HttpParamConfig.getConnectionConfig(httpParams), HttpClientParamConfig.getRequestConfig(httpParams));
    }

    public ProxyClient(RequestConfig requestConfig) {
        this(null, null, requestConfig);
    }

    public ProxyClient() {
        this(null, null, null);
    }

    @Deprecated
    public HttpParams getParams() {
        return new BasicHttpParams();
    }

    @Deprecated
    public AuthSchemeRegistry getAuthSchemeRegistry() {
        return this.authSchemeRegistry;
    }

    public Socket tunnel(HttpHost httpHost, HttpHost httpHost2, Credentials credentials) throws IOException, HttpException {
        HttpEntity httpEntity;
        int n;
        HttpResponse httpResponse;
        Args.notNull((Object)httpHost, (String)"Proxy host");
        Args.notNull((Object)httpHost2, (String)"Target host");
        Args.notNull((Object)credentials, (String)"Credentials");
        HttpHost httpHost3 = httpHost2;
        if (httpHost3.getPort() <= 0) {
            httpHost3 = new HttpHost(httpHost3.getHostName(), 80, httpHost3.getSchemeName());
        }
        HttpRoute httpRoute = new HttpRoute(httpHost3, this.requestConfig.getLocalAddress(), httpHost, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        ManagedHttpClientConnection managedHttpClientConnection = this.connFactory.create(httpRoute, this.connectionConfig);
        BasicHttpContext basicHttpContext = new BasicHttpContext();
        BasicHttpRequest basicHttpRequest = new BasicHttpRequest("CONNECT", httpHost3.toHostString(), HttpVersion.HTTP_1_1);
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        basicCredentialsProvider.setCredentials(new AuthScope(httpHost), credentials);
        basicHttpContext.setAttribute("http.target_host", httpHost2);
        basicHttpContext.setAttribute("http.connection", managedHttpClientConnection);
        basicHttpContext.setAttribute("http.request", basicHttpRequest);
        basicHttpContext.setAttribute("http.route", httpRoute);
        basicHttpContext.setAttribute("http.auth.proxy-scope", this.proxyAuthState);
        basicHttpContext.setAttribute("http.auth.credentials-provider", basicCredentialsProvider);
        basicHttpContext.setAttribute("http.authscheme-registry", this.authSchemeRegistry);
        basicHttpContext.setAttribute("http.request-config", this.requestConfig);
        this.requestExec.preProcess(basicHttpRequest, this.httpProcessor, basicHttpContext);
        while (true) {
            if (!managedHttpClientConnection.isOpen()) {
                Socket socket = new Socket(httpHost.getHostName(), httpHost.getPort());
                managedHttpClientConnection.bind(socket);
            }
            this.authenticator.generateAuthResponse(basicHttpRequest, this.proxyAuthState, basicHttpContext);
            httpResponse = this.requestExec.execute(basicHttpRequest, managedHttpClientConnection, basicHttpContext);
            n = httpResponse.getStatusLine().getStatusCode();
            if (n < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + httpResponse.getStatusLine());
            }
            if (!this.authenticator.isAuthenticationRequested(httpHost, httpResponse, this.proxyAuthStrategy, this.proxyAuthState, basicHttpContext) || !this.authenticator.handleAuthChallenge(httpHost, httpResponse, this.proxyAuthStrategy, this.proxyAuthState, basicHttpContext)) break;
            if (this.reuseStrategy.keepAlive(httpResponse, basicHttpContext)) {
                httpEntity = httpResponse.getEntity();
                EntityUtils.consume(httpEntity);
            } else {
                managedHttpClientConnection.close();
            }
            basicHttpRequest.removeHeaders("Proxy-Authorization");
        }
        n = httpResponse.getStatusLine().getStatusCode();
        if (n > 299) {
            httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                httpResponse.setEntity(new BufferedHttpEntity(httpEntity));
            }
            managedHttpClientConnection.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + httpResponse.getStatusLine(), httpResponse);
        }
        return managedHttpClientConnection.getSocket();
    }
}

