/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.client;

import com.icbc.api.internal.apache.http.annotation.NotThreadSafe;
import java.net.URI;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@NotThreadSafe
public class RedirectLocations
extends AbstractList<Object> {
    private final Set<URI> unique = new HashSet<URI>();
    private final List<URI> all = new ArrayList<URI>();

    public boolean contains(URI uRI) {
        return this.unique.contains(uRI);
    }

    public void add(URI uRI) {
        this.unique.add(uRI);
        this.all.add(uRI);
    }

    public boolean remove(URI uRI) {
        boolean bl = this.unique.remove(uRI);
        if (bl) {
            Iterator<URI> iterator = this.all.iterator();
            while (iterator.hasNext()) {
                URI uRI2 = iterator.next();
                if (!uRI2.equals(uRI)) continue;
                iterator.remove();
            }
        }
        return bl;
    }

    public List<URI> getAll() {
        return new ArrayList<URI>(this.all);
    }

    @Override
    public URI get(int n) {
        return this.all.get(n);
    }

    @Override
    public int size() {
        return this.all.size();
    }

    @Override
    public Object set(int n, Object object) {
        URI uRI = this.all.set(n, (URI)object);
        this.unique.remove(uRI);
        this.unique.add((URI)object);
        if (this.all.size() != this.unique.size()) {
            this.unique.addAll(this.all);
        }
        return uRI;
    }

    @Override
    public void add(int n, Object object) {
        this.all.add(n, (URI)object);
        this.unique.add((URI)object);
    }

    @Override
    public URI remove(int n) {
        URI uRI = this.all.remove(n);
        this.unique.remove(uRI);
        if (this.all.size() != this.unique.size()) {
            this.unique.addAll(this.all);
        }
        return uRI;
    }

    @Override
    public boolean contains(Object object) {
        return this.unique.contains(object);
    }
}

