/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.conn;

import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.conn.ClientConnectionOperator;
import com.icbc.api.internal.apache.http.conn.OperatedClientConnection;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.conn.routing.RouteTracker;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.io.InterruptedIOException;

@Deprecated
public abstract class AbstractPoolEntry {
    protected final ClientConnectionOperator connOperator;
    protected final OperatedClientConnection connection;
    protected volatile HttpRoute route;
    protected volatile Object state;
    protected volatile RouteTracker tracker;

    protected AbstractPoolEntry(ClientConnectionOperator clientConnectionOperator, HttpRoute httpRoute) {
        Args.notNull((Object)clientConnectionOperator, (String)"Connection operator");
        this.connOperator = clientConnectionOperator;
        this.connection = clientConnectionOperator.createConnection();
        this.route = httpRoute;
        this.tracker = null;
    }

    public Object getState() {
        return this.state;
    }

    public void setState(Object object) {
        this.state = object;
    }

    public void open(HttpRoute httpRoute, HttpContext httpContext, HttpParams httpParams) throws IOException {
        Args.notNull((Object)httpRoute, (String)"Route");
        Args.notNull((Object)httpParams, (String)"HTTP parameters");
        if (this.tracker != null) {
            Asserts.check((!this.tracker.isConnected() ? 1 : 0) != 0, (String)"Connection already open");
        }
        this.tracker = new RouteTracker(httpRoute);
        HttpHost httpHost = httpRoute.getProxyHost();
        this.connOperator.openConnection(this.connection, httpHost != null ? httpHost : httpRoute.getTargetHost(), httpRoute.getLocalAddress(), httpContext, httpParams);
        RouteTracker routeTracker = this.tracker;
        if (routeTracker == null) {
            throw new InterruptedIOException("Request aborted");
        }
        if (httpHost == null) {
            routeTracker.connectTarget(this.connection.isSecure());
        } else {
            routeTracker.connectProxy(httpHost, this.connection.isSecure());
        }
    }

    public void tunnelTarget(boolean bl, HttpParams httpParams) throws IOException {
        Args.notNull((Object)httpParams, (String)"HTTP parameters");
        Asserts.notNull((Object)this.tracker, (String)"Route tracker");
        Asserts.check((boolean)this.tracker.isConnected(), (String)"Connection not open");
        Asserts.check((!this.tracker.isTunnelled() ? 1 : 0) != 0, (String)"Connection is already tunnelled");
        this.connection.update(null, this.tracker.getTargetHost(), bl, httpParams);
        this.tracker.tunnelTarget(bl);
    }

    public void tunnelProxy(HttpHost httpHost, boolean bl, HttpParams httpParams) throws IOException {
        Args.notNull((Object)httpHost, (String)"Next proxy");
        Args.notNull((Object)httpParams, (String)"Parameters");
        Asserts.notNull((Object)this.tracker, (String)"Route tracker");
        Asserts.check((boolean)this.tracker.isConnected(), (String)"Connection not open");
        this.connection.update(null, httpHost, bl, httpParams);
        this.tracker.tunnelProxy(httpHost, bl);
    }

    public void layerProtocol(HttpContext httpContext, HttpParams httpParams) throws IOException {
        Args.notNull((Object)httpParams, (String)"HTTP parameters");
        Asserts.notNull((Object)this.tracker, (String)"Route tracker");
        Asserts.check((boolean)this.tracker.isConnected(), (String)"Connection not open");
        Asserts.check((boolean)this.tracker.isTunnelled(), (String)"Protocol layering without a tunnel not supported");
        Asserts.check((!this.tracker.isLayered() ? 1 : 0) != 0, (String)"Multiple protocol layering not supported");
        HttpHost httpHost = this.tracker.getTargetHost();
        this.connOperator.updateSecureConnection(this.connection, httpHost, httpContext, httpParams);
        this.tracker.layerProtocol(this.connection.isSecure());
    }

    protected void shutdownEntry() {
        this.tracker = null;
        this.state = null;
    }
}

