/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.conn;

import com.icbc.api.internal.apache.http.HttpClientConnection;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.annotation.GuardedBy;
import com.icbc.api.internal.apache.http.annotation.ThreadSafe;
import com.icbc.api.internal.apache.http.config.ConnectionConfig;
import com.icbc.api.internal.apache.http.config.Lookup;
import com.icbc.api.internal.apache.http.config.Registry;
import com.icbc.api.internal.apache.http.config.RegistryBuilder;
import com.icbc.api.internal.apache.http.config.SocketConfig;
import com.icbc.api.internal.apache.http.conn.ConnectionRequest;
import com.icbc.api.internal.apache.http.conn.DnsResolver;
import com.icbc.api.internal.apache.http.conn.HttpClientConnectionManager;
import com.icbc.api.internal.apache.http.conn.HttpClientConnectionOperator;
import com.icbc.api.internal.apache.http.conn.HttpConnectionFactory;
import com.icbc.api.internal.apache.http.conn.ManagedHttpClientConnection;
import com.icbc.api.internal.apache.http.conn.SchemePortResolver;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.conn.socket.ConnectionSocketFactory;
import com.icbc.api.internal.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.icbc.api.internal.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.icbc.api.internal.apache.http.impl.conn.DefaultHttpClientConnectionOperator;
import com.icbc.api.internal.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import com.icbc.api.internal.apache.http.util.LangUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class BasicHttpClientConnectionManager
implements HttpClientConnectionManager,
Closeable {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpClientConnectionOperator connectionOperator;
    private final HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory;
    @GuardedBy(value="this")
    private ManagedHttpClientConnection conn;
    @GuardedBy(value="this")
    private HttpRoute route;
    @GuardedBy(value="this")
    private Object state;
    @GuardedBy(value="this")
    private long updated;
    @GuardedBy(value="this")
    private long expiry;
    @GuardedBy(value="this")
    private boolean leased;
    @GuardedBy(value="this")
    private SocketConfig socketConfig;
    @GuardedBy(value="this")
    private ConnectionConfig connConfig;
    private final AtomicBoolean isShutdown;

    private static Registry<ConnectionSocketFactory> getDefaultRegistry() {
        return RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)SSLConnectionSocketFactory.getSocketFactory())).build();
    }

    public BasicHttpClientConnectionManager(Lookup<ConnectionSocketFactory> lookup, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> httpConnectionFactory, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        this(new DefaultHttpClientConnectionOperator(lookup, schemePortResolver, dnsResolver), httpConnectionFactory);
    }

    public BasicHttpClientConnectionManager(HttpClientConnectionOperator httpClientConnectionOperator, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> managedHttpClientConnectionFactory) {
        this.connectionOperator = (HttpClientConnectionOperator)Args.notNull((Object)httpClientConnectionOperator, (String)"Connection operator");
        this.connFactory = managedHttpClientConnectionFactory != null ? managedHttpClientConnectionFactory : ManagedHttpClientConnectionFactory.INSTANCE;
        this.expiry = Long.MAX_VALUE;
        this.socketConfig = SocketConfig.DEFAULT;
        this.connConfig = ConnectionConfig.DEFAULT;
        this.isShutdown = new AtomicBoolean(false);
    }

    public BasicHttpClientConnectionManager(Lookup<ConnectionSocketFactory> lookup, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> httpConnectionFactory) {
        this(lookup, httpConnectionFactory, null, null);
    }

    public BasicHttpClientConnectionManager(Lookup<ConnectionSocketFactory> lookup) {
        this(lookup, null, null, null);
    }

    public BasicHttpClientConnectionManager() {
        this(BasicHttpClientConnectionManager.getDefaultRegistry(), null, null, null);
    }

    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    HttpRoute getRoute() {
        return this.route;
    }

    Object getState() {
        return this.state;
    }

    public synchronized SocketConfig getSocketConfig() {
        return this.socketConfig;
    }

    public synchronized void setSocketConfig(SocketConfig socketConfig) {
        this.socketConfig = socketConfig != null ? socketConfig : SocketConfig.DEFAULT;
    }

    public synchronized ConnectionConfig getConnectionConfig() {
        return this.connConfig;
    }

    public synchronized void setConnectionConfig(ConnectionConfig connectionConfig) {
        this.connConfig = connectionConfig != null ? connectionConfig : ConnectionConfig.DEFAULT;
    }

    @Override
    public final ConnectionRequest requestConnection(final HttpRoute httpRoute, final Object object) {
        Args.notNull((Object)httpRoute, (String)"Route");
        return new ConnectionRequest(){

            @Override
            public boolean cancel() {
                return false;
            }

            @Override
            public HttpClientConnection get(long l, TimeUnit timeUnit) {
                return BasicHttpClientConnectionManager.this.getConnection(httpRoute, object);
            }
        };
    }

    private void closeConnection() {
        if (this.conn != null) {
            block3: {
                this.log.debug((Object)"Closing connection");
                try {
                    this.conn.close();
                }
                catch (IOException iOException) {
                    if (!this.log.isDebugEnabled()) break block3;
                    this.log.debug((Object)"I/O exception closing connection", (Throwable)iOException);
                }
            }
            this.conn = null;
        }
    }

    private void shutdownConnection() {
        if (this.conn != null) {
            block3: {
                this.log.debug((Object)"Shutting down connection");
                try {
                    this.conn.shutdown();
                }
                catch (IOException iOException) {
                    if (!this.log.isDebugEnabled()) break block3;
                    this.log.debug((Object)"I/O exception shutting down connection", (Throwable)iOException);
                }
            }
            this.conn = null;
        }
    }

    private void checkExpiry() {
        if (this.conn != null && System.currentTimeMillis() >= this.expiry) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Connection expired @ " + new Date(this.expiry)));
            }
            this.closeConnection();
        }
    }

    synchronized HttpClientConnection getConnection(HttpRoute httpRoute, Object object) {
        Asserts.check((!this.isShutdown.get() ? 1 : 0) != 0, (String)"Connection manager has been shut down");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Get connection for route " + httpRoute));
        }
        Asserts.check((!this.leased ? 1 : 0) != 0, (String)"Connection is still allocated");
        if (!LangUtils.equals((Object)this.route, (Object)httpRoute) || !LangUtils.equals((Object)this.state, (Object)object)) {
            this.closeConnection();
        }
        this.route = httpRoute;
        this.state = object;
        this.checkExpiry();
        if (this.conn == null) {
            this.conn = this.connFactory.create(httpRoute, this.connConfig);
        }
        this.leased = true;
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void releaseConnection(HttpClientConnection httpClientConnection, Object object, long l, TimeUnit timeUnit) {
        Args.notNull((Object)httpClientConnection, (String)"Connection");
        Asserts.check((httpClientConnection == this.conn ? 1 : 0) != 0, (String)"Connection not obtained from this manager");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Releasing connection " + httpClientConnection));
        }
        if (this.isShutdown.get()) {
            return;
        }
        try {
            this.updated = System.currentTimeMillis();
            if (!this.conn.isOpen()) {
                this.conn = null;
                this.route = null;
                this.conn = null;
                this.expiry = Long.MAX_VALUE;
            } else {
                this.state = object;
                if (this.log.isDebugEnabled()) {
                    String string = l > 0L ? "for " + l + " " + (Object)((Object)timeUnit) : "indefinitely";
                    this.log.debug((Object)("Connection can be kept alive " + string));
                }
                this.expiry = l > 0L ? this.updated + timeUnit.toMillis(l) : Long.MAX_VALUE;
            }
        }
        finally {
            this.leased = false;
        }
    }

    @Override
    public void connect(HttpClientConnection httpClientConnection, HttpRoute httpRoute, int n, HttpContext httpContext) throws IOException {
        Args.notNull((Object)httpClientConnection, (String)"Connection");
        Args.notNull((Object)httpRoute, (String)"HTTP route");
        Asserts.check((httpClientConnection == this.conn ? 1 : 0) != 0, (String)"Connection not obtained from this manager");
        HttpHost httpHost = httpRoute.getProxyHost() != null ? httpRoute.getProxyHost() : httpRoute.getTargetHost();
        InetSocketAddress inetSocketAddress = httpRoute.getLocalSocketAddress();
        this.connectionOperator.connect(this.conn, httpHost, inetSocketAddress, n, this.socketConfig, httpContext);
    }

    @Override
    public void upgrade(HttpClientConnection httpClientConnection, HttpRoute httpRoute, HttpContext httpContext) throws IOException {
        Args.notNull((Object)httpClientConnection, (String)"Connection");
        Args.notNull((Object)httpRoute, (String)"HTTP route");
        Asserts.check((httpClientConnection == this.conn ? 1 : 0) != 0, (String)"Connection not obtained from this manager");
        this.connectionOperator.upgrade(this.conn, httpRoute.getTargetHost(), httpContext);
    }

    @Override
    public void routeComplete(HttpClientConnection httpClientConnection, HttpRoute httpRoute, HttpContext httpContext) throws IOException {
    }

    @Override
    public synchronized void closeExpiredConnections() {
        if (this.isShutdown.get()) {
            return;
        }
        if (!this.leased) {
            this.checkExpiry();
        }
    }

    @Override
    public synchronized void closeIdleConnections(long l, TimeUnit timeUnit) {
        Args.notNull((Object)((Object)timeUnit), (String)"Time unit");
        if (this.isShutdown.get()) {
            return;
        }
        if (!this.leased) {
            long l2;
            long l3 = timeUnit.toMillis(l);
            if (l3 < 0L) {
                l3 = 0L;
            }
            if (this.updated <= (l2 = System.currentTimeMillis() - l3)) {
                this.closeConnection();
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.isShutdown.compareAndSet(false, true)) {
            this.shutdownConnection();
        }
    }
}

