/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.conn;

import com.icbc.api.internal.apache.http.annotation.ThreadSafe;
import com.icbc.api.internal.apache.http.conn.ManagedHttpClientConnection;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.impl.conn.CPoolEntry;
import com.icbc.api.internal.apache.http.pool.AbstractConnPool;
import com.icbc.api.internal.apache.http.pool.ConnFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
class CPool
extends AbstractConnPool<HttpRoute, ManagedHttpClientConnection, CPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final Log log = LogFactory.getLog(CPool.class);
    private final long timeToLive;
    private final TimeUnit tunit;

    public CPool(ConnFactory<HttpRoute, ManagedHttpClientConnection> connFactory, int n, int n2, long l, TimeUnit timeUnit) {
        super(connFactory, n, n2);
        this.timeToLive = l;
        this.tunit = timeUnit;
    }

    @Override
    protected CPoolEntry createEntry(HttpRoute httpRoute, ManagedHttpClientConnection managedHttpClientConnection) {
        String string = Long.toString(COUNTER.getAndIncrement());
        return new CPoolEntry(this.log, string, httpRoute, managedHttpClientConnection, this.timeToLive, this.tunit);
    }

    @Override
    protected boolean validate(CPoolEntry cPoolEntry) {
        return !((ManagedHttpClientConnection)cPoolEntry.getConnection()).isStale();
    }
}

