/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.conn;

import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.annotation.NotThreadSafe;
import com.icbc.api.internal.apache.http.conn.params.ConnRouteParams;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoutePlanner;
import com.icbc.api.internal.apache.http.conn.scheme.Scheme;
import com.icbc.api.internal.apache.http.conn.scheme.SchemeRegistry;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

@Deprecated
@NotThreadSafe
public class ProxySelectorRoutePlanner
implements HttpRoutePlanner {
    protected final SchemeRegistry schemeRegistry;
    protected ProxySelector proxySelector;

    public ProxySelectorRoutePlanner(SchemeRegistry schemeRegistry, ProxySelector proxySelector) {
        Args.notNull((Object)schemeRegistry, (String)"SchemeRegistry");
        this.schemeRegistry = schemeRegistry;
        this.proxySelector = proxySelector;
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public void setProxySelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
    }

    @Override
    public HttpRoute determineRoute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        Args.notNull((Object)httpRequest, (String)"HTTP request");
        HttpRoute httpRoute = ConnRouteParams.getForcedRoute(httpRequest.getParams());
        if (httpRoute != null) {
            return httpRoute;
        }
        Asserts.notNull((Object)httpHost, (String)"Target host");
        InetAddress inetAddress = ConnRouteParams.getLocalAddress(httpRequest.getParams());
        HttpHost httpHost2 = this.determineProxy(httpHost, httpRequest, httpContext);
        Scheme scheme = this.schemeRegistry.getScheme(httpHost.getSchemeName());
        boolean bl = scheme.isLayered();
        httpRoute = httpHost2 == null ? new HttpRoute(httpHost, inetAddress, bl) : new HttpRoute(httpHost, inetAddress, httpHost2, bl);
        return httpRoute;
    }

    protected HttpHost determineProxy(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        ProxySelector proxySelector = this.proxySelector;
        if (proxySelector == null) {
            proxySelector = ProxySelector.getDefault();
        }
        if (proxySelector == null) {
            return null;
        }
        URI uRI = null;
        try {
            uRI = new URI(httpHost.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new HttpException("Cannot convert host to URI: " + httpHost, uRISyntaxException);
        }
        List<Proxy> list = proxySelector.select(uRI);
        Proxy proxy = this.chooseProxy(list, httpHost, httpRequest, httpContext);
        HttpHost httpHost2 = null;
        if (proxy.type() == Proxy.Type.HTTP) {
            if (!(proxy.address() instanceof InetSocketAddress)) {
                throw new HttpException("Unable to handle non-Inet proxy address: " + proxy.address());
            }
            InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
            httpHost2 = new HttpHost(this.getHost(inetSocketAddress), inetSocketAddress.getPort());
        }
        return httpHost2;
    }

    protected String getHost(InetSocketAddress inetSocketAddress) {
        return inetSocketAddress.isUnresolved() ? inetSocketAddress.getHostName() : inetSocketAddress.getAddress().getHostAddress();
    }

    protected Proxy chooseProxy(List<Proxy> list, HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) {
        Args.notEmpty(list, (String)"List of proxies");
        Proxy proxy = null;
        block3: for (int i = 0; proxy == null && i < list.size(); ++i) {
            Proxy proxy2 = list.get(i);
            switch (proxy2.type()) {
                case DIRECT: 
                case HTTP: {
                    proxy = proxy2;
                    continue block3;
                }
            }
        }
        if (proxy == null) {
            proxy = Proxy.NO_PROXY;
        }
        return proxy;
    }
}

