/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.conn;

import com.icbc.api.internal.apache.http.annotation.GuardedBy;
import com.icbc.api.internal.apache.http.annotation.ThreadSafe;
import com.icbc.api.internal.apache.http.conn.ClientConnectionManager;
import com.icbc.api.internal.apache.http.conn.ClientConnectionOperator;
import com.icbc.api.internal.apache.http.conn.ClientConnectionRequest;
import com.icbc.api.internal.apache.http.conn.ManagedClientConnection;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.conn.routing.RouteTracker;
import com.icbc.api.internal.apache.http.conn.scheme.SchemeRegistry;
import com.icbc.api.internal.apache.http.impl.conn.AbstractPoolEntry;
import com.icbc.api.internal.apache.http.impl.conn.AbstractPooledConnAdapter;
import com.icbc.api.internal.apache.http.impl.conn.DefaultClientConnectionOperator;
import com.icbc.api.internal.apache.http.impl.conn.SchemeRegistryFactory;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.Asserts;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
@ThreadSafe
public class SingleClientConnManager
implements ClientConnectionManager {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String MISUSE_MESSAGE = "Invalid use of SingleClientConnManager: connection still allocated.\nMake sure to release the connection before allocating another one.";
    protected final SchemeRegistry schemeRegistry;
    protected final ClientConnectionOperator connOperator;
    protected final boolean alwaysShutDown;
    @GuardedBy(value="this")
    protected volatile PoolEntry uniquePoolEntry;
    @GuardedBy(value="this")
    protected volatile ConnAdapter managedConn;
    @GuardedBy(value="this")
    protected volatile long lastReleaseTime;
    @GuardedBy(value="this")
    protected volatile long connectionExpiresTime;
    protected volatile boolean isShutDown;

    @Deprecated
    public SingleClientConnManager(HttpParams httpParams, SchemeRegistry schemeRegistry) {
        this(schemeRegistry);
    }

    public SingleClientConnManager(SchemeRegistry schemeRegistry) {
        Args.notNull((Object)schemeRegistry, (String)"Scheme registry");
        this.schemeRegistry = schemeRegistry;
        this.connOperator = this.createConnectionOperator(schemeRegistry);
        this.uniquePoolEntry = new PoolEntry();
        this.managedConn = null;
        this.lastReleaseTime = -1L;
        this.alwaysShutDown = false;
        this.isShutDown = false;
    }

    public SingleClientConnManager() {
        this(SchemeRegistryFactory.createDefault());
    }

    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public SchemeRegistry getSchemeRegistry() {
        return this.schemeRegistry;
    }

    protected ClientConnectionOperator createConnectionOperator(SchemeRegistry schemeRegistry) {
        return new DefaultClientConnectionOperator(schemeRegistry);
    }

    protected final void assertStillUp() throws IllegalStateException {
        Asserts.check((!this.isShutDown ? 1 : 0) != 0, (String)"Manager is shut down");
    }

    @Override
    public final ClientConnectionRequest requestConnection(final HttpRoute httpRoute, final Object object) {
        return new ClientConnectionRequest(){

            @Override
            public void abortRequest() {
            }

            @Override
            public ManagedClientConnection getConnection(long l, TimeUnit timeUnit) {
                return SingleClientConnManager.this.getConnection(httpRoute, object);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedClientConnection getConnection(HttpRoute httpRoute, Object object) {
        Args.notNull((Object)httpRoute, (String)"Route");
        this.assertStillUp();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Get connection for route " + httpRoute));
        }
        SingleClientConnManager singleClientConnManager = this;
        synchronized (singleClientConnManager) {
            Asserts.check((this.managedConn == null ? 1 : 0) != 0, (String)MISUSE_MESSAGE);
            boolean bl = false;
            boolean bl2 = false;
            this.closeExpiredConnections();
            if (this.uniquePoolEntry.connection.isOpen()) {
                RouteTracker routeTracker = this.uniquePoolEntry.tracker;
                bl2 = routeTracker == null || !routeTracker.toRoute().equals(httpRoute);
            } else {
                bl = true;
            }
            if (bl2) {
                bl = true;
                try {
                    this.uniquePoolEntry.shutdown();
                }
                catch (IOException iOException) {
                    this.log.debug((Object)"Problem shutting down connection.", (Throwable)iOException);
                }
            }
            if (bl) {
                this.uniquePoolEntry = new PoolEntry();
            }
            this.managedConn = new ConnAdapter(this.uniquePoolEntry, httpRoute);
            return this.managedConn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection(ManagedClientConnection managedClientConnection, long l, TimeUnit timeUnit) {
        ConnAdapter connAdapter;
        Args.check((boolean)(managedClientConnection instanceof ConnAdapter), (String)"Connection class mismatch, connection not obtained from this manager");
        this.assertStillUp();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Releasing connection " + managedClientConnection));
        }
        ConnAdapter connAdapter2 = connAdapter = (ConnAdapter)managedClientConnection;
        synchronized (connAdapter2) {
            if (connAdapter.poolEntry == null) {
                return;
            }
            ClientConnectionManager clientConnectionManager = connAdapter.getManager();
            Asserts.check((clientConnectionManager == this ? 1 : 0) != 0, (String)"Connection not obtained from this manager");
            try {
                if (connAdapter.isOpen() && (this.alwaysShutDown || !connAdapter.isMarkedReusable())) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Released connection open but not reusable.");
                    }
                    connAdapter.shutdown();
                }
            }
            catch (IOException iOException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Exception shutting down released connection.", (Throwable)iOException);
                }
            }
            finally {
                connAdapter.detach();
                SingleClientConnManager singleClientConnManager = this;
                synchronized (singleClientConnManager) {
                    this.managedConn = null;
                    this.lastReleaseTime = System.currentTimeMillis();
                    this.connectionExpiresTime = l > 0L ? timeUnit.toMillis(l) + this.lastReleaseTime : Long.MAX_VALUE;
                }
            }
        }
    }

    @Override
    public void closeExpiredConnections() {
        long l = this.connectionExpiresTime;
        if (System.currentTimeMillis() >= l) {
            this.closeIdleConnections(0L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeIdleConnections(long l, TimeUnit timeUnit) {
        this.assertStillUp();
        Args.notNull((Object)((Object)timeUnit), (String)"Time unit");
        SingleClientConnManager singleClientConnManager = this;
        synchronized (singleClientConnManager) {
            long l2;
            if (this.managedConn == null && this.uniquePoolEntry.connection.isOpen() && this.lastReleaseTime <= (l2 = System.currentTimeMillis() - timeUnit.toMillis(l))) {
                try {
                    this.uniquePoolEntry.close();
                }
                catch (IOException iOException) {
                    this.log.debug((Object)"Problem closing idle connection.", (Throwable)iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.isShutDown = true;
        SingleClientConnManager singleClientConnManager = this;
        synchronized (singleClientConnManager) {
            try {
                if (this.uniquePoolEntry != null) {
                    this.uniquePoolEntry.shutdown();
                }
            }
            catch (IOException iOException) {
                this.log.debug((Object)"Problem while shutting down manager.", (Throwable)iOException);
            }
            finally {
                this.uniquePoolEntry = null;
                this.managedConn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void revokeConnection() {
        ConnAdapter connAdapter = this.managedConn;
        if (connAdapter == null) {
            return;
        }
        connAdapter.detach();
        SingleClientConnManager singleClientConnManager = this;
        synchronized (singleClientConnManager) {
            try {
                this.uniquePoolEntry.shutdown();
            }
            catch (IOException iOException) {
                this.log.debug((Object)"Problem while shutting down connection.", (Throwable)iOException);
            }
        }
    }

    protected class ConnAdapter
    extends AbstractPooledConnAdapter {
        protected ConnAdapter(PoolEntry poolEntry, HttpRoute httpRoute) {
            super((ClientConnectionManager)SingleClientConnManager.this, poolEntry);
            this.markReusable();
            poolEntry.route = httpRoute;
        }
    }

    protected class PoolEntry
    extends AbstractPoolEntry {
        protected PoolEntry() {
            super(SingleClientConnManager.this.connOperator, null);
        }

        protected void close() throws IOException {
            this.shutdownEntry();
            if (this.connection.isOpen()) {
                this.connection.close();
            }
        }

        protected void shutdown() throws IOException {
            this.shutdownEntry();
            if (this.connection.isOpen()) {
                this.connection.shutdown();
            }
        }
    }
}

