/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.cookie;

import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.cookie.CommonCookieAttributeHandler;
import com.icbc.api.internal.apache.http.cookie.Cookie;
import com.icbc.api.internal.apache.http.cookie.CookieOrigin;
import com.icbc.api.internal.apache.http.cookie.CookieRestrictionViolationException;
import com.icbc.api.internal.apache.http.cookie.MalformedCookieException;
import com.icbc.api.internal.apache.http.cookie.SetCookie;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.TextUtils;

@Immutable
public class BasicPathHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull((Object)setCookie, (String)"Cookie");
        setCookie.setPath(!TextUtils.isBlank((CharSequence)string) ? string : "/");
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        if (!this.match(cookie, cookieOrigin)) {
            throw new CookieRestrictionViolationException("Illegal 'path' attribute \"" + cookie.getPath() + "\". Path of origin: \"" + cookieOrigin.getPath() + "\"");
        }
    }

    static boolean pathMatch(String string, String string2) {
        String string3 = string2;
        if (string3 == null) {
            string3 = "/";
        }
        if (string3.length() > 1 && string3.endsWith("/")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if (string.startsWith(string3)) {
            if (string3.equals("/")) {
                return true;
            }
            if (string.length() == string3.length()) {
                return true;
            }
            if (string.charAt(string3.length()) == '/') {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        Args.notNull((Object)cookie, (String)"Cookie");
        Args.notNull((Object)cookieOrigin, (String)"Cookie origin");
        return BasicPathHandler.pathMatch(cookieOrigin.getPath(), cookie.getPath());
    }

    @Override
    public String getAttributeName() {
        return "path";
    }
}

