/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.cookie;

import com.icbc.api.internal.apache.http.FormattedHeader;
import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.HeaderElement;
import com.icbc.api.internal.apache.http.annotation.ThreadSafe;
import com.icbc.api.internal.apache.http.cookie.CommonCookieAttributeHandler;
import com.icbc.api.internal.apache.http.cookie.Cookie;
import com.icbc.api.internal.apache.http.cookie.CookieOrigin;
import com.icbc.api.internal.apache.http.cookie.CookieSpec;
import com.icbc.api.internal.apache.http.cookie.MalformedCookieException;
import com.icbc.api.internal.apache.http.cookie.SetCookie2;
import com.icbc.api.internal.apache.http.impl.cookie.BasicCommentHandler;
import com.icbc.api.internal.apache.http.impl.cookie.BasicDomainHandler;
import com.icbc.api.internal.apache.http.impl.cookie.BasicExpiresHandler;
import com.icbc.api.internal.apache.http.impl.cookie.BasicMaxAgeHandler;
import com.icbc.api.internal.apache.http.impl.cookie.BasicPathHandler;
import com.icbc.api.internal.apache.http.impl.cookie.BasicSecureHandler;
import com.icbc.api.internal.apache.http.impl.cookie.NetscapeDraftHeaderParser;
import com.icbc.api.internal.apache.http.impl.cookie.NetscapeDraftSpec;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2109DomainHandler;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2109Spec;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2109VersionHandler;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2965CommentUrlAttributeHandler;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2965DiscardAttributeHandler;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2965DomainAttributeHandler;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2965PortAttributeHandler;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2965Spec;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2965VersionAttributeHandler;
import com.icbc.api.internal.apache.http.message.ParserCursor;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.CharArrayBuffer;
import java.util.List;

@ThreadSafe
public class DefaultCookieSpec
implements CookieSpec {
    private final RFC2965Spec strict;
    private final RFC2109Spec obsoleteStrict;
    private final NetscapeDraftSpec netscapeDraft;

    DefaultCookieSpec(RFC2965Spec rFC2965Spec, RFC2109Spec rFC2109Spec, NetscapeDraftSpec netscapeDraftSpec) {
        this.strict = rFC2965Spec;
        this.obsoleteStrict = rFC2109Spec;
        this.netscapeDraft = netscapeDraftSpec;
    }

    public DefaultCookieSpec(String[] stringArray, boolean bl) {
        String[] stringArray2;
        this.strict = new RFC2965Spec(bl, new RFC2965VersionAttributeHandler(), new BasicPathHandler(), new RFC2965DomainAttributeHandler(), new RFC2965PortAttributeHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler(), new RFC2965CommentUrlAttributeHandler(), new RFC2965DiscardAttributeHandler());
        this.obsoleteStrict = new RFC2109Spec(bl, new RFC2109VersionHandler(), new BasicPathHandler(), new RFC2109DomainHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler());
        CommonCookieAttributeHandler[] commonCookieAttributeHandlerArray = new CommonCookieAttributeHandler[5];
        commonCookieAttributeHandlerArray[0] = new BasicDomainHandler();
        commonCookieAttributeHandlerArray[1] = new BasicPathHandler();
        commonCookieAttributeHandlerArray[2] = new BasicSecureHandler();
        commonCookieAttributeHandlerArray[3] = new BasicCommentHandler();
        if (stringArray != null) {
            stringArray2 = (String[])stringArray.clone();
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = "EEE, dd-MMM-yy HH:mm:ss z";
        }
        commonCookieAttributeHandlerArray[4] = new BasicExpiresHandler(stringArray2);
        this.netscapeDraft = new NetscapeDraftSpec(commonCookieAttributeHandlerArray);
    }

    public DefaultCookieSpec() {
        this(null, false);
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull((Object)header, (String)"Header");
        Args.notNull((Object)cookieOrigin, (String)"Cookie origin");
        HeaderElement[] headerElementArray = header.getElements();
        boolean bl = false;
        boolean bl2 = false;
        for (HeaderElement object : headerElementArray) {
            if (object.getParameterByName("version") != null) {
                bl = true;
            }
            if (object.getParameterByName("expires") == null) continue;
            bl2 = true;
        }
        if (bl2 || !bl) {
            ParserCursor parserCursor;
            CharArrayBuffer charArrayBuffer;
            NetscapeDraftHeaderParser netscapeDraftHeaderParser = NetscapeDraftHeaderParser.DEFAULT;
            if (header instanceof FormattedHeader) {
                charArrayBuffer = ((FormattedHeader)header).getBuffer();
                parserCursor = new ParserCursor(((FormattedHeader)header).getValuePos(), charArrayBuffer.length());
            } else {
                String string = header.getValue();
                if (string == null) {
                    throw new MalformedCookieException("Header value is null");
                }
                charArrayBuffer = new CharArrayBuffer(string.length());
                charArrayBuffer.append(string);
                parserCursor = new ParserCursor(0, charArrayBuffer.length());
            }
            headerElementArray = new HeaderElement[]{netscapeDraftHeaderParser.parseHeader(charArrayBuffer, parserCursor)};
            return this.netscapeDraft.parse(headerElementArray, cookieOrigin);
        }
        if ("Set-Cookie2".equals(header.getName())) {
            return this.strict.parse(headerElementArray, cookieOrigin);
        }
        return this.obsoleteStrict.parse(headerElementArray, cookieOrigin);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull((Object)cookie, (String)"Cookie");
        Args.notNull((Object)cookieOrigin, (String)"Cookie origin");
        if (cookie.getVersion() > 0) {
            if (cookie instanceof SetCookie2) {
                this.strict.validate(cookie, cookieOrigin);
            } else {
                this.obsoleteStrict.validate(cookie, cookieOrigin);
            }
        } else {
            this.netscapeDraft.validate(cookie, cookieOrigin);
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        Args.notNull((Object)cookie, (String)"Cookie");
        Args.notNull((Object)cookieOrigin, (String)"Cookie origin");
        if (cookie.getVersion() > 0) {
            if (cookie instanceof SetCookie2) {
                return this.strict.match(cookie, cookieOrigin);
            }
            return this.obsoleteStrict.match(cookie, cookieOrigin);
        }
        return this.netscapeDraft.match(cookie, cookieOrigin);
    }

    @Override
    public List<Header> formatCookies(List<Cookie> list) {
        Args.notNull(list, (String)"List of cookies");
        int n = Integer.MAX_VALUE;
        boolean bl = true;
        for (Cookie cookie : list) {
            if (!(cookie instanceof SetCookie2)) {
                bl = false;
            }
            if (cookie.getVersion() >= n) continue;
            n = cookie.getVersion();
        }
        if (n > 0) {
            if (bl) {
                return this.strict.formatCookies(list);
            }
            return this.obsoleteStrict.formatCookies(list);
        }
        return this.netscapeDraft.formatCookies(list);
    }

    @Override
    public int getVersion() {
        return this.strict.getVersion();
    }

    @Override
    public Header getVersionHeader() {
        return null;
    }

    public String toString() {
        return "default";
    }
}

