/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.cookie;

import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.cookie.CommonCookieAttributeHandler;
import com.icbc.api.internal.apache.http.cookie.MalformedCookieException;
import com.icbc.api.internal.apache.http.cookie.SetCookie;
import com.icbc.api.internal.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.TextUtils;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Immutable
public class LaxMaxAgeHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private static final Pattern MAX_AGE_PATTERN = Pattern.compile("^\\-?[0-9]+$");

    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull((Object)setCookie, (String)"Cookie");
        if (TextUtils.isBlank((CharSequence)string)) {
            return;
        }
        Matcher matcher = MAX_AGE_PATTERN.matcher(string);
        if (matcher.matches()) {
            int n;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            Date date = n >= 0 ? new Date(System.currentTimeMillis() + (long)n * 1000L) : new Date(Long.MIN_VALUE);
            setCookie.setExpiryDate(date);
        }
    }

    @Override
    public String getAttributeName() {
        return "max-age";
    }
}

