/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.cookie;

import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.cookie.Cookie;
import com.icbc.api.internal.apache.http.cookie.CookieOrigin;
import com.icbc.api.internal.apache.http.cookie.CookieRestrictionViolationException;
import com.icbc.api.internal.apache.http.cookie.MalformedCookieException;
import com.icbc.api.internal.apache.http.cookie.SetCookie;
import com.icbc.api.internal.apache.http.impl.cookie.BasicDomainHandler;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.TextUtils;
import java.util.Locale;
import java.util.StringTokenizer;

@Immutable
public class NetscapeDomainHandler
extends BasicDomainHandler {
    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull((Object)setCookie, (String)"Cookie");
        if (TextUtils.isBlank((CharSequence)string)) {
            throw new MalformedCookieException("Blank or null value for domain attribute");
        }
        setCookie.setDomain(string);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        String string;
        String string2 = cookieOrigin.getHost();
        if (!string2.equals(string = cookie.getDomain()) && !BasicDomainHandler.domainMatch(string, string2)) {
            throw new CookieRestrictionViolationException("Illegal domain attribute \"" + string + "\". Domain of origin: \"" + string2 + "\"");
        }
        if (string2.contains(".")) {
            int n = new StringTokenizer(string, ".").countTokens();
            if (NetscapeDomainHandler.isSpecialDomain(string)) {
                if (n < 2) {
                    throw new CookieRestrictionViolationException("Domain attribute \"" + string + "\" violates the Netscape cookie specification for special domains");
                }
            } else if (n < 3) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + string + "\" violates the Netscape cookie specification");
            }
        }
    }

    private static boolean isSpecialDomain(String string) {
        String string2 = string.toUpperCase(Locale.ROOT);
        return string2.endsWith(".COM") || string2.endsWith(".EDU") || string2.endsWith(".NET") || string2.endsWith(".GOV") || string2.endsWith(".MIL") || string2.endsWith(".ORG") || string2.endsWith(".INT");
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        Args.notNull((Object)cookie, (String)"Cookie");
        Args.notNull((Object)cookieOrigin, (String)"Cookie origin");
        String string = cookieOrigin.getHost();
        String string2 = cookie.getDomain();
        if (string2 == null) {
            return false;
        }
        return string.endsWith(string2);
    }

    @Override
    public String getAttributeName() {
        return "domain";
    }
}

