/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.cookie;

import com.icbc.api.internal.apache.http.HeaderElement;
import com.icbc.api.internal.apache.http.NameValuePair;
import com.icbc.api.internal.apache.http.ParseException;
import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.message.BasicHeaderElement;
import com.icbc.api.internal.apache.http.message.BasicNameValuePair;
import com.icbc.api.internal.apache.http.message.ParserCursor;
import com.icbc.api.internal.apache.http.message.TokenParser;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.CharArrayBuffer;
import java.util.ArrayList;
import java.util.BitSet;

@Immutable
public class NetscapeDraftHeaderParser {
    public static final NetscapeDraftHeaderParser DEFAULT = new NetscapeDraftHeaderParser();
    private static final char PARAM_DELIMITER = ';';
    private static final BitSet TOKEN_DELIMS = TokenParser.INIT_BITSET(61, 59);
    private static final BitSet VALUE_DELIMS = TokenParser.INIT_BITSET(59);
    private final TokenParser tokenParser = TokenParser.INSTANCE;

    public HeaderElement parseHeader(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) throws ParseException {
        Args.notNull((Object)charArrayBuffer, (String)"Char array buffer");
        Args.notNull((Object)parserCursor, (String)"Parser cursor");
        NameValuePair nameValuePair = this.parseNameValuePair(charArrayBuffer, parserCursor);
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        while (!parserCursor.atEnd()) {
            NameValuePair nameValuePair2 = this.parseNameValuePair(charArrayBuffer, parserCursor);
            arrayList.add(nameValuePair2);
        }
        return new BasicHeaderElement(nameValuePair.getName(), nameValuePair.getValue(), arrayList.toArray(new NameValuePair[arrayList.size()]));
    }

    private NameValuePair parseNameValuePair(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        String string = this.tokenParser.parseToken(charArrayBuffer, parserCursor, TOKEN_DELIMS);
        if (parserCursor.atEnd()) {
            return new BasicNameValuePair(string, null);
        }
        char c2 = charArrayBuffer.charAt(parserCursor.getPos());
        parserCursor.updatePos(parserCursor.getPos() + 1);
        if (c2 != '=') {
            return new BasicNameValuePair(string, null);
        }
        String string2 = this.tokenParser.parseToken(charArrayBuffer, parserCursor, VALUE_DELIMS);
        if (!parserCursor.atEnd()) {
            parserCursor.updatePos(parserCursor.getPos() + 1);
        }
        return new BasicNameValuePair(string, string2);
    }
}

