/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.cookie;

import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.HeaderElement;
import com.icbc.api.internal.apache.http.annotation.Obsolete;
import com.icbc.api.internal.apache.http.annotation.ThreadSafe;
import com.icbc.api.internal.apache.http.cookie.ClientCookie;
import com.icbc.api.internal.apache.http.cookie.CommonCookieAttributeHandler;
import com.icbc.api.internal.apache.http.cookie.Cookie;
import com.icbc.api.internal.apache.http.cookie.CookieOrigin;
import com.icbc.api.internal.apache.http.cookie.CookiePathComparator;
import com.icbc.api.internal.apache.http.cookie.CookieRestrictionViolationException;
import com.icbc.api.internal.apache.http.cookie.MalformedCookieException;
import com.icbc.api.internal.apache.http.impl.cookie.BasicCommentHandler;
import com.icbc.api.internal.apache.http.impl.cookie.BasicExpiresHandler;
import com.icbc.api.internal.apache.http.impl.cookie.BasicMaxAgeHandler;
import com.icbc.api.internal.apache.http.impl.cookie.BasicPathHandler;
import com.icbc.api.internal.apache.http.impl.cookie.BasicSecureHandler;
import com.icbc.api.internal.apache.http.impl.cookie.CookieSpecBase;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2109DomainHandler;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2109VersionHandler;
import com.icbc.api.internal.apache.http.message.BufferedHeader;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.CharArrayBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Obsolete
@ThreadSafe
public class RFC2109Spec
extends CookieSpecBase {
    static final String[] DATE_PATTERNS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy"};
    private final boolean oneHeader;

    public RFC2109Spec(String[] stringArray, boolean bl) {
        super(new RFC2109VersionHandler(), new BasicPathHandler(), new RFC2109DomainHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler(), new BasicExpiresHandler(stringArray != null ? (String[])stringArray.clone() : DATE_PATTERNS));
        this.oneHeader = bl;
    }

    public RFC2109Spec() {
        this(null, false);
    }

    protected RFC2109Spec(boolean bl, CommonCookieAttributeHandler ... commonCookieAttributeHandlerArray) {
        super(commonCookieAttributeHandlerArray);
        this.oneHeader = bl;
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull((Object)header, (String)"Header");
        Args.notNull((Object)cookieOrigin, (String)"Cookie origin");
        if (!header.getName().equalsIgnoreCase("Set-Cookie")) {
            throw new MalformedCookieException("Unrecognized cookie header '" + header.toString() + "'");
        }
        HeaderElement[] headerElementArray = header.getElements();
        return this.parse(headerElementArray, cookieOrigin);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull((Object)cookie, (String)"Cookie");
        String string = cookie.getName();
        if (string.indexOf(32) != -1) {
            throw new CookieRestrictionViolationException("Cookie name may not contain blanks");
        }
        if (string.startsWith("$")) {
            throw new CookieRestrictionViolationException("Cookie name may not start with $");
        }
        super.validate(cookie, cookieOrigin);
    }

    @Override
    public List<Header> formatCookies(List<Cookie> list) {
        List<Cookie> list2;
        Args.notEmpty(list, (String)"List of cookies");
        if (list.size() > 1) {
            list2 = new ArrayList<Cookie>(list);
            Collections.sort(list2, CookiePathComparator.INSTANCE);
        } else {
            list2 = list;
        }
        if (this.oneHeader) {
            return this.doFormatOneHeader(list2);
        }
        return this.doFormatManyHeaders(list2);
    }

    private List<Header> doFormatOneHeader(List<Cookie> list) {
        int n = Integer.MAX_VALUE;
        for (Cookie object2 : list) {
            if (object2.getVersion() >= n) continue;
            n = object2.getVersion();
        }
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(40 * list.size());
        charArrayBuffer.append("Cookie");
        charArrayBuffer.append(": ");
        charArrayBuffer.append("$Version=");
        charArrayBuffer.append(Integer.toString(n));
        for (Cookie cookie : list) {
            charArrayBuffer.append("; ");
            Cookie cookie2 = cookie;
            this.formatCookieAsVer(charArrayBuffer, cookie2, n);
        }
        ArrayList<Header> arrayList = new ArrayList<Header>(1);
        arrayList.add(new BufferedHeader(charArrayBuffer));
        return arrayList;
    }

    private List<Header> doFormatManyHeaders(List<Cookie> list) {
        ArrayList<Header> arrayList = new ArrayList<Header>(list.size());
        for (Cookie cookie : list) {
            int n = cookie.getVersion();
            CharArrayBuffer charArrayBuffer = new CharArrayBuffer(40);
            charArrayBuffer.append("Cookie: ");
            charArrayBuffer.append("$Version=");
            charArrayBuffer.append(Integer.toString(n));
            charArrayBuffer.append("; ");
            this.formatCookieAsVer(charArrayBuffer, cookie, n);
            arrayList.add(new BufferedHeader(charArrayBuffer));
        }
        return arrayList;
    }

    protected void formatParamAsVer(CharArrayBuffer charArrayBuffer, String string, String string2, int n) {
        charArrayBuffer.append(string);
        charArrayBuffer.append("=");
        if (string2 != null) {
            if (n > 0) {
                charArrayBuffer.append('\"');
                charArrayBuffer.append(string2);
                charArrayBuffer.append('\"');
            } else {
                charArrayBuffer.append(string2);
            }
        }
    }

    protected void formatCookieAsVer(CharArrayBuffer charArrayBuffer, Cookie cookie, int n) {
        this.formatParamAsVer(charArrayBuffer, cookie.getName(), cookie.getValue(), n);
        if (cookie.getPath() != null && cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("path")) {
            charArrayBuffer.append("; ");
            this.formatParamAsVer(charArrayBuffer, "$Path", cookie.getPath(), n);
        }
        if (cookie.getDomain() != null && cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("domain")) {
            charArrayBuffer.append("; ");
            this.formatParamAsVer(charArrayBuffer, "$Domain", cookie.getDomain(), n);
        }
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public Header getVersionHeader() {
        return null;
    }

    public String toString() {
        return "rfc2109";
    }
}

