/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.cookie;

import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.cookie.ClientCookie;
import com.icbc.api.internal.apache.http.cookie.CommonCookieAttributeHandler;
import com.icbc.api.internal.apache.http.cookie.Cookie;
import com.icbc.api.internal.apache.http.cookie.CookieOrigin;
import com.icbc.api.internal.apache.http.cookie.CookieRestrictionViolationException;
import com.icbc.api.internal.apache.http.cookie.MalformedCookieException;
import com.icbc.api.internal.apache.http.cookie.SetCookie;
import com.icbc.api.internal.apache.http.cookie.SetCookie2;
import com.icbc.api.internal.apache.http.util.Args;
import java.util.StringTokenizer;

@Immutable
public class RFC2965PortAttributeHandler
implements CommonCookieAttributeHandler {
    private static int[] parsePortAttribute(String string) throws MalformedCookieException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[stringTokenizer.countTokens()];
        try {
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                nArray[n] = Integer.parseInt(stringTokenizer.nextToken().trim());
                if (nArray[n] < 0) {
                    throw new MalformedCookieException("Invalid Port attribute.");
                }
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedCookieException("Invalid Port attribute: " + numberFormatException.getMessage());
        }
        return nArray;
    }

    private static boolean portMatch(int n, int[] nArray) {
        boolean bl = false;
        for (int n2 : nArray) {
            if (n != n2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull((Object)setCookie, (String)"Cookie");
        if (setCookie instanceof SetCookie2) {
            SetCookie2 setCookie2 = (SetCookie2)setCookie;
            if (string != null && !string.trim().isEmpty()) {
                int[] nArray = RFC2965PortAttributeHandler.parsePortAttribute(string);
                setCookie2.setPorts(nArray);
            }
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull((Object)cookie, (String)"Cookie");
        Args.notNull((Object)cookieOrigin, (String)"Cookie origin");
        int n = cookieOrigin.getPort();
        if (cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("port") && !RFC2965PortAttributeHandler.portMatch(n, cookie.getPorts())) {
            throw new CookieRestrictionViolationException("Port attribute violates RFC 2965: Request port not found in cookie's port list.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        Args.notNull((Object)cookie, (String)"Cookie");
        Args.notNull((Object)cookieOrigin, (String)"Cookie origin");
        int n = cookieOrigin.getPort();
        if (cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("port")) {
            if (cookie.getPorts() == null) {
                return false;
            }
            if (!RFC2965PortAttributeHandler.portMatch(n, cookie.getPorts())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getAttributeName() {
        return "port";
    }
}

