/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.entity;

import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpMessage;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.entity.ContentLengthStrategy;
import com.icbc.api.internal.apache.http.impl.io.ChunkedOutputStream;
import com.icbc.api.internal.apache.http.impl.io.ContentLengthOutputStream;
import com.icbc.api.internal.apache.http.impl.io.IdentityOutputStream;
import com.icbc.api.internal.apache.http.io.SessionOutputBuffer;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.io.OutputStream;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class EntitySerializer {
    private final ContentLengthStrategy lenStrategy;

    public EntitySerializer(ContentLengthStrategy contentLengthStrategy) {
        this.lenStrategy = (ContentLengthStrategy)Args.notNull((Object)contentLengthStrategy, (String)"Content length strategy");
    }

    protected OutputStream doSerialize(SessionOutputBuffer sessionOutputBuffer, HttpMessage httpMessage) throws HttpException, IOException {
        long l = this.lenStrategy.determineLength(httpMessage);
        if (l == -2L) {
            return new ChunkedOutputStream(sessionOutputBuffer);
        }
        if (l == -1L) {
            return new IdentityOutputStream(sessionOutputBuffer);
        }
        return new ContentLengthOutputStream(sessionOutputBuffer, l);
    }

    public void serialize(SessionOutputBuffer sessionOutputBuffer, HttpMessage httpMessage, HttpEntity httpEntity) throws HttpException, IOException {
        Args.notNull((Object)sessionOutputBuffer, (String)"Session output buffer");
        Args.notNull((Object)httpMessage, (String)"HTTP message");
        Args.notNull((Object)httpEntity, (String)"HTTP entity");
        OutputStream outputStream = this.doSerialize(sessionOutputBuffer, httpMessage);
        httpEntity.writeTo(outputStream);
        outputStream.close();
    }
}

