/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.execchain;

import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.client.BackoffManager;
import com.icbc.api.internal.apache.http.client.ConnectionBackoffStrategy;
import com.icbc.api.internal.apache.http.client.methods.CloseableHttpResponse;
import com.icbc.api.internal.apache.http.client.methods.HttpExecutionAware;
import com.icbc.api.internal.apache.http.client.methods.HttpRequestWrapper;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.impl.execchain.ClientExecChain;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;

@Immutable
public class BackoffStrategyExec
implements ClientExecChain {
    private final ClientExecChain requestExecutor;
    private final ConnectionBackoffStrategy connectionBackoffStrategy;
    private final BackoffManager backoffManager;

    public BackoffStrategyExec(ClientExecChain clientExecChain, ConnectionBackoffStrategy connectionBackoffStrategy, BackoffManager backoffManager) {
        Args.notNull((Object)clientExecChain, (String)"HTTP client request executor");
        Args.notNull((Object)connectionBackoffStrategy, (String)"Connection backoff strategy");
        Args.notNull((Object)backoffManager, (String)"Backoff manager");
        this.requestExecutor = clientExecChain;
        this.connectionBackoffStrategy = connectionBackoffStrategy;
        this.backoffManager = backoffManager;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        Args.notNull((Object)httpRoute, (String)"HTTP route");
        Args.notNull((Object)httpRequestWrapper, (String)"HTTP request");
        Args.notNull((Object)httpClientContext, (String)"HTTP context");
        Closeable closeable = null;
        try {
            closeable = this.requestExecutor.execute(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
        }
        catch (Exception exception) {
            if (closeable != null) {
                closeable.close();
            }
            if (this.connectionBackoffStrategy.shouldBackoff(exception)) {
                this.backoffManager.backOff(httpRoute);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof HttpException) {
                throw (HttpException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        if (this.connectionBackoffStrategy.shouldBackoff((HttpResponse)((Object)closeable))) {
            this.backoffManager.backOff(httpRoute);
        } else {
            this.backoffManager.probe(httpRoute);
        }
        return closeable;
    }
}

