/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.execchain;

import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.NoHttpResponseException;
import com.icbc.api.internal.apache.http.annotation.Immutable;
import com.icbc.api.internal.apache.http.client.HttpRequestRetryHandler;
import com.icbc.api.internal.apache.http.client.NonRepeatableRequestException;
import com.icbc.api.internal.apache.http.client.methods.CloseableHttpResponse;
import com.icbc.api.internal.apache.http.client.methods.HttpExecutionAware;
import com.icbc.api.internal.apache.http.client.methods.HttpRequestWrapper;
import com.icbc.api.internal.apache.http.client.protocol.HttpClientContext;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoute;
import com.icbc.api.internal.apache.http.impl.execchain.ClientExecChain;
import com.icbc.api.internal.apache.http.impl.execchain.RequestEntityProxy;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Immutable
public class RetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final HttpRequestRetryHandler retryHandler;

    public RetryExec(ClientExecChain clientExecChain, HttpRequestRetryHandler httpRequestRetryHandler) {
        Args.notNull((Object)clientExecChain, (String)"HTTP request executor");
        Args.notNull((Object)httpRequestRetryHandler, (String)"HTTP request retry handler");
        this.requestExecutor = clientExecChain;
        this.retryHandler = httpRequestRetryHandler;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        Args.notNull((Object)httpRoute, (String)"HTTP route");
        Args.notNull((Object)httpRequestWrapper, (String)"HTTP request");
        Args.notNull((Object)httpClientContext, (String)"HTTP context");
        Header[] headerArray = httpRequestWrapper.getAllHeaders();
        int n = 1;
        while (true) {
            try {
                return this.requestExecutor.execute(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
            }
            catch (IOException iOException) {
                if (httpExecutionAware != null && httpExecutionAware.isAborted()) {
                    this.log.debug((Object)"Request has been aborted");
                    throw iOException;
                }
                if (this.retryHandler.retryRequest(iOException, n, httpClientContext)) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("I/O exception (" + iOException.getClass().getName() + ") caught when processing request to " + httpRoute + ": " + iOException.getMessage()));
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)iOException.getMessage(), (Throwable)iOException);
                    }
                    if (!RequestEntityProxy.isRepeatable(httpRequestWrapper)) {
                        this.log.debug((Object)"Cannot retry non-repeatable request");
                        throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity", iOException);
                    }
                    httpRequestWrapper.setHeaders(headerArray);
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("Retrying request to " + httpRoute));
                    }
                } else {
                    if (iOException instanceof NoHttpResponseException) {
                        NoHttpResponseException noHttpResponseException = new NoHttpResponseException(httpRoute.getTargetHost().toHostString() + " failed to respond");
                        noHttpResponseException.setStackTrace(iOException.getStackTrace());
                        throw noHttpResponseException;
                    }
                    throw iOException;
                }
                ++n;
                continue;
            }
            break;
        }
    }
}

