/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.io;

import com.icbc.api.internal.apache.http.io.SessionOutputBuffer;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.io.OutputStream;

public class IdentityOutputStream
extends OutputStream {
    private final SessionOutputBuffer out;
    private boolean closed = false;

    public IdentityOutputStream(SessionOutputBuffer sessionOutputBuffer) {
        this.out = (SessionOutputBuffer)Args.notNull((Object)sessionOutputBuffer, (String)"Session output buffer");
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.out.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        this.out.write(byArray, n, n2);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        this.out.write(n);
    }
}

