/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio;

import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpEntityEnclosingRequest;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.HttpResponseFactory;
import com.icbc.api.internal.apache.http.config.MessageConstraints;
import com.icbc.api.internal.apache.http.entity.ContentLengthStrategy;
import com.icbc.api.internal.apache.http.impl.nio.NHttpClientEventHandlerAdaptor;
import com.icbc.api.internal.apache.http.impl.nio.NHttpConnectionBase;
import com.icbc.api.internal.apache.http.impl.nio.codecs.DefaultHttpRequestWriter;
import com.icbc.api.internal.apache.http.impl.nio.codecs.DefaultHttpRequestWriterFactory;
import com.icbc.api.internal.apache.http.impl.nio.codecs.DefaultHttpResponseParser;
import com.icbc.api.internal.apache.http.impl.nio.codecs.DefaultHttpResponseParserFactory;
import com.icbc.api.internal.apache.http.nio.NHttpClientEventHandler;
import com.icbc.api.internal.apache.http.nio.NHttpClientHandler;
import com.icbc.api.internal.apache.http.nio.NHttpClientIOTarget;
import com.icbc.api.internal.apache.http.nio.NHttpMessageParser;
import com.icbc.api.internal.apache.http.nio.NHttpMessageParserFactory;
import com.icbc.api.internal.apache.http.nio.NHttpMessageWriter;
import com.icbc.api.internal.apache.http.nio.NHttpMessageWriterFactory;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.reactor.SessionInputBuffer;
import com.icbc.api.internal.apache.http.nio.reactor.SessionOutputBuffer;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.params.HttpParamConfig;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class DefaultNHttpClientConnection
extends NHttpConnectionBase
implements NHttpClientIOTarget {
    protected final NHttpMessageParser<HttpResponse> responseParser;
    protected final NHttpMessageWriter<HttpRequest> requestWriter;

    @Deprecated
    public DefaultNHttpClientConnection(IOSession iOSession, HttpResponseFactory httpResponseFactory, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        super(iOSession, byteBufferAllocator, httpParams);
        Args.notNull((Object)httpResponseFactory, (String)"Response factory");
        this.responseParser = this.createResponseParser(this.inbuf, httpResponseFactory, httpParams);
        this.requestWriter = this.createRequestWriter(this.outbuf, httpParams);
        this.hasBufferedInput = false;
        this.hasBufferedOutput = false;
        this.session.setBufferStatus(this);
    }

    public DefaultNHttpClientConnection(IOSession iOSession, int n, int n2, ByteBufferAllocator byteBufferAllocator, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder, MessageConstraints messageConstraints, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, NHttpMessageWriterFactory<HttpRequest> defaultHttpRequestWriterFactory, NHttpMessageParserFactory<HttpResponse> defaultHttpResponseParserFactory) {
        super(iOSession, n, n2, byteBufferAllocator, charsetDecoder, charsetEncoder, messageConstraints, contentLengthStrategy, contentLengthStrategy2);
        this.requestWriter = (defaultHttpRequestWriterFactory != null ? defaultHttpRequestWriterFactory : DefaultHttpRequestWriterFactory.INSTANCE).create(this.outbuf);
        this.responseParser = (defaultHttpResponseParserFactory != null ? defaultHttpResponseParserFactory : DefaultHttpResponseParserFactory.INSTANCE).create(this.inbuf, messageConstraints);
    }

    public DefaultNHttpClientConnection(IOSession iOSession, int n, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder, MessageConstraints messageConstraints) {
        this(iOSession, n, n, null, charsetDecoder, charsetEncoder, messageConstraints, null, null, null, null);
    }

    public DefaultNHttpClientConnection(IOSession iOSession, int n) {
        this(iOSession, n, n, null, null, null, null, null, null, null, null);
    }

    @Deprecated
    protected NHttpMessageParser<HttpResponse> createResponseParser(SessionInputBuffer sessionInputBuffer, HttpResponseFactory httpResponseFactory, HttpParams httpParams) {
        MessageConstraints messageConstraints = HttpParamConfig.getMessageConstraints(httpParams);
        return new DefaultHttpResponseParser(sessionInputBuffer, null, httpResponseFactory, messageConstraints);
    }

    @Deprecated
    protected NHttpMessageWriter<HttpRequest> createRequestWriter(SessionOutputBuffer sessionOutputBuffer, HttpParams httpParams) {
        return new DefaultHttpRequestWriter(sessionOutputBuffer, null);
    }

    protected void onResponseReceived(HttpResponse httpResponse) {
    }

    protected void onRequestSubmitted(HttpRequest httpRequest) {
    }

    @Override
    public void resetInput() {
        this.response = null;
        this.contentDecoder = null;
        this.responseParser.reset();
    }

    @Override
    public void resetOutput() {
        this.request = null;
        this.contentEncoder = null;
        this.requestWriter.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeInput(NHttpClientEventHandler nHttpClientEventHandler) {
        if (this.status != 0) {
            this.session.clearEvent(1);
            return;
        }
        try {
            if (this.response == null) {
                int n;
                do {
                    if ((n = this.responseParser.fillBuffer(this.session.channel())) > 0) {
                        this.inTransportMetrics.incrementBytesTransferred(n);
                    }
                    this.response = this.responseParser.parse();
                } while (n > 0 && this.response == null);
                if (this.response != null) {
                    if (this.response.getStatusLine().getStatusCode() >= 200) {
                        HttpEntity httpEntity = this.prepareDecoder(this.response);
                        this.response.setEntity(httpEntity);
                        this.connMetrics.incrementResponseCount();
                    }
                    this.hasBufferedInput = this.inbuf.hasData();
                    this.onResponseReceived(this.response);
                    nHttpClientEventHandler.responseReceived(this);
                    if (this.contentDecoder == null) {
                        this.resetInput();
                    }
                }
                if (n == -1 && !this.inbuf.hasData()) {
                    nHttpClientEventHandler.endOfInput(this);
                }
            }
            if (this.contentDecoder != null && (this.session.getEventMask() & 1) > 0) {
                nHttpClientEventHandler.inputReady(this, this.contentDecoder);
                if (this.contentDecoder.isCompleted()) {
                    this.resetInput();
                }
            }
        }
        catch (HttpException httpException) {
            this.resetInput();
            nHttpClientEventHandler.exception(this, httpException);
        }
        catch (Exception exception) {
            nHttpClientEventHandler.exception(this, exception);
        }
        finally {
            this.hasBufferedInput = this.inbuf.hasData();
        }
    }

    public void produceOutput(NHttpClientEventHandler nHttpClientEventHandler) {
        try {
            int n;
            if (this.status == 0) {
                if (this.contentEncoder == null && !this.outbuf.hasData()) {
                    nHttpClientEventHandler.requestReady(this);
                }
                if (this.contentEncoder != null) {
                    nHttpClientEventHandler.outputReady(this, this.contentEncoder);
                    if (this.contentEncoder.isCompleted()) {
                        this.resetOutput();
                    }
                }
            }
            if (this.outbuf.hasData() && (n = this.outbuf.flush(this.session.channel())) > 0) {
                this.outTransportMetrics.incrementBytesTransferred(n);
            }
            if (!this.outbuf.hasData() && this.status == 1) {
                this.session.close();
                this.status = 2;
                this.resetOutput();
            }
        }
        catch (Exception exception) {
            nHttpClientEventHandler.exception(this, exception);
        }
        finally {
            this.hasBufferedOutput = this.outbuf.hasData();
        }
    }

    @Override
    public void submitRequest(HttpRequest httpRequest) throws IOException, HttpException {
        Args.notNull((Object)httpRequest, (String)"HTTP request");
        this.assertNotClosed();
        if (this.request != null) {
            throw new HttpException("Request already submitted");
        }
        this.onRequestSubmitted(httpRequest);
        this.requestWriter.write(httpRequest);
        this.hasBufferedOutput = this.outbuf.hasData();
        if (httpRequest instanceof HttpEntityEnclosingRequest && ((HttpEntityEnclosingRequest)httpRequest).getEntity() != null) {
            this.prepareEncoder(httpRequest);
            this.request = httpRequest;
        }
        this.connMetrics.incrementRequestCount();
        this.session.setEvent(4);
    }

    @Override
    public boolean isRequestSubmitted() {
        return this.request != null;
    }

    @Override
    public void consumeInput(NHttpClientHandler nHttpClientHandler) {
        this.consumeInput(new NHttpClientEventHandlerAdaptor(nHttpClientHandler));
    }

    @Override
    public void produceOutput(NHttpClientHandler nHttpClientHandler) {
        this.produceOutput(new NHttpClientEventHandlerAdaptor(nHttpClientHandler));
    }
}

