/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio;

import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.HttpEntityEnclosingRequest;
import com.icbc.api.internal.apache.http.HttpException;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpRequestFactory;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.config.MessageConstraints;
import com.icbc.api.internal.apache.http.entity.ContentLengthStrategy;
import com.icbc.api.internal.apache.http.impl.entity.DisallowIdentityContentLengthStrategy;
import com.icbc.api.internal.apache.http.impl.entity.LaxContentLengthStrategy;
import com.icbc.api.internal.apache.http.impl.entity.StrictContentLengthStrategy;
import com.icbc.api.internal.apache.http.impl.nio.NHttpConnectionBase;
import com.icbc.api.internal.apache.http.impl.nio.NHttpServerEventHandlerAdaptor;
import com.icbc.api.internal.apache.http.impl.nio.codecs.DefaultHttpRequestParser;
import com.icbc.api.internal.apache.http.impl.nio.codecs.DefaultHttpRequestParserFactory;
import com.icbc.api.internal.apache.http.impl.nio.codecs.DefaultHttpResponseWriter;
import com.icbc.api.internal.apache.http.impl.nio.codecs.DefaultHttpResponseWriterFactory;
import com.icbc.api.internal.apache.http.nio.NHttpMessageParser;
import com.icbc.api.internal.apache.http.nio.NHttpMessageParserFactory;
import com.icbc.api.internal.apache.http.nio.NHttpMessageWriter;
import com.icbc.api.internal.apache.http.nio.NHttpMessageWriterFactory;
import com.icbc.api.internal.apache.http.nio.NHttpServerEventHandler;
import com.icbc.api.internal.apache.http.nio.NHttpServerIOTarget;
import com.icbc.api.internal.apache.http.nio.NHttpServiceHandler;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.reactor.SessionInputBuffer;
import com.icbc.api.internal.apache.http.nio.reactor.SessionOutputBuffer;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.params.HttpParamConfig;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class DefaultNHttpServerConnection
extends NHttpConnectionBase
implements NHttpServerIOTarget {
    protected final NHttpMessageParser<HttpRequest> requestParser;
    protected final NHttpMessageWriter<HttpResponse> responseWriter;

    @Deprecated
    public DefaultNHttpServerConnection(IOSession iOSession, HttpRequestFactory httpRequestFactory, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        super(iOSession, byteBufferAllocator, httpParams);
        Args.notNull((Object)httpRequestFactory, (String)"Request factory");
        this.requestParser = this.createRequestParser(this.inbuf, httpRequestFactory, httpParams);
        this.responseWriter = this.createResponseWriter(this.outbuf, httpParams);
    }

    public DefaultNHttpServerConnection(IOSession iOSession, int n, int n2, ByteBufferAllocator byteBufferAllocator, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder, MessageConstraints messageConstraints, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, NHttpMessageParserFactory<HttpRequest> defaultHttpRequestParserFactory, NHttpMessageWriterFactory<HttpResponse> defaultHttpResponseWriterFactory) {
        super(iOSession, n, n2, byteBufferAllocator, charsetDecoder, charsetEncoder, messageConstraints, contentLengthStrategy != null ? contentLengthStrategy : DisallowIdentityContentLengthStrategy.INSTANCE, contentLengthStrategy2 != null ? contentLengthStrategy2 : StrictContentLengthStrategy.INSTANCE);
        this.requestParser = (defaultHttpRequestParserFactory != null ? defaultHttpRequestParserFactory : DefaultHttpRequestParserFactory.INSTANCE).create(this.inbuf, messageConstraints);
        this.responseWriter = (defaultHttpResponseWriterFactory != null ? defaultHttpResponseWriterFactory : DefaultHttpResponseWriterFactory.INSTANCE).create(this.outbuf);
    }

    public DefaultNHttpServerConnection(IOSession iOSession, int n, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder, MessageConstraints messageConstraints) {
        this(iOSession, n, n, null, charsetDecoder, charsetEncoder, messageConstraints, null, null, null, null);
    }

    public DefaultNHttpServerConnection(IOSession iOSession, int n) {
        this(iOSession, n, n, null, null, null, null, null, null, null, null);
    }

    @Override
    @Deprecated
    protected ContentLengthStrategy createIncomingContentStrategy() {
        return new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    }

    @Deprecated
    protected NHttpMessageParser<HttpRequest> createRequestParser(SessionInputBuffer sessionInputBuffer, HttpRequestFactory httpRequestFactory, HttpParams httpParams) {
        MessageConstraints messageConstraints = HttpParamConfig.getMessageConstraints(httpParams);
        return new DefaultHttpRequestParser(sessionInputBuffer, null, httpRequestFactory, messageConstraints);
    }

    @Deprecated
    protected NHttpMessageWriter<HttpResponse> createResponseWriter(SessionOutputBuffer sessionOutputBuffer, HttpParams httpParams) {
        return new DefaultHttpResponseWriter(sessionOutputBuffer, null);
    }

    protected void onRequestReceived(HttpRequest httpRequest) {
    }

    protected void onResponseSubmitted(HttpResponse httpResponse) {
    }

    @Override
    public void resetInput() {
        this.request = null;
        this.contentDecoder = null;
        this.requestParser.reset();
    }

    @Override
    public void resetOutput() {
        this.response = null;
        this.contentEncoder = null;
        this.responseWriter.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeInput(NHttpServerEventHandler nHttpServerEventHandler) {
        if (this.status != 0) {
            this.session.clearEvent(1);
            return;
        }
        try {
            if (this.request == null) {
                int n;
                do {
                    if ((n = this.requestParser.fillBuffer(this.session.channel())) > 0) {
                        this.inTransportMetrics.incrementBytesTransferred(n);
                    }
                    this.request = this.requestParser.parse();
                } while (n > 0 && this.request == null);
                if (this.request != null) {
                    if (this.request instanceof HttpEntityEnclosingRequest) {
                        HttpEntity httpEntity = this.prepareDecoder(this.request);
                        ((HttpEntityEnclosingRequest)this.request).setEntity(httpEntity);
                    }
                    this.connMetrics.incrementRequestCount();
                    this.hasBufferedInput = this.inbuf.hasData();
                    this.onRequestReceived(this.request);
                    nHttpServerEventHandler.requestReceived(this);
                    if (this.contentDecoder == null) {
                        this.resetInput();
                    }
                }
                if (n == -1 && !this.inbuf.hasData()) {
                    nHttpServerEventHandler.endOfInput(this);
                }
            }
            if (this.contentDecoder != null && (this.session.getEventMask() & 1) > 0) {
                nHttpServerEventHandler.inputReady(this, this.contentDecoder);
                if (this.contentDecoder.isCompleted()) {
                    this.resetInput();
                }
            }
        }
        catch (HttpException httpException) {
            this.resetInput();
            nHttpServerEventHandler.exception(this, httpException);
        }
        catch (Exception exception) {
            nHttpServerEventHandler.exception(this, exception);
        }
        finally {
            this.hasBufferedInput = this.inbuf.hasData();
        }
    }

    public void produceOutput(NHttpServerEventHandler nHttpServerEventHandler) {
        try {
            int n;
            if (this.status == 0) {
                if (this.contentEncoder == null && !this.outbuf.hasData()) {
                    nHttpServerEventHandler.responseReady(this);
                }
                if (this.contentEncoder != null) {
                    nHttpServerEventHandler.outputReady(this, this.contentEncoder);
                    if (this.contentEncoder.isCompleted()) {
                        this.resetOutput();
                    }
                }
            }
            if (this.outbuf.hasData() && (n = this.outbuf.flush(this.session.channel())) > 0) {
                this.outTransportMetrics.incrementBytesTransferred(n);
            }
            if (!this.outbuf.hasData() && this.status == 1) {
                this.session.close();
                this.status = 2;
                this.resetOutput();
            }
        }
        catch (Exception exception) {
            nHttpServerEventHandler.exception(this, exception);
        }
        finally {
            this.hasBufferedOutput = this.outbuf.hasData();
        }
    }

    @Override
    public void submitResponse(HttpResponse httpResponse) throws IOException, HttpException {
        Args.notNull((Object)httpResponse, (String)"HTTP response");
        this.assertNotClosed();
        if (this.response != null) {
            throw new HttpException("Response already submitted");
        }
        this.onResponseSubmitted(httpResponse);
        this.responseWriter.write(httpResponse);
        this.hasBufferedOutput = this.outbuf.hasData();
        if (httpResponse.getStatusLine().getStatusCode() >= 200) {
            this.connMetrics.incrementResponseCount();
            if (httpResponse.getEntity() != null) {
                this.response = httpResponse;
                this.prepareEncoder(httpResponse);
            }
        }
        this.session.setEvent(4);
    }

    @Override
    public boolean isResponseSubmitted() {
        return this.response != null;
    }

    @Override
    public void consumeInput(NHttpServiceHandler nHttpServiceHandler) {
        this.consumeInput(new NHttpServerEventHandlerAdaptor(nHttpServiceHandler));
    }

    @Override
    public void produceOutput(NHttpServiceHandler nHttpServiceHandler) {
        this.produceOutput(new NHttpServerEventHandlerAdaptor(nHttpServiceHandler));
    }
}

