/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio;

import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpRequestFactory;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.config.ConnectionConfig;
import com.icbc.api.internal.apache.http.entity.ContentLengthStrategy;
import com.icbc.api.internal.apache.http.impl.ConnSupport;
import com.icbc.api.internal.apache.http.impl.DefaultHttpRequestFactory;
import com.icbc.api.internal.apache.http.impl.nio.DefaultNHttpServerConnection;
import com.icbc.api.internal.apache.http.impl.nio.codecs.DefaultHttpRequestParserFactory;
import com.icbc.api.internal.apache.http.nio.NHttpConnectionFactory;
import com.icbc.api.internal.apache.http.nio.NHttpMessageParserFactory;
import com.icbc.api.internal.apache.http.nio.NHttpMessageWriterFactory;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import com.icbc.api.internal.apache.http.params.HttpParamConfig;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultNHttpServerConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpServerConnection> {
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final NHttpMessageParserFactory<HttpRequest> requestParserFactory;
    private final NHttpMessageWriterFactory<HttpResponse> responseWriterFactory;
    private final ByteBufferAllocator allocator;
    private final ConnectionConfig cconfig;

    @Deprecated
    public DefaultNHttpServerConnectionFactory(HttpRequestFactory httpRequestFactory, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        Args.notNull((Object)httpRequestFactory, (String)"HTTP request factory");
        Args.notNull((Object)byteBufferAllocator, (String)"Byte buffer allocator");
        Args.notNull((Object)httpParams, (String)"HTTP parameters");
        this.incomingContentStrategy = null;
        this.outgoingContentStrategy = null;
        this.requestParserFactory = new DefaultHttpRequestParserFactory(null, httpRequestFactory);
        this.responseWriterFactory = null;
        this.allocator = byteBufferAllocator;
        this.cconfig = HttpParamConfig.getConnectionConfig(httpParams);
    }

    @Deprecated
    public DefaultNHttpServerConnectionFactory(HttpParams httpParams) {
        this(DefaultHttpRequestFactory.INSTANCE, (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE, httpParams);
    }

    @Deprecated
    protected DefaultNHttpServerConnection createConnection(IOSession iOSession, HttpRequestFactory httpRequestFactory, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        return new DefaultNHttpServerConnection(iOSession, httpRequestFactory, byteBufferAllocator, httpParams);
    }

    public DefaultNHttpServerConnectionFactory(ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, NHttpMessageParserFactory<HttpRequest> nHttpMessageParserFactory, NHttpMessageWriterFactory<HttpResponse> nHttpMessageWriterFactory, ByteBufferAllocator byteBufferAllocator, ConnectionConfig connectionConfig) {
        this.incomingContentStrategy = contentLengthStrategy;
        this.outgoingContentStrategy = contentLengthStrategy2;
        this.requestParserFactory = nHttpMessageParserFactory;
        this.responseWriterFactory = nHttpMessageWriterFactory;
        this.allocator = byteBufferAllocator;
        this.cconfig = connectionConfig != null ? connectionConfig : ConnectionConfig.DEFAULT;
    }

    public DefaultNHttpServerConnectionFactory(ByteBufferAllocator byteBufferAllocator, NHttpMessageParserFactory<HttpRequest> nHttpMessageParserFactory, NHttpMessageWriterFactory<HttpResponse> nHttpMessageWriterFactory, ConnectionConfig connectionConfig) {
        this(null, null, nHttpMessageParserFactory, nHttpMessageWriterFactory, byteBufferAllocator, connectionConfig);
    }

    public DefaultNHttpServerConnectionFactory(ConnectionConfig connectionConfig) {
        this(null, null, null, null, null, connectionConfig);
    }

    public DefaultNHttpServerConnectionFactory() {
        this(null, null, null, null, null, null);
    }

    @Override
    public DefaultNHttpServerConnection createConnection(IOSession iOSession) {
        return new DefaultNHttpServerConnection(iOSession, this.cconfig.getBufferSize(), this.cconfig.getFragmentSizeHint(), this.allocator, ConnSupport.createDecoder(this.cconfig), ConnSupport.createEncoder(this.cconfig), this.cconfig.getMessageConstraints(), this.incomingContentStrategy, this.outgoingContentStrategy, this.requestParserFactory, this.responseWriterFactory);
    }
}

