/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio;

import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.HttpResponseFactory;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.config.ConnectionConfig;
import com.icbc.api.internal.apache.http.entity.ContentLengthStrategy;
import com.icbc.api.internal.apache.http.impl.ConnSupport;
import com.icbc.api.internal.apache.http.impl.DefaultHttpResponseFactory;
import com.icbc.api.internal.apache.http.impl.nio.DefaultNHttpClientConnection;
import com.icbc.api.internal.apache.http.impl.nio.codecs.DefaultHttpResponseParserFactory;
import com.icbc.api.internal.apache.http.nio.NHttpConnectionFactory;
import com.icbc.api.internal.apache.http.nio.NHttpMessageParserFactory;
import com.icbc.api.internal.apache.http.nio.NHttpMessageWriterFactory;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLIOSession;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLMode;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLSetupHandler;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import com.icbc.api.internal.apache.http.params.HttpParamConfig;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.ssl.SSLContexts;
import com.icbc.api.internal.apache.http.util.Args;
import javax.net.ssl.SSLContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class SSLNHttpClientConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpClientConnection> {
    public static final SSLNHttpClientConnectionFactory INSTANCE = new SSLNHttpClientConnectionFactory();
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final NHttpMessageParserFactory<HttpResponse> responseParserFactory;
    private final NHttpMessageWriterFactory<HttpRequest> requestWriterFactory;
    private final ByteBufferAllocator allocator;
    private final SSLContext sslcontext;
    private final SSLSetupHandler sslHandler;
    private final ConnectionConfig cconfig;

    @Deprecated
    public SSLNHttpClientConnectionFactory(SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, HttpResponseFactory httpResponseFactory, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        Args.notNull((Object)httpResponseFactory, (String)"HTTP response factory");
        Args.notNull((Object)byteBufferAllocator, (String)"Byte buffer allocator");
        Args.notNull((Object)httpParams, (String)"HTTP parameters");
        this.sslcontext = sSLContext != null ? sSLContext : SSLContexts.createSystemDefault();
        this.sslHandler = sSLSetupHandler;
        this.allocator = byteBufferAllocator;
        this.incomingContentStrategy = null;
        this.outgoingContentStrategy = null;
        this.responseParserFactory = new DefaultHttpResponseParserFactory(null, httpResponseFactory);
        this.requestWriterFactory = null;
        this.cconfig = HttpParamConfig.getConnectionConfig(httpParams);
    }

    @Deprecated
    public SSLNHttpClientConnectionFactory(SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, HttpParams httpParams) {
        this(sSLContext, sSLSetupHandler, DefaultHttpResponseFactory.INSTANCE, (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE, httpParams);
    }

    @Deprecated
    public SSLNHttpClientConnectionFactory(HttpParams httpParams) {
        this(null, null, httpParams);
    }

    public SSLNHttpClientConnectionFactory(SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, NHttpMessageParserFactory<HttpResponse> nHttpMessageParserFactory, NHttpMessageWriterFactory<HttpRequest> nHttpMessageWriterFactory, ByteBufferAllocator byteBufferAllocator, ConnectionConfig connectionConfig) {
        this.sslcontext = sSLContext != null ? sSLContext : SSLContexts.createSystemDefault();
        this.sslHandler = sSLSetupHandler;
        this.incomingContentStrategy = contentLengthStrategy;
        this.outgoingContentStrategy = contentLengthStrategy2;
        this.responseParserFactory = nHttpMessageParserFactory;
        this.requestWriterFactory = nHttpMessageWriterFactory;
        this.allocator = byteBufferAllocator;
        this.cconfig = connectionConfig != null ? connectionConfig : ConnectionConfig.DEFAULT;
    }

    public SSLNHttpClientConnectionFactory(SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, NHttpMessageParserFactory<HttpResponse> nHttpMessageParserFactory, NHttpMessageWriterFactory<HttpRequest> nHttpMessageWriterFactory, ByteBufferAllocator byteBufferAllocator, ConnectionConfig connectionConfig) {
        this(sSLContext, sSLSetupHandler, null, null, nHttpMessageParserFactory, nHttpMessageWriterFactory, byteBufferAllocator, connectionConfig);
    }

    public SSLNHttpClientConnectionFactory(SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, NHttpMessageParserFactory<HttpResponse> nHttpMessageParserFactory, NHttpMessageWriterFactory<HttpRequest> nHttpMessageWriterFactory, ConnectionConfig connectionConfig) {
        this(sSLContext, sSLSetupHandler, null, null, nHttpMessageParserFactory, nHttpMessageWriterFactory, null, connectionConfig);
    }

    public SSLNHttpClientConnectionFactory(SSLContext sSLContext, SSLSetupHandler sSLSetupHandler, ConnectionConfig connectionConfig) {
        this(sSLContext, sSLSetupHandler, null, null, null, null, null, connectionConfig);
    }

    public SSLNHttpClientConnectionFactory(ConnectionConfig connectionConfig) {
        this(null, null, null, null, null, null, null, connectionConfig);
    }

    public SSLNHttpClientConnectionFactory() {
        this(null, null, null, null, null, null);
    }

    @Deprecated
    protected DefaultNHttpClientConnection createConnection(IOSession iOSession, HttpResponseFactory httpResponseFactory, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        return new DefaultNHttpClientConnection(iOSession, httpResponseFactory, byteBufferAllocator, httpParams);
    }

    protected SSLIOSession createSSLIOSession(IOSession iOSession, SSLContext sSLContext, SSLSetupHandler sSLSetupHandler) {
        SSLIOSession sSLIOSession = new SSLIOSession(iOSession, SSLMode.CLIENT, sSLContext, sSLSetupHandler);
        return sSLIOSession;
    }

    @Override
    public DefaultNHttpClientConnection createConnection(IOSession iOSession) {
        SSLIOSession sSLIOSession = this.createSSLIOSession(iOSession, this.sslcontext, this.sslHandler);
        iOSession.setAttribute("http.session.ssl", sSLIOSession);
        return new DefaultNHttpClientConnection(sSLIOSession, this.cconfig.getBufferSize(), this.cconfig.getFragmentSizeHint(), this.allocator, ConnSupport.createDecoder(this.cconfig), ConnSupport.createEncoder(this.cconfig), this.cconfig.getMessageConstraints(), this.incomingContentStrategy, this.outgoingContentStrategy, this.requestWriterFactory, this.responseParserFactory);
    }
}

