/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio;

import com.icbc.api.internal.apache.http.HttpRequestFactory;
import com.icbc.api.internal.apache.http.impl.DefaultHttpRequestFactory;
import com.icbc.api.internal.apache.http.impl.nio.DefaultNHttpServerConnection;
import com.icbc.api.internal.apache.http.impl.nio.reactor.SSLIOSession;
import com.icbc.api.internal.apache.http.impl.nio.reactor.SSLIOSessionHandler;
import com.icbc.api.internal.apache.http.impl.nio.reactor.SSLMode;
import com.icbc.api.internal.apache.http.nio.NHttpServerConnection;
import com.icbc.api.internal.apache.http.nio.NHttpServerIOTarget;
import com.icbc.api.internal.apache.http.nio.NHttpServiceHandler;
import com.icbc.api.internal.apache.http.nio.reactor.IOEventDispatch;
import com.icbc.api.internal.apache.http.nio.reactor.IOSession;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;

@Deprecated
public class SSLServerIOEventDispatch
implements IOEventDispatch {
    private static final String SSL_SESSION = "SSL_SESSION";
    protected final NHttpServiceHandler handler;
    protected final SSLContext sslcontext;
    protected final SSLIOSessionHandler sslHandler;
    protected final HttpParams params;

    public SSLServerIOEventDispatch(NHttpServiceHandler nHttpServiceHandler, SSLContext sSLContext, SSLIOSessionHandler sSLIOSessionHandler, HttpParams httpParams) {
        Args.notNull((Object)nHttpServiceHandler, (String)"HTTP service handler");
        Args.notNull((Object)sSLContext, (String)"SSL context");
        Args.notNull((Object)httpParams, (String)"HTTP parameters");
        this.handler = nHttpServiceHandler;
        this.params = httpParams;
        this.sslcontext = sSLContext;
        this.sslHandler = sSLIOSessionHandler;
    }

    public SSLServerIOEventDispatch(NHttpServiceHandler nHttpServiceHandler, SSLContext sSLContext, HttpParams httpParams) {
        this(nHttpServiceHandler, sSLContext, null, httpParams);
    }

    protected ByteBufferAllocator createByteBufferAllocator() {
        return HeapByteBufferAllocator.INSTANCE;
    }

    protected HttpRequestFactory createHttpRequestFactory() {
        return DefaultHttpRequestFactory.INSTANCE;
    }

    protected NHttpServerIOTarget createConnection(IOSession iOSession) {
        return new DefaultNHttpServerConnection(iOSession, this.createHttpRequestFactory(), this.createByteBufferAllocator(), this.params);
    }

    protected SSLIOSession createSSLIOSession(IOSession iOSession, SSLContext sSLContext, SSLIOSessionHandler sSLIOSessionHandler) {
        return new SSLIOSession(iOSession, sSLContext, sSLIOSessionHandler);
    }

    @Override
    public void connected(IOSession iOSession) {
        SSLIOSession sSLIOSession = this.createSSLIOSession(iOSession, this.sslcontext, this.sslHandler);
        NHttpServerIOTarget nHttpServerIOTarget = this.createConnection(sSLIOSession);
        iOSession.setAttribute("http.connection", nHttpServerIOTarget);
        iOSession.setAttribute(SSL_SESSION, sSLIOSession);
        this.handler.connected(nHttpServerIOTarget);
        try {
            sSLIOSession.bind(SSLMode.SERVER, this.params);
        }
        catch (SSLException sSLException) {
            this.handler.exception((NHttpServerConnection)nHttpServerIOTarget, sSLException);
            sSLIOSession.shutdown();
        }
    }

    @Override
    public void disconnected(IOSession iOSession) {
        NHttpServerIOTarget nHttpServerIOTarget = (NHttpServerIOTarget)iOSession.getAttribute("http.connection");
        if (nHttpServerIOTarget != null) {
            this.handler.closed(nHttpServerIOTarget);
        }
    }

    @Override
    public void inputReady(IOSession iOSession) {
        NHttpServerIOTarget nHttpServerIOTarget = (NHttpServerIOTarget)iOSession.getAttribute("http.connection");
        SSLIOSession sSLIOSession = (SSLIOSession)iOSession.getAttribute(SSL_SESSION);
        try {
            if (sSLIOSession.isAppInputReady()) {
                nHttpServerIOTarget.consumeInput(this.handler);
            }
            sSLIOSession.inboundTransport();
        }
        catch (IOException iOException) {
            this.handler.exception((NHttpServerConnection)nHttpServerIOTarget, iOException);
            sSLIOSession.shutdown();
        }
    }

    @Override
    public void outputReady(IOSession iOSession) {
        NHttpServerIOTarget nHttpServerIOTarget = (NHttpServerIOTarget)iOSession.getAttribute("http.connection");
        SSLIOSession sSLIOSession = (SSLIOSession)iOSession.getAttribute(SSL_SESSION);
        try {
            if (sSLIOSession.isAppOutputReady()) {
                nHttpServerIOTarget.produceOutput(this.handler);
            }
            sSLIOSession.outboundTransport();
        }
        catch (IOException iOException) {
            this.handler.exception((NHttpServerConnection)nHttpServerIOTarget, iOException);
            sSLIOSession.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeout(IOSession iOSession) {
        NHttpServerIOTarget nHttpServerIOTarget = (NHttpServerIOTarget)iOSession.getAttribute("http.connection");
        SSLIOSession sSLIOSession = (SSLIOSession)iOSession.getAttribute(SSL_SESSION);
        this.handler.timeout(nHttpServerIOTarget);
        SSLIOSession sSLIOSession2 = sSLIOSession;
        synchronized (sSLIOSession2) {
            if (sSLIOSession.isOutboundDone() && !sSLIOSession.isInboundDone()) {
                sSLIOSession.shutdown();
            }
        }
    }
}

