/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.bootstrap;

import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.ExceptionLogger;
import com.icbc.api.internal.apache.http.HttpRequestInterceptor;
import com.icbc.api.internal.apache.http.HttpResponseFactory;
import com.icbc.api.internal.apache.http.HttpResponseInterceptor;
import com.icbc.api.internal.apache.http.config.ConnectionConfig;
import com.icbc.api.internal.apache.http.impl.DefaultConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.impl.DefaultHttpResponseFactory;
import com.icbc.api.internal.apache.http.impl.nio.DefaultNHttpServerConnection;
import com.icbc.api.internal.apache.http.impl.nio.DefaultNHttpServerConnectionFactory;
import com.icbc.api.internal.apache.http.impl.nio.SSLNHttpServerConnectionFactory;
import com.icbc.api.internal.apache.http.impl.nio.bootstrap.HttpServer;
import com.icbc.api.internal.apache.http.impl.nio.reactor.IOReactorConfig;
import com.icbc.api.internal.apache.http.nio.NHttpConnectionFactory;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncExpectationVerifier;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestHandler;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestHandlerMapper;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncService;
import com.icbc.api.internal.apache.http.nio.protocol.UriHttpAsyncRequestHandlerMapper;
import com.icbc.api.internal.apache.http.nio.reactor.ssl.SSLSetupHandler;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import com.icbc.api.internal.apache.http.protocol.HttpProcessorBuilder;
import com.icbc.api.internal.apache.http.protocol.ResponseConnControl;
import com.icbc.api.internal.apache.http.protocol.ResponseContent;
import com.icbc.api.internal.apache.http.protocol.ResponseDate;
import com.icbc.api.internal.apache.http.protocol.ResponseServer;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.net.ssl.SSLContext;

public class ServerBootstrap {
    private int listenerPort;
    private InetAddress localAddress;
    private IOReactorConfig ioReactorConfig;
    private ConnectionConfig connectionConfig;
    private LinkedList<HttpRequestInterceptor> requestFirst;
    private LinkedList<HttpRequestInterceptor> requestLast;
    private LinkedList<HttpResponseInterceptor> responseFirst;
    private LinkedList<HttpResponseInterceptor> responseLast;
    private String serverInfo;
    private HttpProcessor httpProcessor;
    private ConnectionReuseStrategy connStrategy;
    private HttpResponseFactory responseFactory;
    private HttpAsyncRequestHandlerMapper handlerMapper;
    private Map<String, HttpAsyncRequestHandler<?>> handlerMap;
    private HttpAsyncExpectationVerifier expectationVerifier;
    private SSLContext sslContext;
    private SSLSetupHandler sslSetupHandler;
    private NHttpConnectionFactory<? extends DefaultNHttpServerConnection> connectionFactory;
    private ExceptionLogger exceptionLogger;

    private ServerBootstrap() {
    }

    public static ServerBootstrap bootstrap() {
        return new ServerBootstrap();
    }

    public final ServerBootstrap setListenerPort(int n) {
        this.listenerPort = n;
        return this;
    }

    public final ServerBootstrap setLocalAddress(InetAddress inetAddress) {
        this.localAddress = inetAddress;
        return this;
    }

    public final ServerBootstrap setIOReactorConfig(IOReactorConfig iOReactorConfig) {
        this.ioReactorConfig = iOReactorConfig;
        return this;
    }

    public final ServerBootstrap setConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
        return this;
    }

    public final ServerBootstrap setHttpProcessor(HttpProcessor httpProcessor) {
        this.httpProcessor = httpProcessor;
        return this;
    }

    public final ServerBootstrap addInterceptorFirst(HttpResponseInterceptor httpResponseInterceptor) {
        if (httpResponseInterceptor == null) {
            return this;
        }
        if (this.responseFirst == null) {
            this.responseFirst = new LinkedList();
        }
        this.responseFirst.addFirst(httpResponseInterceptor);
        return this;
    }

    public final ServerBootstrap addInterceptorLast(HttpResponseInterceptor httpResponseInterceptor) {
        if (httpResponseInterceptor == null) {
            return this;
        }
        if (this.responseLast == null) {
            this.responseLast = new LinkedList();
        }
        this.responseLast.addLast(httpResponseInterceptor);
        return this;
    }

    public final ServerBootstrap addInterceptorFirst(HttpRequestInterceptor httpRequestInterceptor) {
        if (httpRequestInterceptor == null) {
            return this;
        }
        if (this.requestFirst == null) {
            this.requestFirst = new LinkedList();
        }
        this.requestFirst.addFirst(httpRequestInterceptor);
        return this;
    }

    public final ServerBootstrap addInterceptorLast(HttpRequestInterceptor httpRequestInterceptor) {
        if (httpRequestInterceptor == null) {
            return this;
        }
        if (this.requestLast == null) {
            this.requestLast = new LinkedList();
        }
        this.requestLast.addLast(httpRequestInterceptor);
        return this;
    }

    public final ServerBootstrap setServerInfo(String string) {
        this.serverInfo = string;
        return this;
    }

    public final ServerBootstrap setConnectionReuseStrategy(ConnectionReuseStrategy connectionReuseStrategy) {
        this.connStrategy = connectionReuseStrategy;
        return this;
    }

    public final ServerBootstrap setResponseFactory(HttpResponseFactory httpResponseFactory) {
        this.responseFactory = httpResponseFactory;
        return this;
    }

    public final ServerBootstrap setHandlerMapper(HttpAsyncRequestHandlerMapper httpAsyncRequestHandlerMapper) {
        this.handlerMapper = httpAsyncRequestHandlerMapper;
        return this;
    }

    public final ServerBootstrap registerHandler(String string, HttpAsyncRequestHandler<?> httpAsyncRequestHandler) {
        if (string == null || httpAsyncRequestHandler == null) {
            return this;
        }
        if (this.handlerMap == null) {
            this.handlerMap = new HashMap();
        }
        this.handlerMap.put(string, httpAsyncRequestHandler);
        return this;
    }

    public final ServerBootstrap setExpectationVerifier(HttpAsyncExpectationVerifier httpAsyncExpectationVerifier) {
        this.expectationVerifier = httpAsyncExpectationVerifier;
        return this;
    }

    public final ServerBootstrap setConnectionFactory(NHttpConnectionFactory<? extends DefaultNHttpServerConnection> nHttpConnectionFactory) {
        this.connectionFactory = nHttpConnectionFactory;
        return this;
    }

    public final ServerBootstrap setSslContext(SSLContext sSLContext) {
        this.sslContext = sSLContext;
        return this;
    }

    public ServerBootstrap setSslSetupHandler(SSLSetupHandler sSLSetupHandler) {
        this.sslSetupHandler = sSLSetupHandler;
        return this;
    }

    public final ServerBootstrap setExceptionLogger(ExceptionLogger exceptionLogger) {
        this.exceptionLogger = exceptionLogger;
        return this;
    }

    public HttpServer create() {
        ExceptionLogger exceptionLogger;
        NHttpConnectionFactory<DefaultNHttpServerConnection> nHttpConnectionFactory;
        Iterator iterator;
        Object object;
        Object object2;
        HttpProcessor httpProcessor = this.httpProcessor;
        if (httpProcessor == null) {
            object2 = HttpProcessorBuilder.create();
            if (this.requestFirst != null) {
                object = this.requestFirst.iterator();
                while (object.hasNext()) {
                    iterator = (HttpRequestInterceptor)object.next();
                    ((HttpProcessorBuilder)object2).addFirst((HttpRequestInterceptor)((Object)iterator));
                }
            }
            if (this.responseFirst != null) {
                object = this.responseFirst.iterator();
                while (object.hasNext()) {
                    iterator = (HttpResponseInterceptor)object.next();
                    ((HttpProcessorBuilder)object2).addFirst((HttpResponseInterceptor)((Object)iterator));
                }
            }
            if ((object = this.serverInfo) == null) {
                object = "Apache-HttpCore-NIO/1.1";
            }
            ((HttpProcessorBuilder)object2).addAll(new ResponseDate(), new ResponseServer((String)object), new ResponseContent(), new ResponseConnControl());
            if (this.requestLast != null) {
                iterator = this.requestLast.iterator();
                while (iterator.hasNext()) {
                    nHttpConnectionFactory = (HttpRequestInterceptor)iterator.next();
                    ((HttpProcessorBuilder)object2).addLast((HttpRequestInterceptor)((Object)nHttpConnectionFactory));
                }
            }
            if (this.responseLast != null) {
                iterator = this.responseLast.iterator();
                while (iterator.hasNext()) {
                    nHttpConnectionFactory = (HttpResponseInterceptor)iterator.next();
                    ((HttpProcessorBuilder)object2).addLast((HttpResponseInterceptor)((Object)nHttpConnectionFactory));
                }
            }
            httpProcessor = ((HttpProcessorBuilder)object2).build();
        }
        if ((object2 = this.handlerMapper) == null) {
            object = new UriHttpAsyncRequestHandlerMapper();
            if (this.handlerMap != null) {
                iterator = this.handlerMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    nHttpConnectionFactory = (Map.Entry)iterator.next();
                    ((UriHttpAsyncRequestHandlerMapper)object).register((String)nHttpConnectionFactory.getKey(), (HttpAsyncRequestHandler)nHttpConnectionFactory.getValue());
                }
            }
            object2 = object;
        }
        if ((object = this.connStrategy) == null) {
            object = DefaultConnectionReuseStrategy.INSTANCE;
        }
        if ((iterator = this.responseFactory) == null) {
            iterator = DefaultHttpResponseFactory.INSTANCE;
        }
        if ((nHttpConnectionFactory = this.connectionFactory) == null) {
            nHttpConnectionFactory = this.sslContext != null ? new SSLNHttpServerConnectionFactory(this.sslContext, this.sslSetupHandler, this.connectionConfig) : new DefaultNHttpServerConnectionFactory(this.connectionConfig);
        }
        if ((exceptionLogger = this.exceptionLogger) == null) {
            exceptionLogger = ExceptionLogger.NO_OP;
        }
        HttpAsyncService httpAsyncService = new HttpAsyncService(httpProcessor, (ConnectionReuseStrategy)object, (HttpResponseFactory)((Object)iterator), (HttpAsyncRequestHandlerMapper)object2, this.expectationVerifier, exceptionLogger);
        return new HttpServer(this.listenerPort, this.localAddress, this.ioReactorConfig, httpAsyncService, (NHttpConnectionFactory<? extends DefaultNHttpServerConnection>)nHttpConnectionFactory, exceptionLogger);
    }
}

