/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.nio.client;

import com.icbc.api.internal.apache.http.ConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.HttpHost;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.HttpRequestInterceptor;
import com.icbc.api.internal.apache.http.HttpResponse;
import com.icbc.api.internal.apache.http.HttpResponseInterceptor;
import com.icbc.api.internal.apache.http.auth.AuthSchemeRegistry;
import com.icbc.api.internal.apache.http.client.AuthenticationStrategy;
import com.icbc.api.internal.apache.http.client.ClientProtocolException;
import com.icbc.api.internal.apache.http.client.CookieStore;
import com.icbc.api.internal.apache.http.client.CredentialsProvider;
import com.icbc.api.internal.apache.http.client.RedirectStrategy;
import com.icbc.api.internal.apache.http.client.UserTokenHandler;
import com.icbc.api.internal.apache.http.client.methods.HttpUriRequest;
import com.icbc.api.internal.apache.http.client.utils.URIUtils;
import com.icbc.api.internal.apache.http.concurrent.BasicFuture;
import com.icbc.api.internal.apache.http.concurrent.FutureCallback;
import com.icbc.api.internal.apache.http.conn.ConnectionKeepAliveStrategy;
import com.icbc.api.internal.apache.http.conn.routing.HttpRoutePlanner;
import com.icbc.api.internal.apache.http.cookie.CookieSpecRegistry;
import com.icbc.api.internal.apache.http.impl.DefaultConnectionReuseStrategy;
import com.icbc.api.internal.apache.http.impl.auth.BasicSchemeFactory;
import com.icbc.api.internal.apache.http.impl.auth.DigestSchemeFactory;
import com.icbc.api.internal.apache.http.impl.auth.KerberosSchemeFactory;
import com.icbc.api.internal.apache.http.impl.auth.NTLMSchemeFactory;
import com.icbc.api.internal.apache.http.impl.auth.SPNegoSchemeFactory;
import com.icbc.api.internal.apache.http.impl.client.BasicCookieStore;
import com.icbc.api.internal.apache.http.impl.client.BasicCredentialsProvider;
import com.icbc.api.internal.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import com.icbc.api.internal.apache.http.impl.client.DefaultRedirectStrategy;
import com.icbc.api.internal.apache.http.impl.client.DefaultUserTokenHandler;
import com.icbc.api.internal.apache.http.impl.client.ProxyAuthenticationStrategy;
import com.icbc.api.internal.apache.http.impl.client.TargetAuthenticationStrategy;
import com.icbc.api.internal.apache.http.impl.cookie.BestMatchSpecFactory;
import com.icbc.api.internal.apache.http.impl.cookie.BrowserCompatSpecFactory;
import com.icbc.api.internal.apache.http.impl.cookie.IgnoreSpecFactory;
import com.icbc.api.internal.apache.http.impl.cookie.NetscapeDraftSpecFactory;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2109SpecFactory;
import com.icbc.api.internal.apache.http.impl.cookie.RFC2965SpecFactory;
import com.icbc.api.internal.apache.http.impl.nio.DefaultHttpClientIODispatch;
import com.icbc.api.internal.apache.http.impl.nio.client.DefaultAsyncRequestDirector;
import com.icbc.api.internal.apache.http.impl.nio.client.DefaultResultCallback;
import com.icbc.api.internal.apache.http.impl.nio.client.InternalIOReactorExceptionHandler;
import com.icbc.api.internal.apache.http.impl.nio.client.InternalRequestExecutor;
import com.icbc.api.internal.apache.http.impl.nio.conn.DefaultHttpAsyncRoutePlanner;
import com.icbc.api.internal.apache.http.impl.nio.conn.PoolingClientAsyncConnectionManager;
import com.icbc.api.internal.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import com.icbc.api.internal.apache.http.impl.nio.reactor.IOReactorConfig;
import com.icbc.api.internal.apache.http.nio.NHttpClientEventHandler;
import com.icbc.api.internal.apache.http.nio.client.HttpAsyncClient;
import com.icbc.api.internal.apache.http.nio.client.methods.HttpAsyncMethods;
import com.icbc.api.internal.apache.http.nio.conn.ClientAsyncConnectionManager;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestExecutionHandler;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestExecutor;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.icbc.api.internal.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorException;
import com.icbc.api.internal.apache.http.nio.reactor.IOReactorStatus;
import com.icbc.api.internal.apache.http.params.HttpParams;
import com.icbc.api.internal.apache.http.protocol.BasicHttpContext;
import com.icbc.api.internal.apache.http.protocol.BasicHttpProcessor;
import com.icbc.api.internal.apache.http.protocol.DefaultedHttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.protocol.HttpProcessor;
import com.icbc.api.internal.apache.http.protocol.ImmutableHttpProcessor;
import java.io.IOException;
import java.net.URI;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public abstract class AbstractHttpAsyncClient
implements HttpAsyncClient {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientAsyncConnectionManager connmgr;
    private final Queue<HttpAsyncRequestExecutionHandler<?>> queue;
    private Thread reactorThread;
    private BasicHttpProcessor mutableProcessor;
    private ImmutableHttpProcessor protocolProcessor;
    private ConnectionReuseStrategy reuseStrategy;
    private ConnectionKeepAliveStrategy keepAliveStrategy;
    private RedirectStrategy redirectStrategy;
    private CookieSpecRegistry supportedCookieSpecs;
    private CookieStore cookieStore;
    private AuthSchemeRegistry supportedAuthSchemes;
    private AuthenticationStrategy targetAuthStrategy;
    private AuthenticationStrategy proxyAuthStrategy;
    private CredentialsProvider credsProvider;
    private HttpRoutePlanner routePlanner;
    private UserTokenHandler userTokenHandler;
    private HttpParams params;
    private volatile boolean terminated;

    protected AbstractHttpAsyncClient(ClientAsyncConnectionManager clientAsyncConnectionManager) {
        this.connmgr = clientAsyncConnectionManager;
        this.queue = new ConcurrentLinkedQueue();
    }

    protected AbstractHttpAsyncClient(IOReactorConfig iOReactorConfig) throws IOReactorException {
        DefaultConnectingIOReactor defaultConnectingIOReactor = new DefaultConnectingIOReactor(iOReactorConfig);
        defaultConnectingIOReactor.setExceptionHandler(new InternalIOReactorExceptionHandler(this.log));
        this.connmgr = new PoolingClientAsyncConnectionManager(defaultConnectingIOReactor);
        this.queue = new ConcurrentLinkedQueue();
    }

    protected abstract HttpParams createHttpParams();

    protected abstract BasicHttpProcessor createHttpProcessor();

    protected HttpContext createHttpContext() {
        BasicHttpContext basicHttpContext = new BasicHttpContext();
        basicHttpContext.setAttribute("http.scheme-registry", this.getConnectionManager().getSchemeRegistry());
        basicHttpContext.setAttribute("http.authscheme-registry", this.getAuthSchemes());
        basicHttpContext.setAttribute("http.cookiespec-registry", this.getCookieSpecs());
        basicHttpContext.setAttribute("http.cookie-store", this.getCookieStore());
        basicHttpContext.setAttribute("http.auth.credentials-provider", this.getCredentialsProvider());
        return basicHttpContext;
    }

    protected ConnectionReuseStrategy createConnectionReuseStrategy() {
        return new DefaultConnectionReuseStrategy();
    }

    protected ConnectionKeepAliveStrategy createConnectionKeepAliveStrategy() {
        return new DefaultConnectionKeepAliveStrategy();
    }

    protected AuthSchemeRegistry createAuthSchemeRegistry() {
        AuthSchemeRegistry authSchemeRegistry = new AuthSchemeRegistry();
        authSchemeRegistry.register("Basic", new BasicSchemeFactory());
        authSchemeRegistry.register("Digest", new DigestSchemeFactory());
        authSchemeRegistry.register("NTLM", new NTLMSchemeFactory());
        authSchemeRegistry.register("Negotiate", new SPNegoSchemeFactory());
        authSchemeRegistry.register("Kerberos", new KerberosSchemeFactory());
        return authSchemeRegistry;
    }

    protected CookieSpecRegistry createCookieSpecRegistry() {
        CookieSpecRegistry cookieSpecRegistry = new CookieSpecRegistry();
        cookieSpecRegistry.register("best-match", new BestMatchSpecFactory());
        cookieSpecRegistry.register("compatibility", new BrowserCompatSpecFactory());
        cookieSpecRegistry.register("netscape", new NetscapeDraftSpecFactory());
        cookieSpecRegistry.register("rfc2109", new RFC2109SpecFactory());
        cookieSpecRegistry.register("rfc2965", new RFC2965SpecFactory());
        cookieSpecRegistry.register("ignoreCookies", new IgnoreSpecFactory());
        return cookieSpecRegistry;
    }

    protected AuthenticationStrategy createTargetAuthenticationStrategy() {
        return new TargetAuthenticationStrategy();
    }

    protected AuthenticationStrategy createProxyAuthenticationStrategy() {
        return new ProxyAuthenticationStrategy();
    }

    protected CookieStore createCookieStore() {
        return new BasicCookieStore();
    }

    protected CredentialsProvider createCredentialsProvider() {
        return new BasicCredentialsProvider();
    }

    protected HttpRoutePlanner createHttpRoutePlanner() {
        return new DefaultHttpAsyncRoutePlanner(this.getConnectionManager().getSchemeRegistry());
    }

    protected UserTokenHandler createUserTokenHandler() {
        return new DefaultUserTokenHandler();
    }

    public final synchronized HttpParams getParams() {
        if (this.params == null) {
            this.params = this.createHttpParams();
        }
        return this.params;
    }

    public synchronized void setParams(HttpParams httpParams) {
        this.params = httpParams;
    }

    public synchronized ClientAsyncConnectionManager getConnectionManager() {
        return this.connmgr;
    }

    public final synchronized ConnectionReuseStrategy getConnectionReuseStrategy() {
        if (this.reuseStrategy == null) {
            this.reuseStrategy = this.createConnectionReuseStrategy();
        }
        return this.reuseStrategy;
    }

    public synchronized void setReuseStrategy(ConnectionReuseStrategy connectionReuseStrategy) {
        this.reuseStrategy = connectionReuseStrategy;
    }

    public final synchronized ConnectionKeepAliveStrategy getConnectionKeepAliveStrategy() {
        if (this.keepAliveStrategy == null) {
            this.keepAliveStrategy = this.createConnectionKeepAliveStrategy();
        }
        return this.keepAliveStrategy;
    }

    public synchronized void setKeepAliveStrategy(ConnectionKeepAliveStrategy connectionKeepAliveStrategy) {
        this.keepAliveStrategy = connectionKeepAliveStrategy;
    }

    public final synchronized RedirectStrategy getRedirectStrategy() {
        if (this.redirectStrategy == null) {
            this.redirectStrategy = new DefaultRedirectStrategy();
        }
        return this.redirectStrategy;
    }

    public synchronized void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
    }

    public final synchronized AuthSchemeRegistry getAuthSchemes() {
        if (this.supportedAuthSchemes == null) {
            this.supportedAuthSchemes = this.createAuthSchemeRegistry();
        }
        return this.supportedAuthSchemes;
    }

    public synchronized void setAuthSchemes(AuthSchemeRegistry authSchemeRegistry) {
        this.supportedAuthSchemes = authSchemeRegistry;
    }

    public final synchronized CookieSpecRegistry getCookieSpecs() {
        if (this.supportedCookieSpecs == null) {
            this.supportedCookieSpecs = this.createCookieSpecRegistry();
        }
        return this.supportedCookieSpecs;
    }

    public synchronized void setCookieSpecs(CookieSpecRegistry cookieSpecRegistry) {
        this.supportedCookieSpecs = cookieSpecRegistry;
    }

    public final synchronized AuthenticationStrategy getTargetAuthenticationStrategy() {
        if (this.targetAuthStrategy == null) {
            this.targetAuthStrategy = this.createTargetAuthenticationStrategy();
        }
        return this.targetAuthStrategy;
    }

    public synchronized void setTargetAuthenticationStrategy(AuthenticationStrategy authenticationStrategy) {
        this.targetAuthStrategy = authenticationStrategy;
    }

    public final synchronized AuthenticationStrategy getProxyAuthenticationStrategy() {
        if (this.proxyAuthStrategy == null) {
            this.proxyAuthStrategy = this.createProxyAuthenticationStrategy();
        }
        return this.proxyAuthStrategy;
    }

    public synchronized void setProxyAuthenticationStrategy(AuthenticationStrategy authenticationStrategy) {
        this.proxyAuthStrategy = authenticationStrategy;
    }

    public final synchronized CookieStore getCookieStore() {
        if (this.cookieStore == null) {
            this.cookieStore = this.createCookieStore();
        }
        return this.cookieStore;
    }

    public synchronized void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public final synchronized CredentialsProvider getCredentialsProvider() {
        if (this.credsProvider == null) {
            this.credsProvider = this.createCredentialsProvider();
        }
        return this.credsProvider;
    }

    public synchronized void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credsProvider = credentialsProvider;
    }

    public final synchronized HttpRoutePlanner getRoutePlanner() {
        if (this.routePlanner == null) {
            this.routePlanner = this.createHttpRoutePlanner();
        }
        return this.routePlanner;
    }

    public synchronized void setRoutePlanner(HttpRoutePlanner httpRoutePlanner) {
        this.routePlanner = httpRoutePlanner;
    }

    public final synchronized UserTokenHandler getUserTokenHandler() {
        if (this.userTokenHandler == null) {
            this.userTokenHandler = this.createUserTokenHandler();
        }
        return this.userTokenHandler;
    }

    public synchronized void setUserTokenHandler(UserTokenHandler userTokenHandler) {
        this.userTokenHandler = userTokenHandler;
    }

    protected final synchronized BasicHttpProcessor getHttpProcessor() {
        if (this.mutableProcessor == null) {
            this.mutableProcessor = this.createHttpProcessor();
        }
        return this.mutableProcessor;
    }

    private final synchronized HttpProcessor getProtocolProcessor() {
        if (this.protocolProcessor == null) {
            int n;
            BasicHttpProcessor basicHttpProcessor = this.getHttpProcessor();
            int n2 = basicHttpProcessor.getRequestInterceptorCount();
            HttpRequestInterceptor[] httpRequestInterceptorArray = new HttpRequestInterceptor[n2];
            for (n = 0; n < n2; ++n) {
                httpRequestInterceptorArray[n] = basicHttpProcessor.getRequestInterceptor(n);
            }
            n = basicHttpProcessor.getResponseInterceptorCount();
            HttpResponseInterceptor[] httpResponseInterceptorArray = new HttpResponseInterceptor[n];
            for (int i = 0; i < n; ++i) {
                httpResponseInterceptorArray[i] = basicHttpProcessor.getResponseInterceptor(i);
            }
            this.protocolProcessor = new ImmutableHttpProcessor(httpRequestInterceptorArray, httpResponseInterceptorArray);
        }
        return this.protocolProcessor;
    }

    public synchronized int getResponseInterceptorCount() {
        return this.getHttpProcessor().getResponseInterceptorCount();
    }

    public synchronized HttpResponseInterceptor getResponseInterceptor(int n) {
        return this.getHttpProcessor().getResponseInterceptor(n);
    }

    public synchronized HttpRequestInterceptor getRequestInterceptor(int n) {
        return this.getHttpProcessor().getRequestInterceptor(n);
    }

    public synchronized int getRequestInterceptorCount() {
        return this.getHttpProcessor().getRequestInterceptorCount();
    }

    public synchronized void addResponseInterceptor(HttpResponseInterceptor httpResponseInterceptor) {
        this.getHttpProcessor().addInterceptor(httpResponseInterceptor);
        this.protocolProcessor = null;
    }

    public synchronized void addResponseInterceptor(HttpResponseInterceptor httpResponseInterceptor, int n) {
        this.getHttpProcessor().addInterceptor(httpResponseInterceptor, n);
        this.protocolProcessor = null;
    }

    public synchronized void clearResponseInterceptors() {
        this.getHttpProcessor().clearResponseInterceptors();
        this.protocolProcessor = null;
    }

    public synchronized void removeResponseInterceptorByClass(Class<? extends HttpResponseInterceptor> clazz) {
        this.getHttpProcessor().removeResponseInterceptorByClass(clazz);
        this.protocolProcessor = null;
    }

    public synchronized void addRequestInterceptor(HttpRequestInterceptor httpRequestInterceptor) {
        this.getHttpProcessor().addInterceptor(httpRequestInterceptor);
        this.protocolProcessor = null;
    }

    public synchronized void addRequestInterceptor(HttpRequestInterceptor httpRequestInterceptor, int n) {
        this.getHttpProcessor().addInterceptor(httpRequestInterceptor, n);
        this.protocolProcessor = null;
    }

    public synchronized void clearRequestInterceptors() {
        this.getHttpProcessor().clearRequestInterceptors();
        this.protocolProcessor = null;
    }

    public synchronized void removeRequestInterceptorByClass(Class<? extends HttpRequestInterceptor> clazz) {
        this.getHttpProcessor().removeRequestInterceptorByClass(clazz);
        this.protocolProcessor = null;
    }

    private void doExecute() {
        InternalRequestExecutor internalRequestExecutor = new InternalRequestExecutor(this.log, new HttpAsyncRequestExecutor());
        try {
            DefaultHttpClientIODispatch defaultHttpClientIODispatch = new DefaultHttpClientIODispatch((NHttpClientEventHandler)internalRequestExecutor, this.getParams());
            this.connmgr.execute(defaultHttpClientIODispatch);
        }
        catch (Exception exception) {
            this.log.error((Object)"I/O reactor terminated abnormally", (Throwable)exception);
        }
        finally {
            this.terminated = true;
            while (!this.queue.isEmpty()) {
                HttpAsyncRequestExecutionHandler<?> httpAsyncRequestExecutionHandler = this.queue.remove();
                httpAsyncRequestExecutionHandler.cancel();
            }
        }
    }

    public IOReactorStatus getStatus() {
        return this.connmgr.getStatus();
    }

    public synchronized void start() {
        this.reactorThread = new Thread(){

            @Override
            public void run() {
                AbstractHttpAsyncClient.this.doExecute();
            }
        };
        this.reactorThread.start();
    }

    public void shutdown() throws InterruptedException {
        try {
            this.connmgr.shutdown(5000L);
        }
        catch (IOException iOException) {
            this.log.error((Object)"I/O error shutting down", (Throwable)iOException);
        }
        if (this.reactorThread != null) {
            this.reactorThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, HttpContext httpContext, FutureCallback<T> futureCallback) {
        DefaultAsyncRequestDirector<T> defaultAsyncRequestDirector;
        if (this.terminated) {
            throw new IllegalStateException("Client has been shut down");
        }
        BasicFuture<T> basicFuture = new BasicFuture<T>(futureCallback);
        DefaultResultCallback<T> defaultResultCallback = new DefaultResultCallback<T>(basicFuture, this.queue);
        AbstractHttpAsyncClient abstractHttpAsyncClient = this;
        synchronized (abstractHttpAsyncClient) {
            HttpContext httpContext2 = this.createHttpContext();
            HttpContext httpContext3 = httpContext == null ? httpContext2 : new DefaultedHttpContext(httpContext, httpContext2);
            defaultAsyncRequestDirector = new DefaultAsyncRequestDirector<T>(this.log, httpAsyncRequestProducer, httpAsyncResponseConsumer, httpContext3, defaultResultCallback, this.connmgr, this.getProtocolProcessor(), this.getRoutePlanner(), this.getConnectionReuseStrategy(), this.getConnectionKeepAliveStrategy(), this.getRedirectStrategy(), this.getTargetAuthenticationStrategy(), this.getProxyAuthenticationStrategy(), this.getUserTokenHandler(), this.getParams());
        }
        this.queue.add(defaultAsyncRequestDirector);
        defaultAsyncRequestDirector.start();
        return basicFuture;
    }

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer httpAsyncRequestProducer, HttpAsyncResponseConsumer<T> httpAsyncResponseConsumer, FutureCallback<T> futureCallback) {
        return this.execute(httpAsyncRequestProducer, httpAsyncResponseConsumer, (HttpContext)new BasicHttpContext(), futureCallback);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext, FutureCallback<HttpResponse> futureCallback) {
        return this.execute(HttpAsyncMethods.create(httpHost, httpRequest), HttpAsyncMethods.createConsumer(), httpContext, futureCallback);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost httpHost, HttpRequest httpRequest, FutureCallback<HttpResponse> futureCallback) {
        return this.execute(httpHost, httpRequest, (HttpContext)new BasicHttpContext(), futureCallback);
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest httpUriRequest, FutureCallback<HttpResponse> futureCallback) {
        return this.execute(httpUriRequest, new BasicHttpContext(), futureCallback);
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest httpUriRequest, HttpContext httpContext, FutureCallback<HttpResponse> futureCallback) {
        HttpHost httpHost;
        try {
            httpHost = this.determineTarget(httpUriRequest);
        }
        catch (ClientProtocolException clientProtocolException) {
            BasicFuture<HttpResponse> basicFuture = new BasicFuture<HttpResponse>(futureCallback);
            basicFuture.failed(clientProtocolException);
            return basicFuture;
        }
        return this.execute(httpHost, httpUriRequest, httpContext, futureCallback);
    }

    private HttpHost determineTarget(HttpUriRequest httpUriRequest) throws ClientProtocolException {
        HttpHost httpHost = null;
        URI uRI = httpUriRequest.getURI();
        if (uRI.isAbsolute() && (httpHost = URIUtils.extractHost(uRI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + uRI);
        }
        return httpHost;
    }
}

